      subroutine streamlines (p,u,v, mm,m,n, smin,smax, icolor)
!
! Draws a stremline plot from a vector field.
! input: u,v   Vector components in the first and second directions.
!        p     Array of scalar data that may used to color the
!                     streamlines (usually, vector magnitude).
!        mm    Size of the first dimension in the calling program.
!        m,n   Numbers elements (which are actually used) in the
!                        first and second dimensions.
!
!       smin,smax   Minimum and maximum vector magnitudes to plot
!
!       icolor   Vector color switch:
!                icolor=0  foreground color: black or white.
!                icolor=1  Use NCL colors in palette.
!                icolor=2  one color overlay.
!
! Copyright (c) 1998 Rutgers University
!
      implicit none
      integer icolor, m, mm, n
      real u(mm,n),v(mm,n), p(mm,n), smin,smax
      external colram, stumsl
#include "param.h"
#include "pconst.h"
#include "cntwkspa.h"
#include "fmask.h"
#include "pltfld.h"
#include "pltncar.h"
!
! Reset all STREAM parameters to their default values to facilitate
! overlays.
!
      call strset
!
! Initialize area map.
!
      call arinam (iam,lam)

c      if (lland) then
c        call landmask
c        call arpram (iam,0,0,0)
c        call arscam (iam,xcs,ycs,mcs,iai,iag,mai,colram)
c      endif
!
! Set STREAMLINES drawing options.
!---- ----------- ------- --------
! Prevent STREAM from setting the viewport.
!
      call stseti ('SET - do-set-call flag',0)
c*    call stseti ('SST - streamline statistics output flag',1)
!
! Set mapping to that provided by the User. Set up data coordinate
! boundaries.
!
      if (spherical) then
        call stseti ('MAP - mapping flag',3)
        call stsetr ('XC1 - Lower X Bound',1.)
        call stsetr ('XCM - Upper X Bound',float(m))
        call stsetr ('YC1 - Lower Y Bound',1.)
        call stsetr ('YCN - Upper Y Bound',float(n))
      else
        call stseti ('MAP - mapping flag',4)
        call stsetr ('XC1 - Lower X Bound',ul)
        call stsetr ('XCM - Upper X Bound',ur)
        call stsetr ('YC1 - Lower Y Bound',ub)
        call stsetr ('YCN - Upper Y Bound',ut)
      endif
!
! Set streamline parameters.
!
      call stsetr ('LWD - Streamline Line Width',1.0)
      call stseti ('TRP - Interpolation Method', 1)
      call stsetr ('SSP - Stream Spacing', 0.005)
      call stsetr ('DFM - Differential Magnitude', 0.005)
      call stseti ('AGD - Arrow Grid Increment', 3)
      call stseti ('SGD - Stream Grid Increment', 3)
!
! Set special value processing appropriately for the vector field.
!
      call stseti ('SVF - Special Values Flag', 3)
      call stsetr ('USV - U Special Value',spval1)
      call stsetr ('VSV - V Special Value',spval1)
!
! Set up masking of streamlines to an existing area map.
!
      if (lland) then
        call stseti ('MSK - Mask to area map flag',1)
      else
        call stseti ('MSK - Mask to area map flag',0)
      endif
!
! Set up streamline color processing for overlay plots.
!
      if (icolor.gt.1) call gsplci (ncl+4)
!
! Initialize streamlines.
!
      call stinit (u,mm,v,mm,p,mm,m,n,rwrk,lrwk)
!
! Draw streamlines
!
      call stream (u,v,p,iam,stumsl,rwrk)
!
! Set polyline color back to its foreground color.
!
      if (icolor.gt.0) call gsplci (1)
      return
      end
