! WARNING: Common block stmap defined in this file is designed to
!          match internal common block defined inside NCAR graphics
!          library.
!
! THERE MUST BE NO ALTERATION OF THIS FILE UNDER ANY CIRCUMSTANCES.
!
! NOTE: all these variables should be considered read-only 
!
! Description of STMAP content:
!------------ -- ----- --------
! imap                - value of the internal parameter 'MAP'
! xvpl,xvpr,yvpb,yvpt - the currently set viewport values. (GETSET
!                       arguments 1, 2, 3, and 4)
! wxmn,wxmx,wymn,wymx - the min and max boundaries of user coordinate
!                       space, (usually but not always equivalent to
!                       window coordinates). WXMN and WYMN are true
!                       minimum values even one or both axes is
!                       inverted. (i.e. they are equivalent to GETSET
!                       arguments 5,6,7, and 8 sorted numerically)
! xlov,xhiv,ylov,yhiv - min and max boundaries of the data space, by
!                       default equivalent to the array grid space.
!                       XLOV and YLOV are not necessarily less than
!                       XHIV and YHIV.
! nxct,nyct           - Length of each dimension of the U and V
!                       component arrays.
! lnlg                - The linear/log mode (GETSET argument 9)
! invx,invy           - User coordinates inversion flags:
!                       0 - not inverted, 1 - inverted
! itrt                - value of the internal parameter TRT
! iwct                - not currently used
! fw2w,fh2h           - scale factors for converting from fraction of
!                       viewport width/height to NDC width/height
! rbig,ibig           - machine dependent maximum REAL/INTEGER values
!
!
      integer imap, lnlg, invx, invy,  nxct, nyct, itrt, ibig
      real                             xlov, xhiv, ylov, yhiv
      real    wxmn, wxmx, wymn, wymx,  xvpl, xvpr, yvpb, yvpt
      real    xgds, ygds, vnml, rbig,        fw2w, fh2h, dfmg

      common /stmap/
     &        imap, lnlg, invx, invy,  xlov, xhiv, ylov, yhiv,
     &        wxmn, wxmx, wymn, wymx,  xvpl, xvpr, yvpb, yvpt,
     &        xgds, ygds, nxct, nyct,  itrt, fw2w, fh2h, dfmg,
     &                    vnml, rbig,                    ibig
      save /stmap/
!
! Math constants:
!
      real pdtor, prtod, p1xpi, p2xpi, p1d2pi, p5d2pi
      parameter (pdtor=0.017453292519943, prtod=57.2957795130823,
     &           p1xpi=3.14159265358979,  p2xpi=6.28318530717959,
     &           p1d2pi=1.57079632679489, p5d2pi=7.85398163397448)


