      subroutine set_palette
!
! Read color palette file and set up color pallette by calling NCAR
! graphics routine. Depending of pallette type, the following values 
! from the pallette file are accepted.
!
!    icolor = 0              background color
!           = 1              foregound color
!           = 2,...,ncl+1    NCL color levels to apply
!           = ncl+2          color for land areas
!           = ncl+3          color for water areas
!           = ncl+4          color for polyline overlays
!
      implicit none
      real cff, R,G,B, dxi
      integer indx, icolor, line, ierr, lstr,lenstr
#include "pltfld.h"
#include "pltio.h"
#include "pltncar.h"

      if (palette(1:4) .eq. 'none') then 
        write(*,'(/1x,2A/)') 'Setting default color palette a''',
     &                              'la Matlab ''Jet'' colorbar.'
        ncl=32
        dxi=1./float(ncl)
        do icolor=0,ncl+4
          if (icolor .eq. 0) then  !--> background color
            R=1.
            G=1.
            B=1.
          elseif (icolor .eq.1) then  !--> foreground color
            R=0.
            G=0.
            B=0.
          elseif (icolor .eq. ncl+2) then  !--> land color
            R=0.75
            G=0.75
            B=0.75
          elseif (icolor .eq. ncl+3) then  !--> water color
            R=0.93
            G=0.93
            B=0.93
          elseif (icolor .eq. ncl+4) then  !--> overlay color
            R=0.
            G=0.
            B=0.
          else           !--> MatLab "jet" color pallette.
            cff=dxi*(float(icolor-1)-0.5)
            R=max(0., min(1., 1.53125-4.*abs(cff-0.75) ))
            G=max(0., min(1., 1.53125-4.*abs(cff-0.50) ))
            B=max(0., min(1., 1.53125-4.*abs(cff-0.25) ))
          endif
          call gscr (1, icolor, R,G,B)
        enddo
      else
!
! Read color pallete from specified palette file
!
#if VERBOSE >2
        write(*,'(1x,A$)') 'Setting up color palette...'
#endif
        lstr=lenstr(palette)
        open (unit=inppal, file=palette(1:lstr), form='formatted',
     &                                       status='old', err=98)
        line=1
        read(inppal,*,iostat=ierr) ncl
        if (ierr.ne.0) goto 99

        if (ncl.gt.255) then
          write(stdout,'(/1x,A,1x,A,I5)') 'SET_PALETTE ERROR:',
     &              'only 255 colors are allowed, NCL = ',  ncl
          stop
        endif
!
! Read and  backgound, foreground,and NCL color bands.
!
        cff=1./256.
        do icolor=0,ncl+4
          line=line+1
          read(inppal,*,iostat=ierr) indx, R,G,B
          if (R.gt.1.) R=R*cff
          if (G.gt.1.) G=G*cff
          if (B.gt.1.) B=B*cff
          if (ierr.eq.0) then 
c            if (postscript) then
c              if (icolor.eq.0) then
c                R=1.
c                G=1.
c                B=1.
c              elseif (icolor.eq.1) then
c                R=0.
c                G=0.
c                B=0.
c              endif
c            endif
            call gscr (1, icolor, R,G,B)
          else
            goto 99
          endif
        enddo
        close (inppal)
#if VERBOSE > 2
        write(*,'(4x,A)') '...done.'
#endif
      endif
      return
  98  write(*,'(/1x,4A)') 'SET_PALETTE ERROR: Can not open ',
     &              'palette file ''', palette(1:lstr), '''.' 
      stop
  99  write(*,'(/1x,3A,I3,A)')    'Error in palette file ''',
     &               palette(1:lstr), ''' on line', line, '.'
      stop
      end
