      subroutine sec_set_frame (icolor, ipos)
!
! Set viewport space for the current section map on the page.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer icolor, ipos, i
      real Xbar,Ybar
#include "param.h"
#include "fields.h"
#include "pltio.h"
#include "pltfld.h"
#include "pltncar.h"
#include "secpos.h"
#include "secbath.h"
#include "cntwkspa.h"
                                          ! Set viewport according
      call viewport (icolor, Xbar,Ybar)   ! to the number of maps per
      if (ipos.eq.1) then                 ! page. Then create margin
        fr=fr-Xbar                        ! on the right or near the
      elseif (ipos.eq.0) then             ! bottom to accomodate
        fb=fb+Ybar                        ! color bar.
      endif
!
! Check dimensions of work arrays, if OK, save bottom line
! coordinates into into arrays xra,yra, determine top and
! bottom bounds and set plotting frame.
!
      if (ims+3.gt.mcs) then
        write(*,'(/2x,2A,2(/19x,A,I6,A)/)') 'ERROR: SEC_FRAME ',
     &           'Unsufficient scratch array dimension ''mcs''',
     &           'in common block ''cntwkspa'', mcs =',mcs, ',',
     &           'needs to be least ', ims+3, '.'
        stop
      endif
      if (abs(szbot) .gt. abs(sztop)) then    ! Accept top and bottom
        ut=-abs(sztop)                        ! limits specified in
        ub=-abs(szbot)                        ! the input file.
        do i=1,ims
          xra(i)=x(i)
          yra(i)=-max(min( abs(sbth(i)), abs(szbot)), abs(sztop))
        enddo
      else
        ut=0.                                 ! Dynamically find top
        ub=0.                                 ! and bottom limits to
        do i=1,ims                            ! accomodate the whole
          xra(i)=x(i)                         ! depth.
          yra(i)=-abs(sbth(i))
          ub=min(ub, yra(i))
        enddo
      endif

c**   if (x(1).lt.x(ims)) then
       ul=x(1)                               ! Set plotting frame.
       ur=x(ims)
c**   else
c**     ul=x(ims)
c**     ur=x(1)
c**   endif
      call set (fl,fr,fb,ft, ul,ur,ub,ut, 1)

#if VERBOSE > 1
      write(6,'(/2x,A,I7,9x,A,I7,4(/14x,A,F12.4,4x,A,F12.4)/)')
     &   'SEC_FRAME - plots/page   =',npage, 'current plot =',ipltpg,
     &               'frame left   =',   fl, 'frame right  =',    fr,
     &               'frame bottom =',   fb, 'frame top    =',    ft,
     &               'box Xmin     =',   ul, 'box Xmax     =',    ur,
     &               'box Zmin     =',   ub, 'box Zmax     =',    ut
#endif
!
! Fill area above bottom line with water color (color plot only) and
! area below it with ground color or an appropriate land mask color
! or filling pattern.
!
      nra=ims+3
      xra(ims+1)=xra(ims)                    ! Close contour in such
      yra(ims+1)=ut                          ! that it ecloses area 
      xra(ims+2)=xra(1)                      ! above the bottom line
      yra(ims+2)=yra(ims+1)
      xra(ims+3)=xra(1)
      yra(ims+3)=yra(1)                      ! Fill the section part 
      if (icolor.ne.0) then                  ! above the bottom line 
        call gsfaci(ncl+3)                   ! with water color 
        call gfa(nra,xra,yra)                ! (color plot only) 
      endif
                                             ! Switch contour to
      yra(ims+1)=ub                          ! enclose area below
      yra(ims+2)=yra(ims+1)                  ! the bottom line and 
      if (icolor.ne.0) then                  ! fill it. 
        call gsfaci(ncl+2)
        call gfa(nra,xra,yra)
      elseif (ifill.eq.0) then
        call gscr (1,2, 0.75,0.75,0.75)
        call gsfaci (2)
        call gfa(nra,xra,yra)
      else
        call areafill (ifill)
      endif
      return
      end
