      subroutine sec_rotvec (sec,u,v,im,km,idfld,spval)
!
! Rotat horizontal vector components to the requested direction of
! vertical cross-section (making them be parallel and perpendicular
! to local direction of the section).
!
! input: u,v    U,V-vector components (real arrays)
!        im     number of section points in the XY-plane (integer)
!        kms    number of section points in the Z-direction (integer)
!        idfld  identification of field to read (integer)              ===
!        spval  special value to flag missing data (real)
!
! output: sec requested rotated vector component (real array)
!         u,v  rotated U,V-vector components (real arrays)
!
! Copyright (c) 1998 Rutgers University
!
      implicit none
#include "param.h"
#include "pconst.h"
#include "fldsid.h"
#include "secpos.h"
      integer im,km, idfld,  i,k
      real sec(im,km), u(im,km),v(im,km), spval,
     &     dist,alpha, csA(NX),snA(NX), urot,vrot
!
! Get rotation angle, then rotate components:
!
      if (isecpos.eq.2) then
        do i=1,im-1
          call geodesic_dist (xsec(i),ysec(i), xsec(i+1),ysec(i+1),
     &                                              4, dist, alpha)
          csA(i)=cos(deg2rad*alpha)
          snA(i)=sin(deg2rad*alpha)
        enddo
        csA(im)=csA(im-1)
        snA(im)=snA(im-1)
        do k=1,km
          do i=1,im
            if (u(i,k).ne.spval .and. v(i,k).ne.spval) then
              urot=u(i,k)*csA(i)-v(i,k)*snA(i)
              vrot=u(i,k)*snA(i)+v(i,k)*csA(i)
              u(i,k)=urot
              v(i,k)=vrot
            endif
          enddo
        enddo
      endif

      if (vcode(idfld).eq.'IDUTOT' .or.     ! Load
     &    vcode(idfld).eq.'IDUCLI') then    ! requested
        do k=1,km                           ! rotated
          do i=1,im                         ! component.
            sec(i,k)=u(i,k)
          enddo
        enddo
      else
        do k=1,km
          do i=1,im
            sec(i,k)=v(i,k)
          enddo
        enddo
      endif      
      return
      end
