      subroutine sec_end_frame (im,jm)
!
! Set and draw axis for the cross-section box.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer im,jm, i,is,  n, nmin,nmax, lstr,
     &        lenXL, lenXR, lenYL, lenYR, lenstr
      real fontsize,ylab, d,delta, offstX,offstY,
     &     cff1,cff2, XL,XR,YL,YR
      character labX*6,  ssXL*18, ssXR*18,
     &          labY*4,  ssYL*8,  ssYR*8
#include "param.h"
#include "pltncar.h"
#include "pltfld.h"
#include "secpos.h"
#include "cntwkspa.h"

      fontsize=0.01*basesize
      offstX=0.005*(ut-ub)/(ft-fb)
      offstY=0.005*(ur-ul)/(fr-fl)

      call gslwsc (thick_line)           ! Draw bottom line
      call curve (xra,yra,nra-3)         ! and box around 
      call gslwsc (medium_line)          ! section.
      call line (ul,ub, ur,ub)
      call line (ur,ub, ur,ut)
      call line (ur,ut, ul,ut)
      call line (ul,ut, ul,ub)
!
! Draw horizontal axis major and minor tick marks.
!===== ========== ==== ===== === ===== ==== ======
!
      if (ltmarks) then
        if (spherical .and. axistype.eq.1) then
          call chose_scale (xsec(1),xsec(ims), delta, nmin,nmax)
        elseif (spherical .and. axistype.eq.2) then
          call chose_scale (ysec(1),ysec(ims), delta, nmin,nmax)
        else
          call chose_scale (ul,ur, delta, nmin,nmax)
        endif

        do n=nmin,nmax                   ! Generate label
          d=delta*n
          if (mod(n,5) .eq. 0) then
            if (spherical) then
              write(labX,'(i5)') abs(int(d))
              lstr=lenstr(labX)
              if (axistype.eq.1 .and. d.lt.0.) then
                labX=labX(1:lstr)/ /'W'
              elseif (axistype.eq.1 .and. d.gt.0.) then
                labX=labX(1:lstr)/ /'E'
              elseif (axistype.eq.2 .and. d.lt.0.) then
                labX=labX(1:lstr)/ /'S'
              elseif (axistype.eq.2 .and. d.gt.0.) then
                labX=labX(1:lstr)/ /'N'
              else                       ! Once label is generated,
                labX=labX(1:lstr)        ! in the case when "d" has
              endif                      ! meaning of longitude or
                                         ! latitude, it needs to be
              if (axistype.eq.1) then    ! converted to coordinate
                is=0                     ! along section.
                do i=1,ims-1
                  if ((xsec(i+1)-d)*(d-xsec(i)) .ge.0.) is=i
                enddo
                if (is.gt.0) then
                  cff1=((xsec(is+1)-d)*xra(is)+xra(is+1)*(d-xsec(is))
     &                                        )/(xsec(is+1)-xsec(is))
                  d=cff1
                else
                  write(*,*) 'Algorithm error X in ''sec_axis.F''.'
                  stop
                endif
              elseif (axistype.eq.2) then
                is=0
                do i=1,ims-1
                  if ((ysec(i+1)-d)*(d-ysec(i)) .ge.0.) is=i
                enddo
                if (is.gt.0) then
                  cff1=((ysec(is+1)-d)*xra(is)+xra(is+1)*(d-ysec(is))
     &                                        )/(ysec(is+1)-ysec(is))
                  d=cff1
                else
                  write(*,*) 'Algorithm error Y in ''sec_axis.F''.'
                  stop
                endif
              endif

            else
              write(labX,'(i5)') int(d)
            endif
            lstr=lenstr(labX)
            call plchhq (d,ub-2.*offstX, labX(1:lstr),fontsize,0.,0.)
            cff1=ut-2.*offstX
            cff2=ub+2.*offstX
          else
            cff1=ut-offstX              ! Minor tick mark
            cff2=ub+offstX
          endif
          call line (d,ut, d,cff1)
          call line (d,ub, d,cff2)
        enddo
!
! Draw vertical axis minor tick marks.
!===== ======== ==== ===== ==== ======
!
        call chose_scale (ub, ut, delta, nmin,nmax)
        do n=nmin,nmax
          d=delta*n
          if (mod(n,5).eq.0) then
            if (fl .lt. 0.5) then
              write(labY,'(i4)') int(abs(d))
              call plchhq (ul-1.5*offstY, d, labY, fontsize, 0., +1.)
            endif
            cff1=ul+2.5*offstY
            cff2=ur-2.5*offstY
          else
            cff1=ul+offstY
            cff2=ur-offstY
          endif
          call line (ul,d, cff1,d)
          call line (ur,d, cff2,d)
        enddo
!
! Write starting and ending section points label.
!
        if (.not.spherical .or. secaxis.eq.0) then
          XL=xsec1
          YL=ysec1
          XR=xsec2        
          YR=ysec2

          if (isecpos.eq.0) then
            if (int(xsec1).lt.1) XL=1.
            if (int(ysec1).lt.1) YL=1.
            if (int(xsec2).lt.1) XR=1.
            if (int(ysec2).lt.1) YR=1.

            if (xsec1-aint(xsec1).eq.0 .and.
     &          ysec1-aint(ysec1).eq.0) then
              if (int(xsec1).gt.im-1) XL=float(im-1)
              if (int(ysec1).gt.jm-1) YL=float(jm-1)
            else
              if (int(xsec1).gt.im) XL=float(im)
              if (int(ysec1).gt.jm) YL=float(jm)
            endif
            if (xsec2-aint(xsec2).eq.0 .and.
     &          ysec2-aint(ysec2).eq.0) then
              if (int(xsec2).gt.im-1) XR=float(im-1)
              if (int(ysec2).gt.jm-1) YR=float(jm-1)
            else
              if (int(xsec2).gt.im) XR=float(im)
              if (int(ysec2).gt.jm) YR=float(jm)
            endif
            write(ssXL,'(A2,I6)') 'i=', int(XL)
            write(ssYL,'(A2,I6)') 'j=', int(YL)
            write(ssXR,'(A2,I6)') 'i=', int(XR)
            write(ssYR,'(A2,I6)') 'j=', int(YR)
          elseif (isecpos.eq.1) then
            write(ssXL,'(A2,F6.2)') 'X=', XL
            write(ssYL,'(A2,F6.2)') 'Y=', YL
            write(ssXR,'(A2,F6.2)') 'X=', XR
            write(ssYR,'(A2,F6.2)') 'Y=', YR
          elseif (isecpos.eq.2) then
            if (xsec1.gt.180.) XL=xsec1-360.
            if (xsec2.gt.180.) XR=xsec2-360.
            if (XL.lt.0.) then
              write(ssXL,'(F6.2,A2)') -XL,' W'
            else
              write(ssXL,'(F6.2,A2)')  XL,' E'
            endif
            if (YL.lt.0.) then
              write(ssYL,'(F6.2,A2)') -YL,' S'
            else
              write(ssYL,'(F6.2,A2)')  YL,' N'
            endif
            if (XR.lt.0.) then
              write(ssXR,'(F6.2,A2)') -XR,' W'
            else
              write(ssXR,'(F6.2,A2)')  XR,' E'
            endif
            if (YR.lt.0.) then
              write(ssYR,'(F6.2,A2)') -YR,' S'
            else
              write(ssYR,'(F6.2,A2)')  YR,' N'
            endif
          endif

          call clean_string (ssXL, 8, lenXL)
          call clean_string (ssYL, 8, lenYL)
          call clean_string (ssXR, 8, lenXR)
          call clean_string (ssYR, 8, lenYR)

          ssXL(lenXL+1:lenXL+lenYL+2) = ', '/ /ssYL(1:lenYL)
          ssXR(lenXR+1:lenXR+lenYR+2) = ', '/ /ssYR(1:lenYR)

          ylab=ut+0.012*(ut-ub)/(ft-fb)
          call plchhq (ul,ylab, ssXL(1:lenXL+lenYL+2),
     &                               fontsize, 0.,-1.)
          call plchhq (ur,ylab, ssXR(1:lenXR+lenYR+2),
     &                               fontsize, 0.,+1.)
        endif
      endif
      return
      end
