      subroutine ri_number (Rig, bvf, u,v, z_r, im,jm,km)
!
! Compute gradient Richardson number.
!
! Output: Rig   gradient Richardson number at horizontal RHO-points
!               and vertical W-points (non-dimensional).
!
! Input:  bvf   Brunt-Vaisala frequency (1/s^2).
!         u     velocity component in the XI-direction (m/s).
!         v     velocity component in the ETA-direction (m/s).
!         z_r   Depth (m) at RHO-points.
!         im    Number of points in the XI-direction.
!         jm    Number of points in the ETA-direction.
!         km    Number of points in the S-direction.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer im,jm,km, i,j,k 
      real Rig(im-1,jm-1,km-1), u(im,0:jm,km), z_r(0:im,0:jm,km),
     &     bvf(0:im,0:jm,km-1), v(0:im,jm,km), dz, du,dv, shear2, 
     &     Ri_min, Ri_max
      parameter (Ri_min=0., Ri_max=2.)

      do k=1,km-1
        do j=1,jm-1
          do i=1,im-1
!
! Compute horizontal velocity shear squared, (du/dz)^2 + (dv/dz)^2,
! at horizontal RHO-points and vertical W-points.
!
            dz=z_r(i,j,k+1)-z_r(i,j,k)
            du=u(i,j,k+1)-u(i,j,k)+u(i+1,j,k+1)-u(i+1,j,k)
            dv=v(i,j,k+1)-v(i,j,k)+v(i,j+1,k+1)-v(i,j+1,k)

            shear2=0.25*(du*du+dv*dv)/(dz*dz)
!
! Compute gradient Richardson number at horizontal RHO-points and
! vertical W-points.  Mask values if zero velocity shear squared.
! Bound Richardson number by a low a high threshold values.
!
            shear2=max(1.E-10,shear2)

            Rig(i,j,k)=max(Ri_min, min(Ri_max, bvf(i,j,k)/shear2))
          enddo
        enddo
      enddo
      return
      end
