      subroutine relvor (rvor, L,M,N, u,v, pm,pn, spval)
!
! Compute relative vorticity.
!
! input: L        Number of grid points in the XI-direction.
!        M        Number of grid points in the ETA-direction.
!        N        Number of vertical levels.
!        u        vector component (m/s) in the XI-direction.
!        v        vector component (m/s) in the ETA-direction.
!        Hz       total depth or vertical thicknesses (m).
!        pm       Coordinate transformation metric "m" (1/meters)
!                 associated with the differential distances in XI.
!        pn       Coordinate transformation metric "n" (1/meters)
!                 associated with the differential distances in ETA.
!        spval    Masked special value.
!
! output: rvor    Relative vorticity (1/s)
!
! Copyright (c) 1997 Rutgers University
!
      implicit none
      integer L,M,N, i,j,k
      real rvor(L,M,N), u(L,0:M,N),v(0:L,M,N),
     &        pm(0:L,0:M),pn(0:L,0:M), spval
!
! Compute relative vorticity m*n*[d(v/n)d(xi) - d(u/m)d(eta)]
!
! NOTE: as rule of thumb, it should be realized that the expression
! which envolves u's and v's is nothing else, but circulation around
! the perimeter of finite-volume grid cell around PSI (vorticity)
! point. Hence each velocity component is multiplied by the length of
! facet along which it flows.
!
      do k=1,N
        do j=1,M
          do i=1,L
            if (u(i,j,k).eq.spval .or. u(i,j-1,k).eq.spval .or.
     &          v(i,j,k).eq.spval .or. v(i-1,j,k).eq.spval) then
              rvor(i,j,k)=spval
            else
              rvor(i,j,k)=0.125*( v(i  ,j,k)/(pn(i,j-1)+pn(i,j))
     &                           -v(i-1,j,k)/(pn(i-1,j)+pn(i-1,j-1))

     &                           -u(i,j  ,k)/(pm(i-1,j)+pm(i,j))
     &                           +u(i,j-1,k)/(pm(i-1,j-1)+pm(i,j-1))

     &                   )*(pm(i-1,j-1)+pm(i,j-1)+pm(i,j)+pm(i-1,j))
     &                    *(pn(i-1,j-1)+pn(i,j-1)+pn(i,j)+pn(i-1,j))
            endif
          enddo
        enddo
      enddo
      return
      end
