      subroutine read_varids (inpvid, varids)   ! Read variables IDs.
      implicit none
      integer inpvid, i, ierr, type, line, lstr, lenstr
      character varids*(*), code*6, name1*16, name2*16, label*60
      logical is2df, end_of_file
#include "fldsid.h"

      lstr=lenstr(varids)
      open (unit=inpvid, file=varids(1:lstr), form='formatted',
     &                                             status='old')
      nvarids=0
      do i=0,maxids        !
        vcode(i)=' '       ! Blanc out everything.
        vtype(i)=0         ! This is necessary because 
        is2d(i)=.false.    ! varids file may be sparse.
        vname1(i)=' '      !
        vname2(i)=' '
        vlabel(i)=' '
      enddo
      end_of_file=.false. 
      line=0

      do while (.not.end_of_file)
        line=line+1
        read(inpvid,*,iostat=ierr) i,code,type,is2df,name1,name2,label
        if  (ierr.eq.0) then
          if (i.lt.999) then
            if (i.lt.maxids) then
              if (vcode(i).eq.' ') then
                nvarids=max(nvarids,i)
                vcode(i)=code
                vtype(i)=type
                is2d(i)=is2df
                vname1(i)=name1
                vname2(i)=name2
                vlabel(i)=label
              else
                write(*,'(/2x,2A,I4,A,I4,1x,A/)') 'ERROR in varids ',
     &         'file, line',line, ': ID =', i, 'was defined earlier.'
                stop
              endif
            else
              write(*,'(/2x,2A,I4/9x,A/)') 'ERROR: Number of IDs ',
     &         'in varids file exceeds parameter maxids =', maxids,
     &         'in file ''fldsid.h''.  Adjust it and recompile.'
              stop
            endif
          else
            end_of_file=.true.
          endif
        else
          write(*,'(/1x,2A,I4,1x,3A)')  'READ_VARIDS: Error while ',
     &   'reading line', nvarids+1,'in file ''', varids(1:lstr),'''.'
          stop
        endif
      enddo
      close (inpvid)
      return
      end

