! This is include file "pltncar.h"
!----- -- ------- ---- -----------
! postscript logical switch to generate a postscript file (if true)
!                   or an NCAR gmeta file (if false, default).
! gks_open NCAR GKS status switch: .true.=open; .false.=closed. 
! magscale global magnifcation scale for all font sizes in the
!          whole package. 
! basesize base size for fonts in a semi-proportional refinement
!              scheme.
!
! add      logical switch to a add User coastlines to area map.
! addezmap logical switch to a add EZMAP coastlines to area map.
! allbarlab logical switch to label all colorbar bands.
! cont     countour interval per field per level (real array)
! cntval   input script contour interval.
! cnt_cll  width of labeled contour lines: [0] default, [2] double.
! coorscl  Cartesian Coordinate units: [0] km, [1] m, [2] cm, [3] mm.
! ds       grid spacing in inches (real).
! geo_lab   switch to label geographic axis as degrees and minutes.
! hvelscl  horizontal velocity units: [0] m/s, [1] cm/s, [2] mm/s.
! icint    contour level selection switch (integer):
!           ICINT = 0  use contour interval provided by the USER
!           ICINT = 1  select contour interval internally
! ifill    switch to mask area below water column: [0] no, [1] yes.
! ipltpg   counter for the current map in the page (integer).
! isoval   iso-surface value to process.
! ivinc    vector sampling in the x-direction (integer).
! jvinc    vector sampling in the y-direction (integer).
! lclrbar  switch to draw color bar (T/F).
! lcntlab  switch to label contour lines (T/F).
! ldomain  switch to draw domain box (T/F).
! lgrid    map longitude/latitude grid separation.
! lhiglow  switch to label High/Low contour labels (T/F).
! lnozero  switch to omit drawing of zero-contour line (T/F).
! ltmarks  switch to draw box thick marks and labels (T/F).
! lvcolor  switch to paint vectors by their magnitude (T/F)
! lvecrho  switch to draw vectors at RHO-points (F: at PSI-points).
! npage    number of plots per page: one, two, or four (integer).
! ipref    prefered position of colorbar: 0=horizontal; 1=vertical
! ncl      number of color levels not including the background
!                  and foreground colors (integer).
! plttyp   flag indicating plot type:
!             [0] horizontal plot.
!             [1] vertical plots, cross-section.
! plat     projection Pole latitude (real; negative SOUTH).
! plon     projection Pole longitude (real; negative WEST).
!
! plim1(2) geographical coordinates of four corners of spherical
! plim4(2) map (each array has two elements, with Latitude stored
! plim3(2) the first elemn, while longitude as the second.
! plim4(2)
!
! rmax     overlay maximum value to consider.
! rmin     overlay minimum value to consider.
! rota     projection rotation angle (real; clockwise, degrees).
! sdv_fac  standard deviation factor from mean for field range to
!          plot.
! secaxis  section axis coordinate labels: [0] metric, [1] spherical.
! vec_scl    vector length scale.
! vscle    maximum vector magnitude for arrow scaling (real).
! vec_amn  vector arrow minimum size (fraction of viewport width).
! vec_mxx  Maximum vector text block X-coordinate.
! vec_mxy  Maximum vector text block Y-coordinate.
! vec_vrm  Vector reference magnitude.
! vec_vfr  vector fractional minimum.
! vec_vlc  vector low cutoff percentage.
! vec_vpo  vector positioning mode: [<0] head, [0] middle, [>0] tail.
! wrtfield switch to write field name below the plot
! wrtdate  switch to activate writing of current date.
! wrtfile  switch to activate writing of input filename.
! wrtrang  switch to activate writing of range of field.
! wvelscl  vertical velocity units: [0] m/s, [1] m/day, [2] cm/day.
! xvpos    X-position to place velocity vector scale (km or degrees).
! yvpos    Y-position to place velocity vector scale (km or degrees).
! zref     Reference depth used to compute several quantities like
!          potential density, dynamic height and others.
!
      integer cntplt, secplt,         cfld,     clev
      parameter (cntplt=1, secplt=2,  cfld=300, clev=50)
      real*4 thick_line,  medium_line, thin_line
      parameter (thick_line=2.0, medium_line=1.0, thin_line=0.6)

      real magscale, basesize, fl, fr, fb, ft,   ul, ur, ub, ut,
     &     plon,plat,rota,  plim1(2),plim2(2), plim3(2), plim4(2),
     &     sath, lgrid, vec_lwd, vec_scl, vec_amn, vec_vfr, vec_mxx,
     &     vec_mxy, vec_vlc,  vec_vrm, isoval, sdv_fac, zref,
     &     pmin(32), pmax(32),  rmin(32), rmax(32), cntval(32),
     &     cont(0:cfld,clev), clv(128)

      integer coorscl,    cnt_cll,   hvelscl,    icnt,       ifill,
     &        ipltpg,     ivinc,     jvinc,      ncl,        ipref,
     &        npage,      plttyp,    secaxis,    wvelscl,    vec_vpo

      logical postscript, gks_open,  close_page, row_column,
     &        levs_flds,  geo_lab,   addezmap,   allbarlab,  logscale,
     &        lview,      lland,     lwater,     lclrbar,    lcntlab,
     &        lframe,     ldomain,   lhiglow,    lnozero,    ltmarks,
     &        lvcolor,    lvecrho,   wrtclock,   timedepend,
     &        wrtfield,   wrtdate,   wrtfile,    wrtrang

      common /pltncar/ magscale, basesize, fl,fr,fb,ft, ul,ur,ub,ut,
     &        plon,plat,rota, plim1,plim2, plim3,plim4, sath, lgrid,
     &        vec_lwd, vec_scl, vec_amn,   vec_vfr, vec_mxx,vec_mxy,
     &        vec_vlc, vec_vrm, isoval,    sdv_fac, zref, pmin,pmax,
     &        rmin,rmax, cntval,cont, clv,

     &        coorscl,    cnt_cll,   hvelscl,    icnt,       ifill,
     &        ipltpg,     ivinc,     jvinc,      ncl,        ipref,
     &        npage,      plttyp,    secaxis,    wvelscl,    vec_vpo,

     &        postscript, gks_open,  close_page, row_column,
     &        levs_flds,  geo_lab,   addezmap,   allbarlab,  logscale,
     &        lview,      lland,     lwater,     lclrbar,    lcntlab,
     &        lframe,     ldomain,   lhiglow,    lnozero,    ltmarks,  
     &        lvcolor,    lvecrho,   wrtclock,   timedepend,
     &        wrtfield,   wrtdate,   wrtfile,    wrtrang
      save /pltncar/

!
! earthdat character parameter which specifies NCAR graphics library
!          dataset from which the coastline data needs to be read,
!          if user supplied no coastline file. Permissible settings
!          are: 'Earth..1', 'Earth..2', and 'Earth..3' or blank.
!          Note that 1998 EZMAPB dataset and package is used, if this
!          parameter is set to one of the 'Earth..X', otherwise it
!          verevrs to old dataset 
!
! proj     spherical projection type
!
      character proj*2, earthdat*8
      common /cpltncar/ proj, earthdat
      save   /cpltncar/
