! This is include file "pltfld.h".
!===================================================================
! Copyright (c) 1996 Rutgers University
!
! plot1,plot2 Type of the plot for primary or secondary fields;
!             may be scalar/vector/stream
! keep_asp_ratio Logical switch used to preserve aspect ratio.
! fldid       Identification of field(s) to plot (integer array).
! fldlev      Depths/levels/isopycnals values of the field to plot
!                (real array).
! fldnam1     Current field name component 1 (character).
! fldnam2     Current field name component 2 (character).
!
! frstd,lastd  First and last day to plot (both are real).
! dskip        plotting interval (real)
! 
! idover      Identification of field field (real).
! isosurf     Switch activated when plotting isosurfaces (logical).
! iref        Switch for reference fields (integer):
!                 [0] do not plot reference field
!                 [1] plot overlay field
!                 [2] primary - secondary (field subtraction)
!                 [3] day0 - dayN (field subtraction)
! interpolate Switch to interpolate field to requested depths
!                 (logical).
!
!  st_year !  starting year, month and day within the month of the
!  st_mon  !  date corresponding to starting date of the dataset.
!  st_mday !  If defined, the date label is converted into model
!          !  calendar date. (all three are integers)
!
! lastd       Last day to plot (real).
! levless     Switch to indicate that the current field has no
!                vertical levels (logical).
! levover     Depth/level/isopycnic value of field overlay (real).
!
! spherical   Switch for current field coordinates (logical):
!                True:  spherical False: Cartesian
! vintrp      Vertical interpolation scheme: [0] linear, [1] splines.
! nlevels     Number of different levels to plot (integer).
!  
      integer none, scalar, vect, strml
      parameter (none=0, scalar=1, vect=2, strml=3)

      real*8 frstd,lastd,dskip
      real fldlev(32),levover(32)
      integer iref, plot1, plot2, nfields, nlevels, vintrp,
     &     dstart, st_year, st_mon, st_mday, fldid(32), idover(32)
      logical spherical, keep_asp_ratio, levless, isosurf,
     &                                         interpolate

      common /pltfld/ frstd,lastd,dskip, fldlev,levover,
     &     iref, plot1, plot2, nfields, nlevels, vintrp,
     &     dstart, st_year, st_mon, st_mday, fldid, idover,
     &     spherical, keep_asp_ratio, levless, isosurf,
     &                                        interpolate




      character*20 fldnam1, fldnam2
      common /cpltfld/ fldnam1, fldnam2
