      subroutine opencdf (history, reference, grid)

!
! Open an existing NetCDF file and inquire about it content.
!
! Input: history  Input primary NetCDF file name.
!        reference  Input secondary NetCDF file name.
!        nc  Input grid NetCDF file name.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      character history*(*), reference*(*), grid*(*)
#include "param.h"
#include "pconst.h"
#include "domdat.h"
#include "fmask.h"
#include "ncinfo.h"
#include "netcdf.inc"
#include "pltfld.h"
#include "pltlab.h"
#include "pltncar.h"

      logical mismatch
      integer dimsiz, i,j, ldim, lstr1, lstr2, lstr3, lenatt,
     &             lvar, ndims, ngatts, nvatts, recdim, ierr,
     &             start(4), count(4), lenstr
      character*1   char1
      character*20  Tname1, Tname2, attnam, dimnam

      mismatch=.false.  
      Lr=0
      Lu=0    ! Reset horizontal dimensions to all-zero status
      Mr=0    ! these four variables are also used for dimension
      Mv=0    ! consistency check between history and grid file.

      gotangle1=.false.
      gotrho1=.false.
      gottime1=.false.
      gotsalt1=.false.
      gotzeta1=.false.
      gotangle2=.false.
      gotrho2=.false.
      gottime2=.false.
      gotsalt2=.false.
      gotzeta2=.false.






      ncmsk=0
      julday1=.false.
      ntime1=0
      ntime2=0
      Nr=0
      Nw=0
      NL=0

!
! Open primary input NetCDF file.   If successful, make
!===== ======= ===== ====== =====      general inquiry.
!
      if (history(1:4) .ne. 'none') then
        lstr1=lenstr(history)
        ierr=nf_open (history(1:lstr1),nf_nowrite,ncid1)
        if (ierr .eq. nf_noerr) then
          ierr=nf_inq (ncid1, ndims, nvars, ngatts, recdim)
          if (ierr.eq.nf_noerr) then
            if (nvars.le.maxvar) then
!
! Inquire and get global "type" attribute.
!
              do i=1,ngatts
                ierr=nf_inq_attname (ncid1, nf_global, i, attnam)
                if (ierr.eq.nf_noerr) then
                  lenatt=lenstr(attnam)    
                  if (attnam(1:lenatt).eq.'type') then
                    ierr=nf_get_att_text(ncid1,nf_global,'type',type1)
                    if (ierr.ne.nf_noerr) then
                      write(*,903) 'type (global)', history(1:lstr1)
                      call crash ('OPENCDF',ierr)
                    endif
                    goto 10
                  endif
                else
                  write(*,904) 'global attribute', history(1:lstr1)
                endif
              enddo
  10          continue
!
! Inquire about dimensions and determine their sizes.
!
              do i=1,ndims
                ierr=nf_inq_dim (ncid1, i, dimnam, dimsiz)
                if (ierr.eq.nf_noerr) then
                  ldim=lenstr(dimnam)
                  if (dimnam(1:ldim).eq.'xi_rho' .or.
     &                dimnam(1:ldim).eq.'lon_rho') then
                    Lr=dimsiz
                  elseif (dimnam(1:ldim).eq.'xi_u' .or.
     &                    dimnam(1:ldim).eq.'lon_u') then
                    Lu=dimsiz
                  elseif (dimnam(1:ldim).eq.'eta_rho' .or.
     &                    dimnam(1:ldim).eq.'lat_rho') then
                    Mr=dimsiz
                  elseif (dimnam(1:ldim).eq.'eta_v' .or.
     &                  dimnam(1:ldim).eq.'lat_v') then
                    Mv=dimsiz
                  elseif (dimnam(1:ldim).eq.'s_rho') then
                    Nr=dimsiz
                  elseif (dimnam(1:ldim).eq.'s_w') then
                    Nw=dimsiz
                  elseif (dimnam(1:ldim).eq.'N') then  
                    NL=dimsiz
                  elseif (ldim.gt.3) then
                    if (dimnam(ldim-3:ldim).eq.'time') then
                      ntime1=dimsiz
                      ierr=nf_inq_varid (ncid1,dimnam(1:ldim), varid)
                      ierr=nf_get_vara_double (ncid1,varid,1,ntime1,
     &                                                         time1)
                    endif
                  endif
                else
                  write(*,905) i, history(1:lstr1)
                  call crash ('OPENCDF',ierr)
                endif
              enddo
!
! Set-up correct number of vertical w-levels.
!
              if (NL.gt.0 .and. Nr.eq.Nw) Nw=NL+1
!
! Inquire about variables.  Read in various variables.
!
              rho0=1000.
              do i=1,nvars
                varid=i
                ierr=nf_inq_var(ncid1, varid, varnam(i),  vartyp,
     &                             nvdims(i), vdims(1,i), nvatts)
                if (ierr.ne.nf_noerr) then
                  write(*,906) varid, history(1:lstr1)
                  call crash ('OPENCDF',ierr)
                endif
                lvar=lenstr(varnam(i))
                if (varnam(i)(1:lvar).eq.'zeta') then
                  gotzeta1=.true.
                elseif (varnam(i)(1:lvar).eq.'rho' .and.
     &                  nvdims(i).gt.1) then
                  gotrho1=.true.
                elseif (varnam(i)(1:lvar).eq.'angle') then
                  gotangle1=.true.
                elseif (varnam(i)(1:lvar).eq.'mask_rho' .or.
     &                  varnam(i)(1:lvar).eq.'mask_u'    .or.
     &                  varnam(i)(1:lvar).eq.'mask_v'  ) then
                  ncmsk=ncid1
                elseif (varnam(i)(1:lvar).eq.'xl') then
                  ierr=nf_get_var1_real(ncid1,varid,1,xbasin)
                elseif (varnam(i)(1:lvar).eq.'el') then
                  ierr=nf_get_var1_real(ncid1,varid,1,ybasin)
                elseif (varnam(i)(1:lvar).eq.'rho0') then
                  ierr=nf_get_var1_real(ncid1,varid,1,rho0)
                elseif (varnam(i)(1:lvar).eq.'Lev') then
                  ierr=nf_inq_dim(ncid1,vdims(1,i),dimnam,nlev1)
                  ierr=nf_get_vara_int(ncid1,varid,1,nlev1,lev1)
                elseif (varnam(i)(1:lvar).eq.'spherical') then
                  ierr=nf_get_var1_text(ncid1,varid,1,char1)
                  if (char1.eq.'t' .or. char1.eq.'T') then
                    spherical=.true.
                  else
                    spherical=.false.
                  endif
                elseif (varnam(i)(1:lvar).eq.'zout') then
                  ierr=nf_get_vara_real(ncid1,varid,1,Nr,zinp1)
                elseif (lvar.gt.3) then
                  if (varnam(i)(lvar-3:lvar).eq.'time') then
                    gottime1=.true.
                    Tname1=varnam(i)(1:lvar)
                  endif
                endif
              enddo
            else 
              write(*,'(/4x,2A,I4,3A/11x,A,I4,A)') 'ERROR: Too ',
     &                    'many variables, nvars =',  nvars,
     &                    ' in netCDF file ''', history(1:lstr1),
     &             '''.', 'Increase parameter maxvar (currently',
     &                                maxvar, ') and recompile.' 
            endif
          else
            write(*,'(/1x,4A/)')   'ERROR: OPENCDF - Cannot make ',
     &                       'general inquiry into netCDF file ''',
     &                                      history(1:lstr1), '''.'
          endif
        else
          write(*,'(/1x,3A)') 'ERROR: Cannot open netCDF file ''',
     &                                     history(1:lstr1), '''.'
        endif
      else
        write(*,'(/1x,2A)') 'ERROR: No ''history'' netCDF file ',
     &                   'name is given in cnt/sec input script.'
      endif
      if (ierr.ne.nf_noerr) stop

!
! Set levels for restart files.
!

      if (type1(1:12) .eq. 'ROMS restart'  .or.
     &    type1(1:13) .eq. 'SCRUM restart') then
        nlev1=Nr
        do i=1,nlev1
          lev1(i)=i
        enddo
      endif
!
! Inquire size of unlimited time record dimension.
! Read in time coordinate values.
!
      if (recdim.gt.0) then
        ierr=nf_inq_dim (ncid1, recdim, dimnam, ntime1)
        if (ierr.ne.nf_noerr) then
          write(*,908) 'time', history(1:lstr1)
          call crash ('OPENCDF',ierr)
        endif
      else
        dimnam='time'
      endif
      if (gottime1) then
        lvar=lenstr(Tname1)
        ierr=nf_inq_varid (ncid1,Tname1(1:lvar),varid)
        if (ierr.eq.nf_noerr) then
          start(1)=1
          count(1)=ntime1
          ierr=nf_get_vara_double (ncid1,varid, start,count, time1)
          if (ierr.ne.nf_noerr) then
            write(*,909) Tname1(1:lvar), history(1:lstr1)
            call crash ('OPENCDF',ierr)
          endif

          ierr=nf_inq_var (ncid1, varid, varnam, vartyp,
     &                            nvdims, vdims, nvatts)
          do i=1,nvatts
            ierr=nf_inq_attname(ncid1,varid,i,attnam)
            if (ierr.eq.nf_noerr) then
              lenatt=lenstr(attnam)
              if (attnam(1:lenatt).eq.'add_offset') then
                julday1=.true.
              endif
            endif
          enddo           
        else
          write(*,910) Tname1(1:lvar), history(1:lstr1)
          call crash ('OPENCDF',ierr)
        endif
      elseif (type1(1:2).eq.'OA' .or. type1(1:4).eq.'DATA') then
        ldim=lenstr(dimnam)
        ierr=nf_inq_varid(ncid1,dimnam(1:ldim),varid)
        if (ierr.eq.nf_noerr) then
          start(1)=1
          count(1)=ntime1
          ierr=nf_get_vara_double (ncid1,varid, start,count, time1)
          if (ierr.ne.nf_noerr) then
            write(*,909) dimnam(1:ldim), history(1:lstr1)
            call crash ('OPENCDF',ierr)
          endif

          ierr=nf_inq_var(ncid1,varid,varnam,vartyp,nvdims,vdims,
     &                      nvatts)
          do i=1,nvatts
            ierr=nf_inq_attname(ncid1,varid,i,attnam)
            if (ierr.eq.nf_noerr) then
              lenatt=lenstr(attnam)
              if (attnam(1:lenatt).eq.'add_offset') then
                julday1=.true.
              endif
            endif
          enddo           
        else
          write(*,910) 'time', history(1:lstr1)
          call crash ('OPENCDF',ierr)
        endif
      endif
!
! Report plottable fields in primary file.
!
      call what_flds (ncid1, nvars, 1, history)
!
! Open secondary input NetCDF file, if applicable.
!===== ========= ====  ====== ===== == ===========
! Inquire about its dimensions and variables, check
! for consistency.
!
      if (iref.eq.2 .or. iref.eq.3) then
        if (reference(1:4) .ne. 'none') then
          lstr2=lenstr (reference)
          ierr=nf_open(reference(1:lstr2),nf_nowrite,ncid2)
          if (ierr .ne. nf_noerr) then
            write(*,'(/1x,3A)') 'ERROR: Cannot open netCDF file ''',
     &                                     reference(1:lstr2), '''.'
            stop
          endif
        else
          write(*,'(/1x,2A)') 'ERROR: No ''reference'' netCDF file ',
     &                       'name is given in cnt/sec input script.'
          stop
        endif

        ierr=nf_inq (ncid2, ndims, nvars, ngatts, recdim)
        if (nvars.gt.maxvar) then
          write(*,904) maxvar, nvars
          call crash ('OPENCDF',0)
        endif
        if (ierr.eq.nf_noerr) then
!
! Inquire and get global "type" attribute.
!
          do i=1,ngatts
            ierr=nf_inq_attname(ncid1,nf_global,i,attnam)
            if (ierr.eq.nf_noerr) then
              lenatt=lenstr(attnam)    
              if (attnam(1:lenatt).eq.'type') then
                ierr=nf_get_att_text(ncid1,nf_global,'type',type2)
                if (ierr.ne.nf_noerr) then
                  write(*,903) 'type (global)', history(1:lstr2)
                  call crash ('OPENCDF',ierr)
                endif
                goto 20
              endif
            else
              write(*,904) 'type (global)',reference(1:lstr2)
            endif
          enddo
  20      continue
!
! Inquire about dimensions.
!
          do i=1,ndims
            ierr=nf_inq_dim(ncid2, i ,dimnam,dimsiz)
            if (ierr.ne.nf_noerr) then
              write(*,905) i, reference(1:lstr2)
              call crash ('OPENCDF',ierr)
            endif
            ldim=lenstr(dimnam)
            if (dimnam(1:ldim) .eq. 's_rho' .or.
     &          dimnam(1:ldim) .eq. 'level') then
              nlev2=dimsiz
            endif
          enddo
!
! Inquire about variables.
!
          do i=1,nvars
            varid=i
            ierr=nf_inq_var (ncid2, varid, varnam(i),  vartyp,
     &                            nvdims(i), vdims(1,i), nvatts)
            if (ierr.ne.nf_noerr) then
              write(*,906) varid, reference(1:lstr2)
              call crash ('OPENCDF',ierr)
            endif
            lvar=lenstr(varnam(i))
            if (varnam(i)(1:lvar).eq.'zeta') then
              gotzeta2=.true.
            elseif ((varnam(i)(1:lvar).eq.'rho').and.
     &              (nvdims(i).gt.1)) then
              gotrho2=.true.
            elseif (varnam(i)(1:lvar).eq.'salt') then
              gotsalt2=.true.
            elseif (varnam(i)(1:lvar).eq.'angle') then
              gotangle2=.true.
            elseif (varnam(i)(1:lvar).eq.'mask_rho'.or.
     &              varnam(i)(1:lvar).eq.'mask_u'   .or.
     &              varnam(i)(1:lvar).eq.'mask_v') then

            elseif (varnam(i)(1:lvar).eq.'Lev') then
              ierr=nf_inq_dim(ncid2,vdims(1,i),dimnam,nlev2)
              ierr=nf_get_vara_int(ncid2,varid,1,nlev2,lev2)
            elseif (varnam(i)(1:lvar).eq.'zout') then
              ierr=nf_get_vara_real(ncid2,varid,1,nlev2,zinp2)
            elseif (lvar.gt.3) then
              if (varnam(i)(lvar-3:lvar).eq.'time') then
                Tname2=varnam(i)(1:lvar)
                gottime2=.true.
              endif
            endif
          enddo
        else
            write(*,'(/1x,4A/)')   'ERROR: OPENCDF - Cannot make ',
     &                       'general inquiry into netCDF file ''',
     &                                    reference(1:lstr1), '''.'
        endif
!
! Set levels for restart files.
!
      if (type2(1:12) .eq. 'ROMS restart' .or.
     &    type2(1:13) .eq. 'SCRUM restart') then
        do i=1,nlev2
          lev2(i)=i
        enddo
      endif
!
! Inquire size of unlimited time record dimension.
! Read in time coordinate values.
!
        if (recdim.gt.0) then
          ierr=nf_inq_dim (ncid2,recdim,dimnam,ntime2)
          if (ierr.ne.nf_noerr) then
            write(*,908) 'time', reference(1:lstr2)
            call crash ('OPENCDF',ierr)
          endif
        else
          dimnam='time'
        endif
        if (gottime2) then
          lvar=lenstr(Tname2)
          ierr=nf_inq_varid (ncid2,Tname2(1:lvar),varid)
          if (ierr.eq.nf_noerr) then
            start(1)=1
            count(1)=ntime2
            ierr=nf_get_vara_double (ncid2,varid, start,count, time2)
            if (ierr.ne.nf_noerr) then
              write(*,909) Tname2(1:lvar), reference(1:lstr2)
              call crash ('OPENCDF',ierr)
            endif
          else
            write(*,910) Tname2(1:lvar), reference(1:lstr2)
            call crash ('OPENCDF',ierr)
          endif
        elseif (type2(1:2).eq.'OA' .or. type1(1:4).eq.'DATA') then
          ldim=lenstr(dimnam)
          ierr=nf_inq_varid(ncid2,dimnam(1:ldim),varid)
          if (ierr.eq.nf_noerr) then
            start(1)=1
            count(1)=ntime2
            ierr=nf_get_vara_double(ncid2,varid, start,count, time2)
            if (ierr.ne.nf_noerr) then
              write(*,909) dimnam(1:ldim), reference(1:lstr2)
              call crash ('OPENCDF',ierr)
            endif
          else
            write(*,910) 'time', reference(1:lstr2)
            call crash ('OPENCDF',ierr)
          endif
        elseif (type2(1:7).eq.'Gridpak') then
          ntime2=ntime1
          do i=1,ntime2
            time2(i)=time1(i)
          enddo
        endif
!
! Report plottable fields in secondary file.
!
        call what_flds(ncid2, nvars, 2, reference)
      endif

!
! Open grid input netCDF file, if applicable,
!===== ==== ===== ====== ===== == ===========
! Inquire about its dimensions and variables,
! check for consistency.
!
      if (grid(1:4) .ne. 'none') then
        lstr3=lenstr(grid)
        ierr=nf_open(grid(1:lstr3),nf_nowrite,ncgrd)
        if (ierr .eq. nf_noerr) then
          ierr=nf_inq (ncgrd, ndims, nvars, ngatts, recdim)
          if (ierr.eq.nf_noerr) then
            if (nvars.le.maxvar) then
!
! Inquire about dimensions.
!
              do i=1,ndims
                ierr=nf_inq_dim (ncgrd, i ,dimnam, dimsiz)
                if (ierr .eq. nf_noerr) then
                  ldim=lenstr(dimnam)
                  if (dimnam(1:ldim) .eq. 'xi_rho'  .or.
     &                dimnam(1:ldim) .eq. 'lon_rho') then
                    if (dimsiz.ne.Lr .and. Lr.ne.0) then
                      write(*,911) 'xi_rho', dimsiz, Lr
                      mismatch=.true. 
                    endif
                  elseif (dimnam(1:ldim) .eq. 'xi_u'  .or.
     &                    dimnam(1:ldim) .eq. 'lon_u') then
                    if (dimsiz.ne.Lu .and. Lu.ne.0) then
                      write(*,911) 'xi_u', dimsiz, Lu
                      mismatch=.true. 
                    endif
                  elseif (dimnam(1:ldim) .eq. 'eta_rho' .or.
     &                    dimnam(1:ldim) .eq. 'lat_rho') then 
                    if (dimsiz.ne.Mr .and. Mr.ne.0) then
                      write(*,911) 'eta_rho', dimsiz, Mr
                      mismatch=.true. 
                    endif
                  elseif (dimnam(1:ldim) .eq. 'eta_v' .or.
     &                    dimnam(1:ldim) .eq. 'lat_rho') then
                    if (dimsiz.ne.Mv .and. Mv.ne.0) then
                      write(*,911) 'eta_v', dimsiz, Mv
                      mismatch=.true. 
                    endif
                  endif
                else
                  write(*,905) i, grid(1:lstr3)
                  stop
                endif
              enddo
              if (mismatch) stop 

!
! Inquire about variables.
!
              do i=1,nvars
                varid=i
                ierr=nf_inq_var (ncgrd, varid, varnam(i), vartyp,
     &                             nvdims(i), vdims(1,i), nvatts)
                if (ierr.ne.nf_noerr) then
                  write(*,906) varid, grid(1:lstr3)
                  call crash ('OPENCDF',ierr)
                endif
                lvar=lenstr(varnam(i))
                if (varnam(i)(1:lvar) .eq. 'mask_rho'.or.
     &              varnam(i)(1:lvar) .eq. 'mask_u'   .or.
     &              varnam(i)(1:lvar) .eq. 'mask_v') then
                  ncmsk=ncgrd 
                elseif (varnam(i)(1:lvar) .eq. 'xl') then
                  ierr=nf_get_var1_real(ncgrd,varid,1,xbasin)
                elseif (varnam(i)(1:lvar) .eq. 'el') then
                  ierr=nf_get_var1_real(ncgrd,varid,1,ybasin)
                elseif (varnam(i)(1:lvar).eq.'spherical') then
                  ierr=nf_get_var1_text(ncgrd,varid,1,char1)
                  if (char1.eq.'t' .or. char1.eq.'T') then
                    spherical=.true.
                  else
                    spherical=.false.
                  endif
                elseif (varnam(i)(1:lvar) .eq. 'srum_time') then
                  gottime2=.true.
                endif
              enddo
            else
              write(*,'(/4x,2A,I4,4A/11x,2A,I4,A)') 'ERROR: Too ',
     &           'many variables, nvars =',  nvars, ' in netCDF ',
     &           'file ''',  grid(1:lstr3),  '''.',   'Increase ',
     &           'parameter maxvar (currently',  maxvar,
     &                                         ') and recompile.'
            endif
          else
            write(*,'(/1x,4A/)')  'ERROR: OPENCDF - Cannot make ',
     &                      'general inquiry into netCDF file ''',
     &                                       grid(1:lstr3), '''.'
          endif
        else
          write(*,'(/1x,4A/)') 'ERROR: Cannot open grid netCDF ',
     &                           'file ''', grid(1:lstr3), '''.'
        endif
      else
        ncgrd=ncid1   !--> same as history file.
      endif
      return

 903  format(/,' OPENCDF - error while reading attribute: ',a,2x,
     &         ' in input NetCDF file: ',a)
 904  format(/,' OPENCDF - cannot find attribute: ',a,2x,
     &        ' in input NetCDF file: ',a)
 905  format(/,' OPENCDF - error while reading dimension ID: ',i3,2x,
     &         ' in input NetCDF file: ',a)
 906  format(/,' OPENCDF - error while inquiring information for ',
     &         ' variable ID: ',i3,2x,' in input NetCDF file: ',a)
 908  format(/,' OPENCDF - error inquiring dimension: ',a,2x,
     &         ' in input NetCDF file: ',a)
 909  format(/,' OPENCDF - error while reading variable: ',a,2x,
     &         ' in input NetCDF file: ',a)
 910  format(/,' OPENCDF - cannot find variable: ',a,2x,
     &         ' in input NetCDF file: ',a)
 911  format(/,' OPENCDF - inconsistent dimension ',a,
     &         ' grid and primary NetCDF files: ',2i5)
      end
