!
! got_XXX1,2 switchs indicating availability of a variable in
!            primary (1) or secondary (2) netCDF files, where
!            meaning of XXX = angle -- grid rotation angle;
!            time -- time; rho -- density; salt -- salinity;
!            zeta -- free-surface elevation
!
! ncgrd           NetCDF ID for grid file.
! ncid1,  ncid2   NetCDF ID for primary and secondary files.
! type2,  type2   Global NetCDF attribute "type".
! ntime1, ntime2  Size of unlimited time dimension.
! time1,  time2   Time coordinate values.
! nlev1,  nlev2   Number of input levels
! lev1,   lev2    Sets of nput model levels
!
! zinp1, zinp2    Input flat depths (if any).
!
! maxvar    Maximum number of variables for input NetCDF files.
! nvars     Number of variables defined in current input NetCDF file.
! nvdims    Number of dimensions for each variables in current input
!                     NetCDF file.
! tindx     Time record index in current input NetCDF file.
! varid     Generic ID for arbitrary variables in NetCDF files.
! varnam    Names of all variables in current input NetCDF file. 
! vdims     Dimension IDs for each of the variables in current input
!           NetCDF file.
! vname     Variables names and attributes for NetCDF files.
!
! Copyright (c) 1996 Rutgers University
!
      integer maxvar
      parameter (maxvar=100)
      real*8 time1(1000), time2(1000)
      real zinp1(NK), zinp2(NK) 
      integer ncgrd, ncid1, nlev1, ntime1, lev1(NK), nvdims(maxvar), 
     &        ncmsk, ncid2, nlev2, ntime2, lev2(NK), vdims(5,maxvar),
     &        Lr,Lu, Mr,Mv, NL,Nr, Nw, tindx, nvars, varid, vartyp
      logical gotangle1, gotrho1,  gottime1, gotsalt1, gotzeta1,
     &        gotangle2, gotrho2,  gottime2, gotsalt2, gotzeta2

      common /ncinfo/       time1, time2,  zinp1,    zinp2,
     &        ncgrd, ncid1, nlev1, ntime1, lev1,     nvdims,
     &        ncmsk, ncid2, nlev2, ntime2, lev2,     vdims,
     &        Lr,Lu, Mr,Mv, NL,Nr, Nw, tindx, nvars, varid, vartyp,
     &        gotangle1, gotrho1,  gottime1, gotsalt1, gotzeta1,
     &        gotangle2, gotrho2,  gottime2, gotsalt2, gotzeta2

      character*5   version
      character*15  varnam(maxvar)
      character*80  type1, type2
      common /cncinfo/ type1, type2, version, varnam
