      subroutine mskscl (f, imax,jmax,kmax, idfld, igrid, spv,spval)
!
! Mask and/or scale current field F.
!
! Input:  f        Field to scale and/or mask (real array).
!         imax       Size of inner dimension (integer).
!         jmax       Size of outer dimension (integer).
!         kmax       Number of vertical levels (integer).
!         idfld    Identification of field to plot (integer).
!         igrid    Staggered C grid type (integer):
!                    igrid=0  => None.
!                    igrid=1  => density points.
!                    igrid=2  => streamfunction points.
!                    igrid=3  => u-velocity points.
!                    igrid=4  => v-velocity points.
!                    igrid=5  => w-velocity points.
!         spv      Missing data/fill data value (real).
!         spval    Mask special value (real).
!
! Output: f        Masked and/or scale field (real array).
!
      implicit none
      integer imax,jmax,kmax, idfld,igrid
      real f(imax,jmax,kmax), spv, spval

      integer i,j,k, is,js, im,jm,imgrid, nc_vid
      real scale,  spvnc

#include "param.h"
#include "pconst.h"
#include "fldsid.h"
#include "fmask.h"
#include "ncinfo.h"
#include "pltncar.h"

!
! Check for special fill value.
!
      if (abs(spv).eq.999.0) then
        do k=1,kmax
          do j=1,jmax
            do i=1,imax
              if (f(i,j,k).eq.spv) f(i,j,k)=spval
            enddo
          enddo
        enddo
      endif
!
! Scale fields.
!====== =======
!
! Scale horizotal velocity.  Assumed in (m/s) at input.
!
      if (vcode(idfld).eq.'IDUTOT' .or. vcode(idfld).eq.'IDVTOT' .or.
     &    vcode(idfld).eq.'IDUCLI' .or. vcode(idfld).eq.'IDVCLI' .or.
     &    vcode(idfld).eq.'IDUBAR' .or. vcode(idfld).eq.'IDVBAR' .or.
     &    vcode(idfld).eq.'IDUICE' .or. vcode(idfld).eq.'IDVICE' .or.
     &    vcode(idfld).eq.'IDUNPY' .or. vcode(idfld).eq.'IDVNPY' .or.
     &    vcode(idfld).eq.'IDTVEC' .or. vcode(idfld).eq.'IDTSTR' .or.
     &    vcode(idfld).eq.'IDCVEC' .or. vcode(idfld).eq.'IDCSTR' .or.
     &    vcode(idfld).eq.'IDBVEC' .or. vcode(idfld).eq.'IDBSTR' .or.
     &    vcode(idfld).eq.'IDIVEC' .or. vcode(idfld).eq.'IDISTR' .or.
     &    vcode(idfld).eq.'IDNPYV' .or. vcode(idfld).eq.'IDNPYS'
     &   ) then
        if (hvelscl.eq.0) then
          scale=1.
        elseif (hvelscl.eq.1) then
          scale=100.               ! meters to cm
        else
          write(*,'(/2(1x,A)/1x,A/)') 'ERROR: illegal parameter',
     &     'HVELSCL in file default.cnt.', 'Chose either 0 or 1.'
          stop
        endif
        do k=1,kmax
          do j=1,jmax
            do i=1,imax
              if (f(i,j,k).ne.spv) f(i,j,k)=scale*f(i,j,k)
            enddo
          enddo
        enddo
!
! Scale surface radar velocities.  Assumed in (cm/s) at input.
!
      elseif (vcode(idfld).eq.'IDUSUR' .or.
     &        vcode(idfld).eq.'IDVSUR' .or.
     &        vcode(idfld).eq.'IDSVEC' .or.
     &        vcode(idfld).eq.'IDSSTR') then
        if (hvelscl.eq.0) then
          scale=0.01               ! cm to m
        elseif (hvelscl.eq.1) then
          scale=1.
        else
          write(*,'(/2(1x,A)/1x,A/)') 'ERROR: illegal parameter',
     &     'HVELSCL in file default.cnt.', 'Chose either 0 or 1.'
          stop
        endif
        do k=1,kmax
          do j=1,jmax
            do i=1,imax
              if (f(i,j,k).ne.spv) f(i,j,k)=scale*f(i,j,k)
            enddo
          enddo
        enddo
!
! Scale vertical velocity. Assumed in (m/s) at input.
!
      elseif (vcode(idfld).eq.'IDOMEG' .or.
     &        vcode(idfld).eq.'IDWVEL') then
        if (wvelscl.eq.0) then
          scale=1.
        elseif (wvelscl.eq.1) then
          scale=100.
        else
          write(*,'(/2(1x,A)/1x,A/)') 'ERROR: illegal parameter',
     &     'WVELSCL in file default.cnt.', 'Chose either 0 or 1.'
          stop
        endif
        do k=1,kmax
          do j=1,jmax
            do i=1,imax
              if (f(i,j,k).ne.spv) f(i,j,k)=scale*f(i,j,k)
            enddo
          enddo
        enddo
!
! If depth of planetary boundary layer, fill non-computational points
! with the closest value to the point.
!
      elseif (vcode(idfld).eq.'IDPHBL') then
        do j=1,jmax
          f(   1,j,kmax)=f(     2,j,kmax)
          f(imax,j,kmax)=f(imax-1,j,kmax)
        enddo
        do i=1,imax
          f(i,   1,kmax)=f(i,     2,kmax)
          f(i,jmax,kmax)=f(i,jmax-1,kmax)
        enddo
!
! If vertical viscosity/diffusion coefficients, fill
! non-computational points with the closest value to the point.
!
      elseif (vcode(idfld).eq.'IDAKSC' .or.
     &        vcode(idfld).eq.'IDAKTC'  .or.
     &        vcode(idfld).eq.'IDAKVC') then
        if (kmax.gt.1) then
          do j=1,jmax
            do i=1,imax
              f(i,j,kmax)=f(i,j,kmax-1)
            enddo
          enddo
        endif
        do k=1,kmax
          do j=1,jmax
            f(   1,j,k)=f(     2,j,k)
            f(imax,j,k)=f(imax-1,j,k)
          enddo
          do i=1,imax
            f(i,   1,k)=f(i,     2,k)
            f(i,jmax,k)=f(i,jmax-1,k)
          enddo
        enddo
!
! Scale curvilinear transformation angle to degrees.
!
      elseif (vcode(idfld).eq.'IDANGL') then
        do k=1,kmax
          do j=1,jmax
            do i=1,imax
              if (f(i,j,k).ne.spv) f(i,j,k)=rad2deg*f(i,j,k)
            enddo
          enddo
        enddo
!
! Scale grid-spacing from 1/m to km.
!
      elseif (vcode(idfld).eq.'IDDELX' .or.
     &        vcode(idfld).eq.'IDDELY') then
        scale=0.001  ! meters to km 
        do k=1,kmax
          do j=1,jmax
            do i=1,imax
              if (f(i,j,k).ne.spv) f(i,j,k)=scale/f(i,j,k)
            enddo
          enddo
        enddo
!
! Scale transport streamfunction to Sverdrups.
!
      elseif (vcode(idfld).eq.'IDTPSI' .or.
     &        vcode(idfld).eq.'IDNPYT') then
        scale=1.E-6
        do k=1,kmax
          do j=1,jmax
            do i=1,imax
              if (f(i,j,k).ne.spv) f(i,j,k)=scale*f(i,j,k)
            enddo
          enddo
        enddo
      endif
      
!
! Apply Land/Sea mask, if any.
!====== ======== ===== == ====
!
      if (ncmsk.gt.0 .and. igrid.gt.0) then
        call get_nc2dat (mask, NH, im,jm, ncmsk,0, 'mask_rho',
     &                             0., imgrid, nc_vid,  spvnc)
        is=im-imax
        js=jm-jmax

#ifdef VERBOSE
         write(*,'(4(2x,A,I1))') 'MAKSCL: igrid=', igrid,
     &            'imgrid=', imgrid, 'is=', is, 'js=', js
#endif

        if (igrid.eq.1 .or. igrid.eq.5) then
          if (is.ne.0 .or. js.ne.0) goto 99               !--> ERROR
          do j=1,jmax
            do i=1,imax                                   ! At RHO-
              if (mask(i+(j-1)*im).lt.1.) then            ! points
                do k=1,kmax
                  f(i,j,k)=spval
                enddo
              endif
            enddo
          enddo
        elseif (igrid.eq.7) then
          if (is.ne.2 .or. js.ne.2) goto 99               !--> ERROR 
          do j=1,jmax
            do i=1,imax
              if (mask(i+1+j*im).lt.1.) then              ! Internal
                do k=1,kmax                               ! RHO-
                  f(i,j,k)=spval                          ! points
                enddo
              endif
            enddo
          enddo
        elseif (igrid.eq.3) then
          if (is.ne.1 .or. js.ne.0) goto 99               !--> ERROR 
          do j=1,jmax
            do i=1,imax
              if (mask(i  +is+(j-1)*im).lt.1. .or.        ! At U-
     &            mask(i-1+is+(j-1)*im).lt.1.) then       ! points
                do k=1,kmax
                  f(i,j,k)=spval
                enddo
              endif
            enddo
          enddo
        elseif (igrid.eq.4) then
          if (is.ne.0 .or. js.ne.1) goto 99               !--> ERROR
          do j=1,jmax
            do i=1,imax
              if (mask(i+(j-1+js)*im).lt.1. .or.          ! At V-
     &            mask(i+(j-2+js)*im).lt.1.) then         ! points
                do k=1,kmax
                  f(i,j,k)=spval
                enddo
              endif
            enddo
          enddo
        elseif (igrid.eq.2) then
          if (is.ne.1 .or. js.ne.1) goto 99               !--> ERROR
          do j=1,jmax
            do i=1,imax
              if (mask(i  +is+(j-1+js)*im).lt.1. .or.     ! At PSI-
     &            mask(i-1+is+(j-1+js)*im).lt.1.  .or.    ! points
     &            mask(i  +is+(j-2+js)*im).lt.1.  .or.
     &            mask(i-1+is+(j-2+js)*im).lt.1.) then
                do k=1,kmax
                  f(i,j,k)=spval
                enddo
              endif
            enddo
          enddo
        endif
      endif
      return

  99  write(*,'(/1x,A,3(1x,A,I1)/)') 'ERROR in mskscl.F:',
     &   'incompatible igrid=', igrid, 'is=', is, 'js=',js
      stop
      end
