      subroutine maptitles (day, cint, fmin,fmax, frms,
     &                      icolor, idfld, level, ipos)
!
!  Write all map titles which depend on the number of  
!  plots per page, and number of fields per page.                    
!                                                                    
      implicit none
      real*8 day
      integer icolor, idfld, ipos
      real cint, fmin, fmax, frms, level

      integer iday, julian, month, i,j, ie,is,
     &            lstr, lstr1, lstr2, lenstr
      real sizeX, xlab, yearday, fontsize, fontsize1, fontsize2,
     &     sizeY, ylab, rday,    hour,     fontsize3, fontsize4,
     &     LeftMargin, RightMargin, TopMargin, BottomMargin,
     &              angle, ctr,  cff, yd(13)
      data yd /1.,32.,60.,91.,121.,152.,182.,213.,244.,274.,
     &                                        305., 335., 366./

      character datelab*19, text*80, text1*80, text2*80, daylab*19
      character*9 smonth(0:12)
      data smonth /'Annual   ', 'January  ', 'February ',
     &       'March    ', 'April    ', 'May      ', 'June     ',
     &       'July     ', 'August   ', 'September', 'October  ',
     &                                 'November ', 'December '/

#include "param.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltio.h"
#include "pltlab.h"
#include "pltncar.h"

      call gsclip(0)
      sizeX=ur-ul                      ! Chose semi-proportional
      sizeY=basesize * (ut-ub)/(ft-fb) ! font size for bottom labels,
      fontsize=0.01 * basesize         ! which become smaller for 
      fontsize1=0.01414 * magscale     ! smaller vieport size. 
      fontsize2=0.01    * magscale     ! Also set four different 
      fontsize3=0.0071  * magscale     ! sizes for top titles, which 
      fontsize4=0.005   * magscale     ! are independentof viewport. 
!
!  Get data date label.
!
c?      if (julday1) then
c?        rday=day+yday
c?        hour=(day-int(day))*24.0
c?        if (julday1 .or. rday.gt.366.) then
c?          julian=2440000+int(day)
c?          hour=(day-int(day))*24.
c?          call caldate (julian,month,iday,iyear,yearday)
c?          call datestr (iyear,yearday,hour,datelab)
c?        else
c?          call datestr (iyear,rday,hour,datelab)
c?        endif
c?      else
        datelab='           '
c?      endif
!
!  Set first part of the date label.
!
      if (type1(1:11).eq.'CLIMATOLOGY') then
        month=0
        do i=1,12
          if (yd(i).le.day .and. day.lt.yd(i+1)) month=i 
        enddo
        if (0.le.month .and. month.le.12) then
          lstr=lenstr(smonth(month))
          daylab=smonth(month)(1:lstr)
        else
          call create_daylab (day, daylab, lstr)
        endif
c?      elseif (julday1 .and. (type1(1:2).eq.'OA' .or.
c?     &                       type1(1:4).eq.'DATA')) then
c?        julian=2440000+int(day)
c?        hour=(day-int(day))*24.0
c?        call caldate (julian,month,iday,iyear,yearday)
c?        call datestr (iyear,yearday,hour,daylab)
      elseif (st_year.ne.0 .and. st_mon.ne.0 .and. st_mday.ne.0) then
        daylab='                   ' 
        call create_datelab (day,daylab,lstr, dstart,
     &                        st_year,st_mon,st_mday)
      else
        call create_daylab (day, daylab, lstr)
      endif


      if (wrtclock .and. timedepend) then
        xlab=ul+0.3*sizeX   ! leave space for time clock.
      else
        xlab=ul+0.05*sizeX  ! no time clock: use the whole space
      endif
!
! Set initial ordinate for bottom label(s). If needed, leave space
! for horizontal color bar.
!
      ylab=ub
      if (plttyp.eq.secplt .and. ltmarks) ylab=ylab-0.025*sizeY
      if (ipos.eq.0 .and. icolor.ne.0) ylab=ub-0.105*(ut-ub)
     &                                             -0.025*sizeY

!                   
! Write contour/vector plot ranges:    Min, max, contour interval
!====== ======= ====== ==== =======    rms labels
!
      if (wrtrang) then
        lstr=0
        lstr1=1
        lstr2=0
        if (icolor.eq.0 .and. (plot1.eq.scalar .or.
     &                         plot2.eq.scalar)) then
          call write_string ('min=', 4, fmin,      text,  lstr)
          call write_string ('max=', 4, fmax,      text1, lstr1)
          call write_string ( 'CI=', 3, abs(cint), text2, lstr2)
        elseif (icolor.eq.1 .and. iref.gt.0 .and.
     &                                    plot2.eq.scalar) then
          call write_string ('min=', 4, fmin,      text,  lstr)
          call write_string ('max=', 4, fmax,      text1, lstr1)
          call write_string ( 'CI=', 3, abs(cint), text2, lstr2)
        elseif (plot1.eq.vect) then
          call write_string ('max=', 4, fmax,      text,  lstr)
          call write_string ('rms=', 4, frms,      text1, lstr1)
        else
          call write_string ('min=', 4, fmin,      text,  lstr )
          call write_string ('max=', 4, fmax,      text1, lstr1)
        endif
        if (lstr1.gt.0) then
          text(lstr+1:lstr+3)=',  '
          text(lstr+4:lstr+lstr1+3)=text1(1:lstr1)
          lstr=lstr+lstr1+3
        endif
        if (lstr2.gt.0) then
          text(lstr+1:lstr+3)=',  '
          text(lstr+4:lstr+lstr1+3)=text2(1:lstr2)
          lstr=lstr+lstr2+3
        endif

        lstr1=0
        if (isosurf) then
          call write_string ('ISO=', 4, isoval,    text1, lstr1)
        elseif (level.gt.1000.) then
          call write_string ('ISO=', 4,level-1000.,text1, lstr1)
        endif
        if (lstr1.gt.0) then
          text(lstr+1:lstr+3)=',  '
          text(lstr+4:lstr+lstr1+3)=text1(1:lstr1)
          lstr=lstr+lstr1+3
        endif

        if (plttyp.eq.cntplt .and. spherical) then
          ylab=ylab-0.015*sizeY
        elseif (plttyp.eq.cntplt) then
          ylab=ylab-0.015*sizeY
        elseif (plttyp.eq.secplt) then
          ylab=ylab-0.0225*sizeY
        endif
        call plchhq (xlab,ylab,text(1:lstr),fontsize,0.,-1.)
      endif
!
! Field name and depth (or level) is the bottom label.
!
      if (wrtfield) then
        if (plttyp.eq.cntplt) then
          call depth_lab (idfld, level, botlab)
        elseif (plttyp.eq.secplt) then
          botlab=vlabel(idfld)
        endif
        call checkstrm (text, lstr, botlab)
        ylab=ylab-0.035*sizeY
        call plchhq (xlab,ylab, text(1:lstr), fontsize,0.,-1.)

        if (wrtclock .and. timedepend) then
          xlab=xlab-0.025*sizeX              ! Leave enought space
          if (wrtrang) then                  ! on the left for model
            ylab=ylab+0.008*sizeY            ! time clock label and
          else                               ! also make room for
            ylab=ylab-0.01*sizeY             ! contour interval
          endif                              ! message, if requested.
          lstr=lenstr (daylab)
          call plchhq (xlab,ylab,daylab(1:lstr),1.75*fontsize,0.,+1.)
        endif
      endif
!                                   NOTE: These titles are common
! Write main plot titles:                 for all panels on the page.
!====== ==== ==== =======       
!
      if (close_page) then
        call set (0.,1.,0.,1., 0.,1.,0.,1., 1)

        cff=0.025*magscale                ! Set margins to allow
        LeftMargin  =0.001 +0.5*cff       ! maximum size of the plot,
        RightMargin =0.999 -0.5*cff       ! then move inward to  
        TopMargin   =0.999 -0.5*cff       ! accomodate title labels.
        BottomMargin=0.001 +0.5*cff       ! This code segment matches
        do i=1,ntitles                    ! the sarting segment in 
          j=ititle(i)/2                   ! viewport.F.
          if (ititle(i)-2*j .eq.0) then
            ctr=-1.
            xlab=0.15
            ylab=0.15
          else 
            ctr=0.
            xlab=0.5
            ylab=0.5
          endif
          angle=0.
          if (j.eq.0) then
            ylab=TopMargin
            TopMargin=ylab-cff
          elseif (j.eq.1) then
            xlab=LeftMargin
            LeftMargin=xlab+cff
            angle=90.
          elseif (j.eq.2) then
            ylab=BottomMargin
            BottomMargin=ylab+cff
          elseif (j.eq.3) then
            xlab=RightMargin
            RightMargin=xlab-cff
            angle=90.
          endif
          call checkstrm (text, lstr, title(i))
          call plchhq (xlab,ylab, text(1:lstr), fontsize2,angle,ctr)
        enddo
                                              ! Write rimary netCDF
        if (wrtdate) lstr=lenstr(date_str)    ! file name and current
        if (wrtfile) then                     ! date label.
          ie=lenstr(history(ihist))
          is=ie
          do while (history(ihist)(is:is).ne.'/' .and. is.gt.1)
            is=is-1
          enddo                               ! Drop directory name
        endif                                 ! if any.
        if (wrtdate) lstr=lenstr(date_str)
        if (wrtdate .and. wrtfile) then
          text='file: '/ /history(ihist)(is:ie)/
     &               /'    '/ /date_str(1:lstr)
          lstr=lstr+ie-is+11
        elseif (wrtdate) then                    ! For compactness 
          text=date_str(1:lstr)                  ! write name of 
        elseif (wrtfile) then                    ! history file and 
          text='file: '/ /history(ihist)(is:is)  ! current date label
          lstr=ie-ie+7                           ! as a single line.
        endif
        if (wrtdate .or. wrtfile) then
          xlab=1.-0.01*magscale
          ylab=0.01*magscale
          call plchmq (xlab,ylab,text(1:lstr), fontsize4,0.,+1.)
        endif

        if (lframe) then
          write(*,*) 'Drawing Bounding Box...'
          call gslwsc (thin_line)         ! Outline bounding box
          call line (0.,0., 0.05,0.)      ! if requested
          call line (0.,0., 0.,0.05)      
          call line (1.,0., 0.95,0.)    
          call line (1.,0., 1.,0.05)
          call line (1.,1., 0.95,1.)
          call line (1.,1., 1.,0.95)
          call line (0.,1., 0.05,1.)
          call line (0.,1., 0.,0.95)
          call gslwsc (medium_line)
        endif
      endif  ! <-- close_page
      call gsclip(1)
      return
      end

      subroutine create_daylab (day, daylab, lstr)
      implicit none
      real*8 day
      character daylab*(*), string*16
      integer lstr, i,is,id,ir,ie

      write(string,'(F16.8)') day
      is=0                         ! first non-blanc character
      id=0                         ! decimal point
      ir=0                         ! the first significant digit
      do i=1,16
        if (string(i:i).eq.' ') then
          is=i
        elseif (string(i:i).eq.'.') then
          id=i
        elseif (string(i:i).ne.'0' .and. ir.eq.0) then
          ir=i
        endif
      enddo
      is=is+1

      if (ir.eq.0) then            ! Decide how many digits to keep
        ie=is                      ! and where to put the end of the
      elseif (ir.gt.id+2) then     ! string.
        ie=ir+2
      elseif (ir.gt.id) then
        ie=ir+3
      elseif (ir.lt.id-3) then
        ie=id-1
      else
        ie=is+4
      endif                        ! Check that ie is within the
      ie=min(ie,16)                ! bounds.

      do while (string(ie:ie).eq.'0' .and. ie.gt.id)
        ie=ie-1                    
      enddo                        ! Drop insignificant zeros and
      if (ie.eq.id) ie=ie-1        ! decimal point at the end.

      lstr=ie-is+1                 ! If the length is short enough,
      if (lstr.gt.4) then          ! put title 'Day', otherwise keep
        daylab=string(is:ie)       ! it as is.
      else
        daylab='Day '/ /string(is:ie)
        lstr=lstr+4
      endif
c---#define TEST_DAYLAB
#ifdef TEST_DAYLAB
      write(*,'(/3A,3I3,2x,3A,I3/)') '''', string, '''', is,id,ir,
     &                            '''', daylab(1:lstr), '''', lstr
#endif
      return
      end

#ifdef TEST_DAYLAB
      implicit none
      character*10 daylab
      integer lstr
      real day
  1   write(*,'(A,$)') 'Enter day: '
      read(*,*) day
      call create_daylab (day, daylab, lstr)
      goto 1
      end
#endif

      subroutine create_datelab (day, daylab, lstr, dstart,
     &                            st_year, st_mon, st_mday)
      implicit none
      real*8 day
      integer lstr, dstart, st_year, st_mon, st_mday, i,j,k
      character daylab*11, dlab*2, ylab*4 

      i=int(day)-dstart+st_mday
      j=st_mon
      k=st_year
      do while (i.gt.360)
        i=i-360
        k=k+1
      enddo 
      do while (i.gt.30)
        i=i-30
        j=j+1
      enddo
      do while (j.gt.12)
        j=j-12
        k=k+1
      enddo

      write(dlab,'(I2)') i
      write(ylab,'(I4)') k
      if (j.eq.1) then
        daylab=dlab/ /' JAN '/ /ylab
      elseif (j.eq.2) then
        daylab=dlab/ /' FEB '/ /ylab
      elseif (j.eq.3) then
        daylab=dlab/ /' MAR '/ /ylab
      elseif (j.eq.4) then
        daylab=dlab/ /' APR '/ /ylab
      elseif (j.eq.5) then
        daylab=dlab/ /' MAY '/ /ylab
      elseif (j.eq.6) then
        daylab=dlab/ /' JUN '/ /ylab
      elseif (j.eq.7) then
        daylab=dlab/ /' JUL '/ /ylab
      elseif (j.eq.8) then
        daylab=dlab/ /' AUG '/ /ylab
      elseif (j.eq.9) then
        daylab=dlab/ /' SEP '/ /ylab
      elseif (j.eq.10) then
        daylab=dlab/ /' OCT '/ /ylab
      elseif (j.eq.11) then
        daylab=dlab/ /' NOV '/ /ylab
      elseif (j.eq.12) then
        daylab=dlab/ /' DEC '/ /ylab
      endif
      lstr=11
      write(*,*) daylab, '  i,j,k=', i,j,k
      return
      end


      
