      subroutine lintrp (x,y,n, xs,ys, spval)
!
! Given arrays x(n) and y(n), which tabulate a function, y = y(x),
! and assuming that x(i) is monotonic function of its index i, and
! that xs is between x(1) and x(n), compute linear interpolated
! value ys(xs). Return special value, xs is outside these bounds. 
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer n, i, is
      real x(n),y(n), xs, ys, spval

      is=0 
      do i=1,n-1
        if ((x(i+1)-xs)*(xs-x(i)) .ge. 0.) is=i
      enddo
      if (is.gt.0) then
        ys=( (x(is+1)-xs)*y(is) +(xs-x(is))*y(is+1) )/(x(is+1)-x(is))
      else
        ys=spval
      endif
      return
      end
