! Declaration of variables responsible for drawing Coastline and 
! shading land areas, if so requested.
!
! landmap   integer array specifically designed to hold land map,
!           as it is generated by NCAR library routines.
! lmap      maximum allowed length of array "landmap".
!
! xcst,ycst coordinates of vertices of coast line. These are "user
!           coordinates", i.e., they are geographical data projected
!           by NCAR library spherical pojection routines. 
! ncst      actual number of points of the coastline.
! ncstmax   maximum allowed lenght of arrays "xcst,ycst". 
!
! isgcst    integer array to store terminating indices of coastline 
!           segments, e.g., coordinates of points  which belong "n"th
!           segment are stored as 
!                                   xcst(1+isgcst(n-1):isgcst(n))
!                                   ycst(1+isgcst(n-1):isgcst(n))
!
! nsgcst    actual number of segments in the coastline.
! nsgmax    maximum allowed number of segments
!
      integer nsgmax, ncstmax, lmap
      parameter (nsgmax=1000,  ncstmax=100000,  lmap=2000000)
      integer ncst,  nsgcst,   isgcst(nsgmax),  landmap(lmap)
      real xcst(ncstmax), ycst(ncstmax)
      common /xcstline/ ncst,nsgcst,isgcst, xcst,ycst, landmap
      save   /xcstline/
