      subroutine landfill (x,y, im,jm, xrim,yrim)
      implicit none
      integer im,jm, i,j,shft, nrim, ierr, ins,ins_bak
      real x(im,jm),y(im,jm), xrim(2*(im+jm)),yrim(2*(im+jm)),lon,lat
      logical inside, started_outside
      integer is,ncross, ns, js,jsegm
      character*3 string

#include "pconst.h"
#include "pltio.h"
#include "pltncar.h"

      integer maxcoast, ncst, nsegm, isegm(10000) 
      parameter (maxcoast=200000)
      real xline(maxcoast), yline(maxcoast) 
      common /xcoastline/ xline, yline

      write(*,*) 'Enter landfill...'

      do i=1,im-1                 ! Extract rim of the
        xrim(i)=x(i,1)            ! curvilinear grid
        yrim(i)=y(i,1)
      enddo
      shft=im-1
      do j=1,jm-1
        xrim(shft+j)=x(im,j)
        yrim(shft+j)=y(im,j)
      enddo
      shft=2*im+jm-1
      do i=im,2,-1
        xrim(shft-i)=x(i,jm)
        yrim(shft-i)=y(i,jm)
      enddo
      shft=2*(im+jm-1)
      do j=jm,2,-1
        xrim(shft-j)=x(1,j)
        yrim(shft-j)=y(1,j)
      enddo
      nrim=2*(im+jm)-4
      xrim(nrim+1)=xrim(1)
      yrim(nrim+1)=yrim(1)


      ncst=0
      nsegm=1
      isegm(nsegm)=0
      ncross=0
      js=0
      jsegm=0
      ins_bak=0

      read(inpcst,*,iostat=ierr) lat,lon
      do while (ierr.eq.0)
        if (lon.lt.600. .and. lat.lt.100.) then
          jsegm=jsegm+1
          if (inside (lon,lat, xrim,yrim,nrim)) then
            ins=+1
            js=js+1
            if (ins_bak.eq.-1) then
              ncross=ncross+1
              if (js.eq.1) then
                started_outside=.true.
                write(*,'(4I6,1x,A)') nsegm,js,jsegm,ncross,'-> enter'
              else
                write(*,'(4I6,1x,A)') nsegm,js,jsegm,ncross,'->reenter'
                call connect (xline,yline, ncst, lon,lat,
     &                                xrim,yrim, nrim, -1)
              endif
            endif
            ncst=ncst+1
            xline(ncst)=lon
            yline(ncst)=lat
          else
            ins=-1
            if (ins_bak.eq.+1) then
              ncross=ncross+1
              write(*,'(4I6,1x,A$)') nsegm,js,jsegm,ncross,' <-  exit'
            endif
          endif

        else

          if (started_outside .and. ins_bak.eq.-1) then
            write(*,*) '  closing contour', nsegm
            is=isegm(nsegm)+1
            call connect (xline,yline, ncst, xline(is),yline(is),
     &                                       xrim,yrim, nrim, +1)
          endif

c          if (isegm(nsegm).lt.ncst) then
          if (js.gt.0) then
            nsegm=nsegm+1
            isegm(nsegm)=ncst
            write(*,*) started_outside, ins
          endif

          ins=0          ! Reset all counters 
          js=0           ! within segment
          jsegm=0
          ncross=0
          started_outside=.false.

        endif
        ins_bak=ins
        read(inpcst,*,iostat=ierr) lat,lon
      enddo
      if (isegm(nsegm).lt.ncst) then
        nsegm=nsegm+1
        isegm(nsegm)=ncst
      endif
      rewind (inpcst)


      do i=1,ncst
        lon=xline(i)
        lat=yline(i)
        call maptrn (lat,lon, xline(i),yline(i))
      enddo


      call gsfaci(ncl+3)

      

      do j=1,nsegm-1
        is=isegm(j)+1
        ns=isegm(j+1)-isegm(j)
        write(*,'(2I6,2I8,2F12.5)') j,ns, is,is+ns-1,
     &    xline(is)-xline(is+ns-1), yline(is)-yline(is+ns-1)

        
        if (ns.gt.2) then
c          if (j.ne.16 .and. j.ne.48 .and. j.ne.49 .and. j.ne.61) then
            call gfa (ns, xline(is),yline(is))
            call curved (xline(is), yline(is),ns)

            write(string,'(I3)') j
            call mark_start (xline(is),yline(is))
            call mark_end (xline(is+ns-1),yline(is+ns-1))
            call plchhq (xline(is),yline(is)+0.01,string,0.01,30.,0.)
            call frame
          endif
c        endif
      enddo
/*
      ns=0
      do j=1,nsegm-1
        if (isegm(j+1)-isegm(j).gt.ns) then
          is=j
          ns=isegm(j+1)-isegm(j)
        endif
      enddo
      j=is
      is=isegm(j)+1
      ns=isegm(j+1)-isegm(j)
      write(*,*) j,is,ns, is,is+ns-1
      call gfa (ns, xline(is),yline(is))
*/          




c      call gslwsc (thick_line)
      do j=1,nsegm-1
         call curved (xline(isegm(j)+1), yline(isegm(j)+1),
     &                                 isegm(j+1)-isegm(j))
      enddo
c      call gslwsc (medium_line)

      write(*,*) 'return from landfill', ncst, nsegm
      return
      end




      subroutine connect (xline,yline,ncst,lon,lat,xrim,yrim,nrim,ir)
!
! input: lon,lat      the most recent point which just entered domain
!        ncst         index the last coastline point inside domain
!                               recorded into arrays xline,yline.
!        xline,yline  arrays to store coastline.
!        xrim, yrim   arrays which store rim of the domain.
!        nrim         length of rim (the length of periodicity)
!        ir           directional switch +1 counterclockwise
!
! output: xline,yline  updated by the line which connects the last
!                      recorded point xline(ncst),yline(ncst) where
!                      ncst is entry value of ncst with the new point
!                      lon,lat. The connection is done along the rim
!                      in clockwise direction. 
!                      
!         ncst         incremented by necessary length to accomodate
!                      rim points.
!
      implicit none
      integer ncst,nrim, ir, i, is,ie, ip,in
      real xline(ncst+nrim),yline(ncst+nrim), lon,lat,  xi,eta, cff,
     &            xrim(nrim),yrim(nrim),  err,err_min,  dx,dy, dp,dn
      is=1
      err_min=(xline(ncst)-xrim(is))**2+(yline(ncst)-yrim(is))**2
      do i=2,nrim
        err = (xline(ncst)-xrim(i ))**2+(yline(ncst)-yrim(i ))**2
        if (err .lt. err_min) then
          is=i
          err_min=err
        endif
      enddo

      ie=1
      err_min=(lon-xrim(ie))**2+(lat-yrim(ie))**2
      do i=2,nrim
        err = (lon-xrim(i ))**2+(lat-yrim(i ))**2
        if (err .lt. err_min) then
          ie=i
          err_min=err 
        endif
      enddo


      dx=xrim(is)-xline(ncst)
      dy=yrim(is)-yline(ncst)
      ip=is+1
      if (ip.gt.ncst) ip=ip-ncst
      dp=dx*(xrim(ip)-xline(ncst)) + dy*(yrim(ip)-yline(ncst))
      in=is-1
      if (in.lt.1) in=in+ncst
      dn=dx*(xrim(in)-xline(ncst)) + dy*(yrim(in)-yline(ncst))
      if (dp.gt.0. .and. dn.lt.0) then
        i=in
        cff=-1.
      elseif (dp.lt.0. .and. dn.gt.0) then
        i=ip
        cff=+1.
      else
        write(*,*) 'Algorithm failure in connect.'
        stop
      endif
      dx=xrim(i)-xrim(is)
      dy=yrim(i)-yrim(is)
      xi=( dx*(xline(ncst)-xrim(is)) + dy*(yline(ncst)-yrim(is))
     &                                            )/(dx*dx+dy*dy)
      if (xi.lt.-0.5 .or. xi.gt.0.5) then
        write(*,*) 'Algorithm failure in connect, xi=',xi
        stop
      else
        xi=cff*xi
      endif


      dy=xrim(ie)-lon
      dy=yrim(ie)-lat
      ip=ie+1
      if (ip.gt.ncst) ip=ip-ncst
      dp=dx*(xrim(ip)-lon) + dy*(yrim(ip)-lat)
      in=ie-1
      if (in.lt.1) in=in+ncst
      dn=dx*(xrim(in)-lon) + dy*(yrim(in)-lat)
      if (dp.gt.0. .and. dn.lt.0) then
        i=in
        cff=-1.
      elseif (dp.lt.0. .and. dn.gt.0) then
        i=ip
        cff=+1.
      else
        write(*,*) 'Algorithm failure in connect.'
        stop
      endif
      dx=xrim(i)-xrim(ie)
      dy=yrim(i)-yrim(ie)
      eta=( dx*(lon-xrim(ie)) + dy*(lat-yrim(ie)) )/(dx*dx+dy*dy)
      if (eta.lt.-0.5 .or. eta.gt.0.5) then
        write(*,*) 'Algorithm failure in connect, eta=',eta, ie
        stop
      else
        eta=cff*eta
      endif



      if (is.eq.ie) then
        write(*,'(1x,A$)') 'ambiguous'
      endif

      write(*,*) 'is+xi =',float(is)+xi, '  ie+eta =',float(ie)+eta,
     &                            '  ir =',ir

      cff=float(ie-is)+eta-xi
      if (abs(cff).lt.1.) return


      is=is-ir
      if (is.gt.nrim) then
        is=is-nrim
      elseif (is.lt.1) then
        is=is+nrim
      endif
      do while (is.ne.ie)
        is=is+ir
        if (is.gt.nrim) then
          is=is-nrim
        elseif (is.lt.1) then 
          is=is+nrim
        endif
        ncst=ncst+1
        xline(ncst)=xrim(is)
        yline(ncst)=yrim(is)
      enddo
      return
      end







      subroutine mark_start (x,y)
      implicit none
      real x,y, dx,dy
      parameter (dx=0.005, dy=dx)
      call line (x-dx,y, x+dx,y)
      call line (x,y-dy, x,y+dy)
      return
      end

      subroutine mark_end (x,y)
      implicit none
      real x,y, dx,dy
      parameter (dx=0.0036, dy=dx)
      call line (x-dx,y-dy, x+dx,y+dy)
      call line (x-dx,y+dy, x+dx,y-dy)
      return
      end

      
