      subroutine jebar (ujbar,vjbar,L,M,phi,h,pm,pn)
c
c=======================================================================
c  Copyright (c) 1997 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This subroutine computes the Joint Effect of Baroclinicity and    ===
c  bottom Relief (JEBAR) at PSI-points.                              ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     L        Number of grid points in the XI-direction.            ===
c     M        Number of grid points in the ETA-direction.           ===
c     phi      Bottom dynamic pressure (Pa).                         ===
c     h        Bathymetry (m).                                       ===
c     pm       Coordinate transformation metric "m" (1/meters)       ===
c              associated with the differential distances in XI.     ===
c     pn       Coordinate transformation metric "n" (1/meters)       ===
c              associated with the differential distances in ETA.    ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     ujbar    JEBAR component in the XI-direction (m^2/s^2).        ===
c     vjbar    JEBAR component in the ETA-direction (m^2/s^2).       ===
c                                                                    ===
c=======================================================================
c
      implicit none
      integer L, M, i, j
      real p25
      real h(0:L,0:M), phi(0:L,0:M), pm(0:L,0:M), pn(0:L,0:M), 
     &     ujbar(L,0:M), vjbar(0:L,M)
      parameter (p25=0.25)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Compute JEBAR vector components.
c
      do j=0,M
        do i=1,L
          ujbar(i,j)=p25*(phi(i-1,j)+phi(i,j))*
     &                   (pm (i-1,j)+pm (i,j))*(h(i,j)-h(i-1,j))
        enddo
      enddo
      do j=1,M
        do i=0,L
          vjbar(i,j)=p25*(phi(i,j-1)+phi(i,j))* 
     &                   (pn (i,j-1)+pn (i,j))*(h(i,j)-h(i,j-1))
        enddo
      enddo
      return
      end
