      subroutine INTERSECT (IAM, KF1,IAU,ILP, IQL,IQU,IQB,IQT,
     &                      ISX,ISY, IPN,IPI,IPX, IO1,IO2,ierr)
!
! The following internal procedure looks for intersection between the
! segments identified by the pointers IQL and IQU.  When such points of
! intersection are found, they are interpolated along the intersecting
! line segments and any line segments which pass within one unit.
!
      implicit none
      integer IAM(*), KF1,IAU,ILP, IQL,IQU,IQB,IQT,
     &   ISX,ISY, IPN,IPI,IPX, IO1(4,8),IO2(4,4), ierr

      logical lswch
      integer IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4, IX0,IY0
      real  TMP,DSQ
      double precision DPT,DP1,DP2,DX0,DY0
      integer IO3(4,8),IO4(4,18),IO5(4,4)

      data IO3 / 1 ,  1 ,  0 ,  0 ,
     +           1 ,  2 ,  0 ,  0 ,
     +           1 ,  3 ,  0 ,  0 ,
     +           1 ,  4 ,  0 ,  0 ,
     +           4 ,  5 ,  1 ,  2 ,
     +           4 ,  6 ,  3 ,  4 ,
     +           3 ,  7 ,  5 ,  6 ,
     +           5 ,  7 ,  0 ,  0 /
      data IO4 / 1 ,  7 ,  0 ,  0 ,
     +           1 ,  8 ,  0 ,  0 ,
     +           4 ,  9 ,  7 ,  8 ,
     +           1 ,  7 ,  0 ,  0 ,
     +           1 ,  8 ,  0 ,  0 ,
     +           4 , 10 ,  7 ,  8 ,
     +           3 ,  5 ,  9 , 10 ,
     +           1 ,  7 ,  0 ,  0 ,
     +           1 ,  8 ,  0 ,  0 ,
     +           4 ,  9 ,  7 ,  8 ,
     +           1 ,  7 ,  0 ,  0 ,
     +           1 ,  8 ,  0 ,  0 ,
     +           4 , 10 ,  7 ,  8 ,
     +           3 ,  6 ,  9 , 10 ,
     +           4 ,  7 ,  3 ,  5 ,
     +           4 ,  8 ,  1 ,  6 ,
     +           3 ,  9 ,  7 ,  8 ,
     +           5 ,  9 ,  0 ,  0 /
      data IO5 / 4 ,  7 ,  2 ,  5 ,
     +           4 ,  8 ,  4 ,  6 ,
     +           3 ,  9 ,  7 ,  8 ,
     +           5 ,  9 ,  0 ,  0 /

c      integer icount
c      data icount /0/
c      icount=icount+1
c      write(*,*) icount

      if (KF1.eq.0 .or.
     &    IAM(IAM(IQL+4)+8).LE.0 .or. IAM(IAM(IQL+4)+9).LE.0 .or.
     &    IAM(IAM(IQU+4)+8).LE.0 .or. IAM(IAM(IQU+4)+9).LE.0) then
        IX1=IAM(IAM(IQL+2)+1)
        IY1=IAM(IAM(IQL+2)+2)
        IX2=IAM(IAM(IQL+3)+1)
        IY2=IAM(IAM(IQL+3)+2)
        IX3=IAM(IAM(IQU+2)+1)
        IY3=IAM(IAM(IQU+2)+2)
        IX4=IAM(IAM(IQU+3)+1)
        IY4=IAM(IAM(IQU+3)+2)
        if (IAU.eq.1) then
          TMP=real(IX2-IX1)*real(IY4-IY3)-real(IX4-IX3)*real(IY2-IY1)
        elseif (IAU.eq.2) then
          DPT=dble(IX2-IX1)*dble(IY4-IY3)-dble(IX4-IX3)*dble(IY2-IY1)
          TMP=real(DPT)
        else
          IO3(3, 1)=IX2-IX1
          IO3(3, 2)=IY4-IY3
          IO3(3, 3)=IX4-IX3
          IO3(3, 4)=IY2-IY1
          call ARMPIA (IO3,DPT,ierr)
          if (ierr.ne.0) then
            ierr=10028
            return
          endif
          TMP=real(DPT)
        endif

        if (abs(TMP) .gt. 0.1) then
          if (IAU.eq.1) then
            IX0=int(max(-1., min( real(ILP),
     &      ( real(IX4-IX3)*(real(IX2)*real(IY1)-real(IX1)*real(IY2))
     &       -real(IX2-IX1)*(real(IX4)*real(IY3)-real(IX3)*real(IY4))
     &                                                  )/TMP+0.5 )))
            IY0=int(max(-1., min( real(ILP),
     &      ( real(IY4-IY3)*(real(IX2)*real(IY1)-real(IX1)*real(IY2))
     &       -real(IY2-IY1)*(real(IX4)*real(IY3)-real(IX3)*real(IY4))
     &                                                  )/TMP+0.5 )))
          elseif (IAU.eq.2) then
            IX0=int(max(-1.D0, min( dble(ILP),
     &      ( dble(IX4-IX3)*(dble(IX2)*dble(IY1)-dble(IX1)*dble(IY2))
     &       -dble(IX2-IX1)*(dble(IX4)*dble(IY3)-dble(IX3)*dble(IY4))
     &                                                 )/DPT+0.5D0)))
            IY0=int(max(-1.D0, min( dble(ILP),
     &      ( dble(IY4-IY3)*(dble(IX2)*dble(IY1)-dble(IX1)*dble(IY2))
     &       -dble(IY2-IY1)*(dble(IX4)*dble(IY3)-dble(IX3)*dble(IY4))
     &                                                )/DPT+0.5D0 )))
          else
            IO4(3, 1)=IX2
            IO4(3, 2)=IY1
            IO4(3, 4)=IX1
            IO4(3, 5)=IY2
            IO4(3, 8)=IX4
            IO4(3, 9)=IY3
            IO4(3,11)=IX3
            IO4(3,12)=IY4
            call ARMPIA (IO4,DX0,ierr)
            if (ierr.ne.0) then
              ierr=10028
              return
            endif
            IX0=int(max(-1.D0, min(dble(ILP), DX0/DPT+0.5D0)))
            call ARMPIA (IO5,DY0,ierr)
            if (ierr.ne.0) then
              ierr=10028
              return
            endif
            IY0=int(max(-1.D0, min(dble(ILP), DY0/DPT+0.5D0)))
          endif

          if (IX0.eq.ISX .and. IY0.LT.ISY) IX0=IX0+1
!
! The following logical statement selects cases where intersection
! point (X0,Y0) lies between the ends of each segment, i.e., the
! two segments do intersect.
!
          if (real(IX0-IX1)*real(IX0-IX2).le.0. .and.
     &        real(IY0-IY1)*real(IY0-IY2).le.0.  .and.
     &        real(IX0-IX3)*real(IX0-IX4).le.0.  .and.
     &        real(IY0-IY3)*real(IY0-IY4).le.0. ) then
            lswch=.false. 
c       write(*,*) 'intersect', IX1,IX0,IX2, ' ', IY1,IY0,IY2
c       write(*,*) '         ', IX3,IX0,IX4, ' ', IY3,IY0,IY4

            if ((IX0.ne.IX1 .or. IY0.ne.IY1) .and.
     &          (IX0.ne.IX2 .or. IY0.ne.IY2)) then
              lswch=.true.
              IPI=IAM(IQL+4)
              call ADDPOINT (IAM, IX0,IY0, IPN,IPI,IPX, ierr)
              if (ierr.ne.0) then
                ierr=10008
                return
              endif
              IAM(IQL+3)=IPN
              IF (IAM(IQL+4).ne.IAM(IQL+2)) IAM(IQL+4)=IPN
            endif

            if ((IX0.ne.IX3 .or. IY0.ne.IY3) .and.
     &          (IX0.ne.IX4 .or. IY0.ne.IY4)) then
              lswch=.true. 
              IPI=IAM(IQU+4)
              call ADDPOINT (IAM, IX0,IY0, IPN,IPI,IPX, ierr)
              if (ierr.ne.0) then
                ierr=10008
                return
              endif
              IAM(IQU+3)=IPN
              IF (IAM(IQU+4).ne.IAM(IQU+2)) IAM(IQU+4)=IPN
            endif

            if (lswch) then
              IQT=IQB
              do while (IQT.ne.0)
                IX1=IAM(IAM(IQT+2)+1)
                IY1=IAM(IAM(IQT+2)+2)
                IX2=IAM(IAM(IQT+3)+1)
                IX2=real(IX2)
                IY2=IAM(IAM(IQT+3)+2)

                if (IAU.eq.1) then
                  TMP=max(0., min(1., ( real(IX0-IX1)*real(IX2-IX1)
     &                                 +real(IY0-IY1)*real(IY2-IY1)
     &                              )/( real(IX2-IX1)*real(IX2-IX1)
     &                                 +real(IY2-IY1)*real(IY2-IY1)
     &                                                          )))
                  DSQ=(real(IX1-IX0)+real(IX2-IX1)*TMP)**2
     &               +(real(IY1-IY0)+real(IY2-IY1)*TMP)**2
                elseif (IAU.eq.2) then
                  DPT=max(0.D0, min(1.D0,( dble(IX0-IX1)*dble(IX2-IX1)
     &                                    +dble(IY0-IY1)*dble(IY2-IY1)
     &                                 )/( dble(IX2-IX1)*dble(IX2-IX1)
     &                                    +dble(IY2-IY1)*dble(IY2-IY1)
     &                                                             )))
                  DSQ=(dble(IX1-IX0)+dble(IX2-IX1)*DPT)**2
     &               +(dble(IY1-IY0)+dble(IY2-IY1)*DPT)**2
                else
                  IO1(3,1)=IX2-IX1
                  IO1(3,2)=IY2-IY1
                  IO1(3,3)=IX0-IX1
                  IO1(3,4)=IY0-IY1
                  CALL ARMPIA (IO1,DP1,ierr)
                  if (ierr.ne.0) then
                    ierr=10028
                    return
                  endif
                  CALL ARMPIA (IO2,DP2,ierr)
                  IF (ierr.ne.0) then
                    ierr=10028
                    return
                  endif
                  DPT=MAX(0.D0,MIN(1.D0,DP1/DP2))
                  DSQ=(dble(IX1-IX0)+dble(IX2-IX1)*DPT)**2
     &               +(dble(IY1-IY0)+dble(IY2-IY1)*DPT)**2
                endif

                if (DSQ.LT.1. .and. (IX1.ne.IX0 .or. IY1.ne.IY0) .and.
     &                              (IX2.ne.IX0 .or. IY2.ne.IY0)) then
                  IPI=IAM(IQT+4)
                  call ADDPOINT (IAM, IX0,IY0, IPN,IPI,IPX, ierr)
                  if (ierr.ne.0) then
                    ierr=10008
                    return
                  endif
                  IAM(IQT+3)=IPN
                  IF (IAM(IQT+4).ne.IAM(IQT+2)) IAM(IQT+4)=IPN
                endif
                IQT=IAM(IQT)
              enddo
            endif
          endif
        endif
      endif
      return
      end

