      subroutine hordiv (hdiv, L,M,N, u,v, Hz, pm,pn, spval)
!
! Compute horizontal divergence in flux form
!
!       div = m*n*[d(Hz*u/n)/d(xi) + d(Hz*v/m)d(eta)]
!
! input: L       Number of grid points in the XI-direction
!        M       Number of grid points in the ETA-direction
!        N       Number of vertical levels
!        u       vector component (m/s) in the XI-direction
!        v       vector component (m/s) in the ETA-direction
!        Hz      total depth or vertical thicknesses (m)
!        pm      Coordinate transformation metric "m" (1/meters)
!                associated with the differential distances in XI
!        pn      Coordinate transformation metric "n" (1/meters)
!                associated with the differential distances in ETA
!       spval    Masked special value
!
! output: hdiv   Horizontal divergence (m/s)
!
! Copyright (c) 1997 Rutgers University
!
      implicit none
      integer L,M,N, i,j,k
      real hdiv(L-1,M-1,N), u(L,0:M,N),v(0:L,M,N),
     &     Hz(0:L,0:M,N), pm(0:L,0:M),pn(0:L,0:M), spval

      do k=1,N
        do j=1,M-1
          do i=1,L-1
            if (u(i,j,k).eq.spval .or. u(i+1,j,k).eq.spval .or.
     &          v(i,j,k).eq.spval .or. v(i,j+1,k).eq.spval) then
              hdiv(i,j,k)=spval
            else
              hdiv(i,j,k)=pm(i,j)*pn(i,j)*(
     &                         u(i+1,j,k)*(Hz(i,j,k)+Hz(i+1,j,k))
     &                                       /(pn(i,j)+pn(i+1,j))
     &                        -u(i  ,j,k)*(Hz(i-1,j,k)+Hz(i,j,k))
     &                                       /(pn(i-1,j)+pn(i,j))
     &                        +v(i,j+1,k)*(Hz(i,j,k)+Hz(i,j+1,k))
     &                                       /(pm(i,j)+pm(i,j+1))
     &                        -v(i,j  ,k)*(Hz(i,j-1,k)+Hz(i,j,k))
     &                                       /(pm(i,j-1)+pm(i,j))
     &                                                          )
            endif
          enddo
        enddo
      enddo
      return
      end
