      subroutine gks_init (postscript, page_number, icolor, ifill)
      implicit none
      logical postscript 
      integer page_number, icolor, ifill, i, lasf(13), ngpswk, unused 
      character*13 string
      do i=1,13                 ! Set GKS aspect source 
        lasf(i)=1               ! flags to "individual",
      enddo                     ! NCAR default setting.
            
      page_number=page_number+1
      if (postscript) then
        call gopks(6,unused)
        write(string,'(A6,I4,A3)') 'gmeta.', page_number, '.ps'
        do i=7,9
          if (string(i:i).eq.' ') string(i:i)='0'
        enddo
        call ngsetc('ME',string(1:13))
        if (icolor.ne.0 .or. ifill.eq.0) then
          if (page_number.eq.1) then
            write(*,'(/1x,A/1x,A/)')
     &              'Producing sequence of Color PostScript files.',
     &              '========= ======== == ===== ========== ======'
          endif
          call gopwk(1, 2, ngpswk('EPS','PORTRAIT','COLOR'))
        else
          if (page_number.eq.1) then
            write(*,'(/1x,A/1x,A/)')
     &         'Producing sequence of Monochrome PostScript files.',
     &         '========= ======== == ========== ========== ======'
          endif
          call gopwk(1, 2, ngpswk('EPS','PORTRAIT','MONOCHROME'))
        endif
        call gacwk(1)           ! Open NCAR GKS (either to create
      else                      ! a sequence of postscript files or
        call opngks             ! in gmeta mode. Turn the clipping
      endif                     ! indicator ON; Set all the GKS
      call gsclip(1)            ! aspect source ource flags to
      call gsasf(lasf)          ! "individual" and force solid fill.
      call gsfais(1)
c--      if (icolor.ne.0 .and. page_number.eq.1) then
        call set_palette
c--      endif                     ! Read in color palette file and set
      return                    ! up color indices (first call only).
      end

