      subroutine get_wcurl (curl,xpos,ypos,im,jm,igrid,ncgid,ncfid,
     &                      idfld,tindex)
c
c=======================================================================
c  Copyright (c) 1997 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This subroutine computes surface wind stress curl from input      ===
c  NetCDF file.                                                      ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     ncfid    NetCDF ID for input fields (integer).                 ===
c     idfld    Identification of field to read (integer).            ===
c     tindex   Time dimension index to read (integer).               ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     curl     Surface wind stress curl (m/s2; real array).          ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     igrid    Staggered C-grid type for requested field (integer).  ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c                                                                    ===
      implicit none
#include "param.h"
#include "pconst.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltlab.h"
#include "secbath.h"

      integer i, idfld, igrid, im, imr, imu, imv, ip, irgrid, iugrid,
     &        ivgrid, j, jm, jmr, jmu, jmv, ncfid, ncgid, nc_pid,
     &        nc_uid, nc_vid, tindex
      real spv, uspv, vspv
      real curl(NV), xpos(NV), ypos(NV)
      character*20 fldnam

      levless=is2d(idfld)
      fldnam1=vname1(idfld)
      fldnam2=vname2(idfld)
c
c  Read in Coordinate transformation metrics.
c
      fldnam='pm'
      call get_nc2dat (x,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,spv)
      fldnam='pn'
      call get_nc2dat (y,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,spv)
c
c  Read in surface u-wind stress and store in f2.
c
      call get_nc2dat (f2,NV,imu,jmu,ncfid,tindex,fldnam1,0,iugrid,
     &                 nc_uid,uspv)
c
c  Read in surface u-wind stress and store in f3.
c
      call get_nc2dat (f3,NV,imv,jmv,ncfid,tindex,fldnam2,0,ivgrid,
     &                 nc_vid,vspv)
c
c  Compute surface wind stress curl (m/s2) at interior RHO-points.
c
c  Scale surface wind stress curl to (m/s2).  Divide by rho0; assume a
c  value of 1000 kg/m3.
c
      im=imr-2
      jm=jmr-2
      call curlz (curl,imr-1,jmr-1,f2,f3,x,y)
      do i=1,im
        do j=1,jm
          ip=i+(j-1)*im
          curl(ip)=0.001*curl(ip)
        enddo
      enddo
c
c  Get horizontal positions at interior RHO-points
c
      igrid=7
      call get_nc2pos (x,y,NV,im,jm,ncgid,igrid)
      return
      end
