      subroutine get_scoor (xpos,ypos, im,jm)
!
! Set horizontal coordinate for vertical section.
!
! input:  xpos,ypos  X,Y-coordinates of nodes of a two-dimensional,
!                            curvilinear, logically rectangular grid.
!                            They may be either Cartezian (km) or
!                            spherical Lon,Lat (degrees) coordinates.
!           im,jm    sizes of inner and outer dimensions.
!
!        xsec1,ysec1 (via common block) coordinates of starting
!        xsec2,ysec2 and ending point of the desired crossection. 
!
! output: xsec,ysec  (into common block) coordinates on nodes of the
!                    desired cross-section specified by xsec1...ysec2
!            ims     number of nodes in the cross-section.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer im,jm,                   i1,i2, j1,j2, n, step
      real xpos(im,jm), ypos(im,jm),   xs1,ys1, xs2,ys2, u,v
      real*8 Pi, deg2rad, rad2deg, HalfPi, epsil
      parameter (Pi=3.14159265358979323846D0, rad2deg=180.D0/Pi,
     &           deg2rad=Pi/180.D0, HalfPi=0.5D0*Pi, epsil=1.D-15)
      real*8 a11,a12,a13, csP,snP, x1,x2, xn, x, dr, csA,   Lon, 
     &       a21,a22,a23, csT,snT, y1,y2, yn, y, dh, snA,   Lat,
     &       a31,a32,a33, csF,snF, z1,z2, zn, cff,   csLat, alpha

#include "param.h"
#include "pltfld.h"
#include "pltio.h"
#include "secpos.h"

      i1=0
      j1=0
      i2=0
      j2=0
!
! Set starting and ending section points.
!---- -------- --- ------ ------- -------
!
      if (isecpos.eq.0) then           ! If points are specified in
        i1=int(xsec1)                  ! grid units, convert them
        j1=int(ysec1)                  ! into physical units.
        u=xsec1-float(i1)
        v=ysec1-float(j1)
        i1=max(1,min(im,i1))
        j1=max(1,min(jm,j1))
        if (u.eq.0. .and. v.eq.0.) then
          xs1=xpos(i1,j1)
          ys1=ypos(i1,j1)
        else
          i1=min(i1,im-1)
          j1=min(j1,jm-1)
          xs1=(1.-v)*((1.-u)*xpos(i1,j1)+u*xpos(i1+1,j1))
     &          +v*((1.-u)*xpos(i1,j1+1)+u*xpos(i1+1,j1+1)) 
          ys1=(1.-v)*((1.-u)*ypos(i1,j1)+u*ypos(i1+1,j1))
     &          +v*((1.-u)*ypos(i1,j1+1)+u*ypos(i1+1,j1+1))
        endif
        i2=int(xsec2)
        j2=int(ysec2)
        u=xsec2-float(i2)
        v=ysec2-float(j2)
        i2=max(1,min(im,i2))
        j2=max(1,min(jm,j2))
        if (u.eq.0. .and. v.eq.0.) then
          xs2=xpos(i2,j2)
          ys2=ypos(i2,j2)
        else
          i2=min(i2,im-1)
          j2=min(j2,jm-1)
          xs2=(1.-v)*((1.-u)*xpos(i2,j2)+u*xpos(i2+1,j2))
     &          +v*((1.-u)*xpos(i2,j2+1)+u*xpos(i2+1,j2+1))
          ys2=(1.-v)*((1.-u)*ypos(i2,j2)+u*ypos(i2+1,j2))
     &          +v*((1.-u)*ypos(i2,j2+1)+u*ypos(i2+1,j2+1))
        endif 
      else
        xs1=xsec1
        xs2=xsec2
        ys1=ysec1
        ys2=ysec2
      endif
!
!
!
      if (spherical .and. isecpos.eq.0 .and. i1.eq.i2) then
        if (j2.gt.j1) then
          step=1                           ! Sections along XI- or
        else                               ! ETA-axis in spherical
          step=-1                          ! configuration.
        endif
        ims=1+step*(j2-j1)
        do n=1,ims
          xsec(n)=xpos(i1,j1+step*(n-1))
          ysec(n)=ypos(i1,j1+step*(n-1))
        enddo
      elseif (spherical .and. isecpos.eq.0 .and. j1.eq.j2) then
        if (i2.gt.i1) then
          step=1
        else
          step=-1
        endif
        ims=1+step*(i2-i1)
        do n=1,ims
          xsec(n)=xpos(i1+step*(n-1),j1)
          ysec(n)=ypos(i1+step*(n-1),j1)
        enddo
      elseif (spherical) then
!
! General case of arbitrary oriented crossection along "big circle"
! in spherical geometry. It is assumed that (xs1,ys1) and (xs2,ys2)
! are longitude--latutude spherical coordinates expressed in degrees
! belonging to two non-coincident points on the surface of the
! sphere. They may be arbitrary, except "antipode" points.
! NOTE: the following code segment uses double precision
! trigonometric functions with results converted back to single
! precision.
!
        z1=sin(deg2rad*ys1)         ! Translate longitude-latitude
        csLat=sqrt(1.D0-z1*z1)      ! spherical coordinates of the
        x1=csLat*cos(deg2rad*xs1)   ! starting point of crossection
        y1=csLat*sin(deg2rad*xs1)   ! into 3-dimensional vector

        z2=sin(deg2rad*ys2)         ! The same for the ending point
        csLat=sqrt(1.D0-z2*z2)      ! of the crossection.
        x2=csLat*cos(deg2rad*xs2)   ! Note that sperical coordinates
        y2=csLat*sin(deg2rad*xs2)   ! are expressed in degrees.

        xn=y1*z2-y2*z1              ! Find vector orthogonal to both
        yn=z1*x2-z2*x1              ! vectors defined above, i.e.
        zn=x1*y2-x2*y1              ! vector product of them.

        dh=xn*xn+yn*yn              ! Determine Eulerian angles Psi,
        dr=dh+zn*zn                 ! Theta and Phi (angles of
        if (dr .gt. 0.D0) then      ! precession, nutation, and pure
          dr=sqrt(dr)               ! rotation respectively) which
          csT=zn/dr                 ! simultaneously turn vector
          if (dh .gt. 0.D0) then    ! (1,0,0) into (x1,y1,z1), and
            dh=sqrt(dh)             ! (0,0,1) into (xn,yn,zn).
            snT=dh/dr
            snP=xn/dh               ! [Notation adopted here: cos(X)
            csP=yn/dh               !  --> csX; sin(X) --> snX, where
            csF=x1*csP-y1*snP       !  X=Psi, Theta or Phi, such that
            if (snT .gt. 0.D0) then !  Psi --> P; Theta --> T; and
              snF=z1/snT            !  Phi --> F.]
            else
              snF=-(x1*snP+y1*csP)/csT
            endif
          else
            snT=0.D0                ! Case xn=yn=0, zn=+/-1, hence
            snP=0.D0                ! Theta=0. In this case Euler
            csP=1.D0                ! angles Psi and Phi taken
            csF=x1                  ! separately loose meaning,
            snF=-y1                 ! only sum Psi+Phi makes sense.
          endif

          a11= csP*csF-snP*csT*snF    ! Filling up matrix of
          a12=-snP*csF-csP*csT*snF    ! rotation by Euler angles
          a13=     snT*snF            ! Psi, Theta, and Phi, then
          a21= csP*snF+snP*csT*csF    ! checking for accuracy.
          a22=-snP*snF+csP*csT*csF
          a23=    -snT*csF
          a31=snP*snT
          a32=csP*snT
          a33=    csT

          if (abs(a21*x1+a22*y1+a23*z1) .gt. epsil .or.
     &        abs(a31*x1+a32*y1+a33*z1) .gt. epsil  .or.
     &        abs(a31*x2+a32*y2+a33*z2) .gt. epsil) then
            write(*,*) 'Error: spherical geometry algorithm failure'
            stop
          endif

          x=a11*x2+a12*y2+a13*z2            ! Determine angle alpha
          y=a21*x2+a22*y2+a23*z2            ! between vectors (x1,y1,
          dr=sqrt(x*x+y*y)                  ! z1) and (x2,y2,z2).
          if (abs(x) .gt. abs(y)) then
            alpha=asin(y/dr)                ! Note that Euler angle
            if (x .lt. 0.D0) alpha=Pi-alpha ! matrix is orthogonal,
          else                              ! i.e., it has property
            alpha=HalfPi-asin(x/dr)         ! that its inverse is
            if (y .lt. 0.D0) alpha=-alpha   ! equal to transpose.
          endif

          ims=max(2, 1+int( 0.5+rad2deg*alpha/dels ) )
          cff=alpha/float(ims-1)
#if VERBOSE > 1
          write(*,*) 'get_scoor: alpha =',rad2deg*alpha, ' ims =',ims
#endif
          do n=1,ims
            alpha=cff*float(n-1)
            csA=cos(alpha)
            snA=sin(alpha)
            x=a11*csA+a21*snA
            y=a12*csA+a22*snA
            dr=sqrt(x*x+y*y)
            if (abs(x) .gt. abs(y)) then       ! Both alternatives
              Lon=rad2deg*asin(y/dr)           ! are mathematically
              if (x .lt. 0.D0) Lon=180.D0-Lon  ! equivalent; this
            else                               ! branching is needed
              Lon=90.D0-rad2deg*asin(x/dr)     ! only to reduce
              if (y .lt. 0.D0) Lon=-Lon        ! roundoff errors.
            endif
            Lat=rad2deg*asin(a13*csA+a23*snA)
c**         write(*,'(i4,3F18.12)') i, rad2deg*alpha, Lon,Lat
            xsec(n)=Lon
            ysec(n)=Lat
          enddo
        else
          write(*,*) 'Error: complanar vectors.'
          stop
        endif
      else
!
! Cartesian grid: connect two points defining the section.
!
        ims=max(2,1+int(0.5+sqrt((xs2-xs1)**2 + (ys2-ys1)**2)/dels))
        cff=1./float(ims-1)
        do n=1,ims
          xsec(n)=cff*(xs1*float(ims-n) + xs2*float(n-1)) 
          ysec(n)=cff*(ys1*float(ims-n) + ys2*float(n-1))
        enddo
      endif
      return
      end
