      subroutine get_rig (Rig,xpos,ypos,zpos,im,jm,km,igrid,ncgid,ncfid,
     &                    idfld,tindex,level,gotzeta,gotsalt,gotrho,
     &                    file)
!
! Compute gradient Richardson number.
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     ncfid    NetCDF ID for input fields (integer).                 ===
c     idfld    Identification of field to read (integer).            ===
c     tindex   Time dimension index to read (integer).               ===
c     level    Depth (>0), level (>0), or isopycnal (>1000) to       ===
c              process (real). If LEVEL=0, the full 3D is passed.    ===
c     gotzeta  Logical switch indicating availability of free-       ===
c              surface.                                              ===
c     gotsalt  Logical switch indicating availability of salinity.   ===
c     gotrho   Logical switch indicating availability of density.    ===
c     file     NetCDF file to read (primary or secondary; integer).  ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     Rig      Gradient Richardson number (real array).              ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     km       Size of vertical dimension (integer).                 ===
c     igrid    Staggered C-grid type for requested field (integer).  ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c     zpos     Z-positions of the requested field (real array).      ===
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "param.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "secbath.h"
      logical gotrho, gotsalt, gotzeta
      integer file, i, idfld, igrid, im, imr, imu, imv, ip, ir, irgrid,
     &        iugrid, ivgrid, iw, iwgrid, j, jm, jmr, jmu, jmv, k, km,
     &        kmr, ncfid, ncgid, nc_uid, nc_vid, tindex
      real level, uspv, vspv
      real Rig(NV), xpos(NV), ypos(NV), zpos(NV)
c
c  Compute Brunt-Vaisala frequency.  Store into f2.
c
      call get_bvf (f2,x,y,z,imr,jmr,km,igrid,ncgid,ncfid,tindex,0,
     &              gotzeta,gotsalt,gotrho,file)
c
c  Compute gradient Richardson number.
c
      levless=is2d(idfld)
      fldnam1=vname1(idfld)
      fldnam2=vname2(idfld)
c
c  Read in total U-velocity component and store into f3.
c
      call get_nc3dat (f3,NV,imu,jmu,kmr,ncfid,tindex,fldnam1,iugrid,
     &                 nc_uid,uspv)
c
c  Read in total V-velocity component and store into f4.
c
      call get_nc3dat (f4,NV,imv,jmv,kmr,ncfid,tindex,fldnam2,ivgrid,
     &                 nc_vid,vspv)
c
c  Get depths at RHO-points.
c
      irgrid=1
      call get_nc3pos (z,NV,imr,jmr,Nr,ncgid,ncfid,tindex,irgrid,irgrid,
     &                 gotzeta,file)
c
c  Compute gradient Richarson number.
c
      call ri_number (Rig,f2,f3,f4,z,imr-1,jmr-1,Nr)
c
c  Get vertical positions at W-points.
c
      if (level.le.0. .or. level.ge.1000.) then
        iwgrid=6
        call get_nc3pos (z,NV,imr,jmr,Nw,ncgid,ncfid,tindex,irgrid,
     &                   iwgrid,gotzeta,file)
      endif
c
c  Extract positions of size (Lm,Mm,Nm) for Richardson number.  Also
c  extract bath of size (Lm,Mm).
c
      im=imr-2
      jm=jmr-2
      km=Nw-2
      igrid=7
      do ip=1,imr*jmr
        f4(ip)=bath(ip)
      enddo
      ip=0
      do j=2,jmr-1
        do i=2,imr-1
          ip=ip+1
          ir=i+(j-1)*imr
          xpos(ip)=x(ir)
          ypos(ip)=y(ir)
          bath(ip)=f4(ir)
        enddo
      enddo
      if (level.le.0. .or. level.ge.1000.) then
        ip=0
        do k=2,Nw-1
          do j=2,jmr-1
            do i=2,imr-1
              ip=ip+1
              iw=i+(j-1)*imr+(k-1)*imr*jmr
              zpos(ip)=z(iw)
            enddo
          enddo
        enddo
      endif
c
c  If appropriate, extract Richardson number at the requested level.
c
      if ((1.le.int(level)).and.(int(level).le.km)) then
        do ip=1,im*jm*km
          f4(ip)=Rig(ip)
        enddo
        ip=0
        do j=1,jm
          do i=1,im
            ip=ip+1            
            iw=i+(j-1)*im+(int(level)-1)*im*jm
            Rig(ip)=f4(iw)
          enddo
        enddo
      endif
      return
      end
