      subroutine get_pv (pv,xpos,ypos,zpos,im,jm,km,igrid,ncgid,ncfid,
     &                   idfld,tindex,level,gotzeta,gotsalt,gotrho,file)
!                                                                    ===
! Compute potential vorticity from primary fields in input netCDF
!  file.
!
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     ncfid    NetCDF ID for input fields (integer).                 ===
c     idfld    Identification of field to read (integer).            ===
c     tindex   Time dimension index to read (integer).               ===
c     level    Depth (>0), level (>0), or isopycnal (>1000) to       ===
c              process (real). If LEVEL=0, the full 3D is passed.    ===
c     gotzeta  Logical switch indicating availability of free-       ===
c              surface.                                              ===
c     gotsalt  Logical switch indicating availability of salinity.   ===
c     gotrho   Logical switch indicating availability of density.    ===
c     file     NetCDF file to read (primary or secondary; integer).  ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     pv       Requested 3D potential vorticity (real array).        ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     km       Size of vertical dimension (integer).                 ===
c     igrid    Staggered C-grid type for requested field (integer).  ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c     zpos     Z-positions of the requested field (real array).      ===
c                                                                    ===
!
! Copyright (c) 1998 Rutgers University
!
      implicit none
#include "param.h"
#include "domdat.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltlab.h"
#include "secbath.h"
      logical gotrho, gotsalt, gotzeta
      integer file, i, idfld, igrid, im, imr, ip, irgrid, iw, iwgrid,
     &        j, jm, jmr, k, km, kmr, kr, kpr, ncfid, ncgid, nc_fid,
     &        nc_rid, nc_sid, nc_tid, tindex
      integer idens
      real level, rspv, sspv, tspv, spv
      real f(NH), pv(NV), xpos(NV), ypos(NV), zpos(NV)
      character*20 fldnam

      fldnam1=vname1(idfld)
      fldnam2=vname2(idfld)
c
c  Get depths at RHO-points.
c
      irgrid=1
      call get_nc3pos (zpos,NV,imr,jmr,Nr,ncgid,ncfid,tindex,irgrid,
     &                 irgrid,gotzeta,file)
c
c  Get density anomaly (kg/m^3).
c
      if (gotrho) then 
        fldnam='rho'
        call get_nc3dat (f2,NV,imr,jmr,kmr,ncfid,tindex,fldnam,irgrid,
     &                   nc_rid,rspv)
      elseif (gotsalt) then
        call get_nc3dat (f3,NV,imr,jmr,kmr,ncfid,tindex,fldnam1,irgrid,
     &                   nc_tid,tspv)
        call get_nc3dat (f4,NV,imr,jmr,kmr,ncfid,tindex,fldnam2,irgrid,
     &                   nc_sid,sspv)
        ip=0
        do k=1,kmr
          do j=1,jmr
            do i=1,imr
              ip=ip+1
              f2(ip)=idens(f3(ip),f4(ip),zpos(ip))
            enddo
          enddo
        enddo
      else
        print 10
  10    format(/,' GET_PV - unable to get/compute density anomaly.')
        return
      endif
c
c  Read in Coriolis parameter.
c
      fldnam='f'
      call get_nc2dat (f,NH,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_fid,spv)
c
c-----------------------------------------------------------------------
c  Compute potential vorticity (1/s/m) at W-points.
c-----------------------------------------------------------------------
c
      im=imr
      jm=jmr
      km=Nw-2
      do k=1,kmr
        do j=1,jmr
          do i=1,imr
            ip=i+(j-1)*imr
            kr=ip+(k-1)*imr*jmr
            kpr=ip+k*imr*jmr
            pv(kr)=f(ip)*(f2(kpr)-f2(kr))/(rho0*(zpos(kpr)-zpos(kr)))
          enddo
        enddo
      enddo
c
c  Get horizontal positions at RHO-points
c
      igrid=1
      call get_nc2pos (xpos,ypos,NV,imr,jmr,ncgid,igrid)
c
c  Get vertical positions at W-points.
c
      if (level.le.0. .or. level.ge.1000.) then
        iwgrid=6
        call get_nc3pos (z,NV,imr,jmr,Nw,ncgid,ncfid,tindex,igrid,
     &                   iwgrid,gotzeta,file)
      endif
c
c  Extract positions of size (Lp,Mp,Nm) for potential vorticity.
c
      if (level.le.0. .or. level.ge.1000.) then
        ip=0
        do k=2,Nw-1
          do j=1,jmr
            do i=1,imr
              ip=ip+1
              iw=i+(j-1)*imr+(k-1)*imr*jmr
              zpos(ip)=z(iw)
            enddo
          enddo
        enddo
      endif
c
c  If appropriate, extract Ertel potential vorticity at the requested
c  level.
c
      if (1.le.int(level) .and. int(level).le.km) then
        do ip=1,im*jm*km
          f4(ip)=pv(ip)
        enddo
        ip=0
        do j=1,jm
          do i=1,im
            ip=ip+1            
            iw=i+(j-1)*im+(int(level)-1)*im*jm
            pv(ip)=f4(iw)
          enddo
        enddo
      endif
      return
      end
