      subroutine get_pltday (day, ictime)
!
! Determine/Advance date to plot. If parameter dskip is positive,
! then day to plot is simply computed from time index ictime, which 
! is then advanced by 1 to be used next time. If, on the other hand, 
! dskip is negative, then time record is advanced by abs(dskip) and
! the day to plot is determined from the available times available
! from data netCDF files. if dskip=0, then record is advanced by 1
! every time, which corresponds to the plotting at own frequency.
!
! input:  ictime   time index counter (integer).
! output: get      day to plot (real).
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      real*8 day
      integer ictime, i, ierr
#include "param.h"
#include "pconst.h"
#include "ncinfo.h"
#include "pltio.h"
#include "pltfld.h"

      if (dskip.gt.0.) then
        day=frstd+dskip*(ictime-1)
      else
  1     if (ictime.eq.1) then                 ! Get first and last
          frstd=time1(1)                      ! day to plot. Use
          lastd=time1(1)                      ! primary file time
          do i=2,ntime1                       ! coordinate.
            frstd=min(frstd,time1(i))
            lastd=max(lastd,time1(i))
          enddo
          if (gottime1) then
            frstd=frstd*sec2day
            lastd=lastd*sec2day
          endif
        endif
        if (ictime .gt. ntime1) then
          if (ihist.lt.nhists) then
            call close_to_reopen (ierr)
            ihist=ihist+1
            call opencdf (history(ihist), reference(ihist), grid)
            ictime=1
            goto 1
          else
            call crash ('DONE 1',1)
          endif
        elseif (gottime1) then              ! Get time from
          day=time1(ictime)*sec2day         ! history netCDF
        else                                ! file.
          day=time1(ictime)
        endif
      endif

      if (dskip.le.-1.) then                  ! Increment time
        ictime=ictime+abs(int(dskip))         ! record index for
      else                                    ! the use next time.
        ictime=ictime+1 
      endif
      return
      end



      integer function time_indx (day, time, ntime, time_in_days)
!
! Determine the time dimension index for the current field to read.
!
! input: day    day to read (real).
!        time   input time coordinate (real array).
!        ntime  size of time dimension (integer).
!        time_in_days   logical switch for units of time
!         (.true. --> days; .false. ==> seconds or
!                                         nondimensional)
!
! returned value:  time dimension index of field to read.
!
      implicit none
      integer ntime, i, is
      real*8 day, time(ntime), timeX, X, err,err_bak  
#include "pconst.h"
      logical time_in_days          ! Set time_indx to default value
                                    ! outside the permissible range.
      if (time_in_days) then        ! NOTE: if the time record index
        timeX=day*day2sec           ! remains zero (because proper
      else                          ! day is not found because it is
        timeX=day                   ! outside the range, or because
      endif                         ! it is not in the list of days
      if (ntime.gt.0) then          ! from netCDF input file, it is
        is=1                        ! still possible to plot fields 
        err=abs(timeX-time(is))     ! which do not depend on time,
        do i=2,ntime                ! and, therefore, do not have
          X=abs(timeX-time(i))      ! time among their dimensions,
          if (X .lt. err) then      ! see get_nc3dat.F.
            is=i 
            err=X                            ! Search algorithm 
          endif                              ! used here is fail-
        enddo                                ! safe in sense that
                                             ! it expects roundoff
        if (is.gt.1) then                    ! errors, which make
          err_bak=abs(time(is)-time(is-1))   ! checking for equal
        elseif (is .lt. ntime) then          ! time impossible.
          err_bak=abs(time(is+1)-time(is))   ! Instead it finds the
        elseif (time(is) .ne. 0.) then       ! closest available time
          err_bak=abs(time(is))              ! from the record and 
        else                                 ! then decides how good 
          err_bak=1.                         ! it is based on how 
        endif                                ! the difference between   
        if (err .lt. 0.0001*err_bak) then    ! it and given time
          time_indx=is                       ! "timeX" compares to 
        else
          time_indx=0
        endif                                ! the closest difference
      endif                                  ! between times from the
                                             ! record.
#if VERBOSE > 2
      write(*,*) ' day =', day,   '  timeX=', timeX, '  ntime =',ntime
      write(*,*) 'time(:) =', (time(i),i=1,ntime)
      write(*,*) 'err=', err,   '  err_bak =', err_bak
      write(*,'(1x,A,3I5)') 'time_indx =', time_indx
#endif
      return
      end





