      subroutine get_nc3pos (zpos,np, im,jm,km, ncgid,ncfid, tindex,
     &                                ihgrid, ivgrid, gotzeta, file)
!
! Reads the depths of the current 2D or 3D field.
!
! Input:  np       Allocated size for array "zpos" (integer).
!         im       Number of inner dimension points to read (integer).
!         jm       Number of inner dimension points to read (integer).
!         km       Number of vertical levels (integer).
!         ncgid    NetCDF ID for input grid (integer).
!         ncfid    NetCDF ID for input fields (integer).
!         tindex   Time dimension index to read (integer).
!         ihgrid   Horizontal staggered C-grid type (integer):
!                     ihgrid=0  => None.
!                     ihgrid=1  => density points.
!                     ihgrid=2  => streamfunction points.
!                     ihgrid=3  => u-velocity points.
!                     ihgrid=4  => v-velocity points.
!                     ihgrid=7  => interior density points.
!         ivgrid   Vertical staggered grid type (integer):
!                     ivgrid=1  => density points.
!                     ivgrid=5  => w-velocity points, range 1:N.
!                     ivgrid=6  => w-velocity points, range 0:N.
!         gotzeta  Logical switch indicating availability of
!                  free surface.
!         file     NetCDF file to read (primary or secondary; integer).
!
! Output: zpos     Z-positions (depths) of current field.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "param.h"
#include "pconst.h"
#include "fields.h"
#include "ncinfo.h"
#include "netcdf.inc"
#include "secbath.h"

      logical gotzeta
      integer file, i, igrid, ij, ihgrid, ijk, im, ixy, ivgrid, j,
     &       jm, jxy, k, km, kz, nccid, ncfid, ncgid, nchid, ncsid,
     &           nczid,  np, ierr, tindex
      real cspv, hc, hspv, sspv, zspv, Cs(NK), sc(NK), zpos(np)
      character*60  cposnam, hposnam, sposnam, zposnam
!
! Set Depths for flat coordinates data.  It is assumed that k=1 is
! the bottom and k=km is the surface, as in the ocean model.
!
      if (file.eq.1 .and. type1(1:2).eq.'OA') then
        ixy=Lr
        jxy=Mr
        ijk=0
        do k=1,km
          do j=1,jxy
            do i=1,ixy
              ijk=ijk+1
              f6(ijk)=zinp1(k)
            enddo
          enddo
        enddo
        ij=0
        do j=1,jxy
          do i=1,ixy
            ij=ij+1
            bath(ij)=abs(zinp1(1))
          enddo
        enddo
      elseif (file.eq.2 .and. type2(1:2).eq.'OA') then
        ixy=Lr
        jxy=Mr
        ijk=0
        do k=1,km
          do j=1,jxy
            do i=1,ixy
              ijk=ijk+1
              f6(ijk)=zinp2(k)
            enddo
          enddo
        enddo
        ij=0
        do j=1,jxy
          do i=1,ixy
            ij=ij+1
            bath(ij)=abs(zinp2(1))
          enddo
        enddo
!
! Set Depths for terrain-following coordinates data.
!
      else
!
! Read in bottom topography.
!
        hposnam='h'
        call get_nc2dat (bath, NH, ixy,jxy, ncgid, tindex,
     &                    hposnam, 0., igrid, nchid, hspv)
!
! Read in nondimensional S-coordinate and stretching curves.
!
        if (ivgrid.eq.5 .or. ivgrid.eq.6) then
          sposnam='sc_w'
          cposnam='Cs_w'
        else
          sposnam='sc_r'
          cposnam='Cs_r'
        endif
        call get_nc1dat (sc,NK,kz,ncfid,tindex,sposnam,ncsid,sspv)
        call get_nc1dat (Cs,NK,kz,ncfid,tindex,cposnam,nccid,cspv)
!
! Get full range (0:N) of parameters at W-points.  The history file
! does not store fields at level 0. The value of "sc_w" and "Cs_w"
! is always -1.0 at level 0. This step is avoided if the input file
! has the full range values.

        if (ivgrid.eq.6) then
          if (kz.eq.km-1) then
            do k=kz,1,-1
              sc(k+1)=sc(k)
              Cs(k+1)=Cs(k)
            enddo
            sc(1)=-1.
            Cs(1)=-1.
          endif
        endif
!
! Read in S-coordinate parameter, "hc".
!
        ierr=nf_inq_varid(ncfid, 'hc', varid)
        if (ierr.eq.nf_noerr) then
          ierr=nf_get_var1_real (ncfid, varid, 1, hc)
        else
          ierr=nf_inq_att(ncfid, nf_global, 'hc', i,j)
          if (ierr.eq.nf_noerr) then
            ierr=nf_get_att_real (ncfid,nf_global, 'hc',hc)
          endif
        endif 
        if (ierr.ne.nf_noerr) then
          write(*,'(/1x,A,1x,A)') 'GET_NC3POS - cannot find',
     &                               'position variable: hc.'
          stop 
        endif
!
! Compute depths for current field at the requested vertical grid.
!

!
! Get free-surface (m), store in utility array "f5".
!

        if (ixy*jxy*km.gt.NV) then
          write(*,*) 'ERROR: insufficient parameter NV in param.h',
     &          'must be at least ', ixy*jxy*km
          stop
        endif


        if (gotzeta) then
          zposnam='zeta'
          call get_nc2dat (f5, NV, ixy,jxy, ncfid, tindex,
     &                     zposnam, 0., igrid, nczid, zspv)
          do k=1,km
            do j=1,jxy
              do i=1,ixy
                ij=i+(j-1)*ixy
                ijk=ij+(k-1)*ixy*jxy
                f6(ijk)=f5(ij)*(1.+sc(k))+hc*sc(k)+(bath(ij)-hc)*Cs(k)
              enddo
            enddo
          enddo
        else
          do k=1,km
            do j=1,jxy
              do i=1,ixy
                ij=i+(j-1)*ixy
                ijk=ij+(k-1)*ixy*jxy
                f6(ijk)=hc*sc(k)+(bath(ij)-hc)*Cs(k)
              enddo
            enddo
          enddo
        endif
      endif
!
! Compute depths at the requested horizontal positions.
!
      call zgrid (zpos, im,jm,km, f6,ixy,jxy,km, ihgrid)
!
! Compute bathymetry at the requested horizontal positions.
!
      do j=1,jxy
        do i=1,ixy
          ij=i+(j-1)*ixy
          f5(ij)=bath(ij)
        enddo
      enddo
      call zgrid (bath,im,jm,1,f5,ixy,jxy,1,ihgrid)
      return
      end
