#ifdef TWO_DIMENSIONAL
      subroutine get_nc2dat (f, np, im,jm,    ncid, tindx, fldnam,
     &                               level, igrid, ncvarid, spval)
#else
      subroutine get_nc3dat (f, np, im,jm,km, ncid, tindx, fldnam,
     &                                      igrid, ncvarid, spval)
#endif
!
! Reads requested 3D field from input NetCDF file.
!
! input:  np       Allocated size for array "f".
!         ncid     NetCDF ID for input file (integer).
!         tindx    Time dimension index to read (integer).
!         fldnam   Name of field to read (character).
!
! output: f        Requested 3D field (real array).
!         im       Size of inner dimension (integer).
!         jm       Size of outer dimension (integer).
!         km       Size of vertical dimension (integer).
!         igrid    Staggered C grid type (integer):
!                      igrid=0  => None.
!                      igrid=1  => density points.
!                      igrid=2  => streamfunction points.
!                      igrid=3  => u-velocity points.
!                      igrid=4  => v-velocity points.
!                      igrid=5  => w-velocity points.
!         ncvarid  Variable ID in input NetCDF file (integer).
!         spval    Missing data/fill data value (real).
!
      implicit none
#include "netcdf.inc"
#include "pltncar.h"
#include "pltio.h"
#include "pltfld.h"
      character*(*) fldnam
      integer np, ncid, ncvarid, tindx, igrid, im,jm
      real f(np), spval
#ifdef TWO_DIMENSIONAL
      real level
#else
      integer km
#endif
      integer dims(nf_max_dims),  nvdims, lendim, n,
     &        vdims(nf_max_dims), nvatts, lenatt, npoints,
     &        start(nf_max_dims), vartyp, lenfld,
     &        count(nf_max_dims), ierr,   lenvar, lenstr
      logical out_of_bounds
      character*10  varnam, dimnam(nf_max_dims)
      character*60  attnam
      integer XI_type,ETA_type,Z_type, short,unknown,long
      parameter (short=-1, unknown=0, long=+1)

!
! Read in requested field.
!===== == ========= ======
! Knowing name of the requested field, inquire about its ID in 
! input NetCDF file, if the matching variable ID is found, make
! general inquiry about this variable, after which sort out
! dimensions.
!
  1   lenfld=lenstr(fldnam)
      if (lenfld.gt.0) then
        ierr=nf_inq_varid (ncid, fldnam(1:lenfld), ncvarid)
        if (ierr.eq.nf_noerr) then
          ierr=nf_inq_var(ncid, ncvarid, varnam, vartyp,
     &                           nvdims,  vdims,  nvatts)
          if (ierr.eq.nf_noerr) then
            out_of_bounds=.false.
            XI_type=unknown
            ETA_type=unknown
            Z_type=unknown

            lenvar=lenstr(varnam)
            do n=1,nvdims
              ierr=nf_inq_dim (ncid,vdims(n),dimnam(n),dims(n))
              if (ierr.eq.nf_noerr) then
                start(n)=1
                count(n)=dims(n)
                lendim=lenstr(dimnam(n))
                if (dimnam(n)(1:lendim).eq.'xi_rho' .or.
     &              dimnam(n)(1:lendim).eq.'lon_rho' .or.
     &              dimnam(n)(1:lendim).eq.'xi_v'    .or.
     &              dimnam(n)(1:lendim).eq.'lon_v') then
                  XI_type=long
                  im=dims(n)
                elseif (dimnam(n)(1:lendim).eq.'xi_u'    .or.
     &                  dimnam(n)(1:lendim).eq.'lon_u'    .or.
     &                  dimnam(n)(1:lendim).eq.'xi_psi'   .or.
     &                  dimnam(n)(1:lendim).eq.'lon_psi') then
                  XI_type=short
                  im=dims(n)
                elseif (dimnam(n)(1:lendim).eq.'eta_rho' .or.
     &                  dimnam(n)(1:lendim).eq.'lat_rho'  .or.
     &                  dimnam(n)(1:lendim).eq.'eta_u'    .or.
     &                  dimnam(n)(1:lendim).eq.'lat_u')  then
                  ETA_type=long
                  jm=dims(n)
                elseif (dimnam(n)(1:lendim).eq.'eta_v'   .or.
     &                  dimnam(n)(1:lendim).eq.'lat_v'    .or.
     &                  dimnam(n)(1:lendim).eq.'eta_psi'  .or.
     &                  dimnam(n)(1:lendim).eq.'lat_psi') then
                  ETA_type=short
                  jm=dims(n)
                elseif (dimnam(n)(1:lendim).eq.'s_rho'  .or.
     &                  dimnam(n)(1:lendim).eq.'level') then
                  Z_type=short
#ifdef TWO_DIMENSIONAL
                  start(n)=int(level)
                  count(n)=1
#else
                  km=dims(n)
#endif
                elseif (dimnam(n)(1:lendim).eq.'s_w') then
                  Z_type=long 
#ifdef TWO_DIMENSIONAL
                  start(n)=int(level)
                  count(n)=1
#else
                  km=dims(n)
#endif
#ifdef TWO_DIMENSIONAL
                elseif (dimnam(n)(1:lendim).eq.'bath') then
                  count(n)=1
#endif
                elseif (lendim.gt.3) then
                  if (dimnam(n)(lendim-3:lendim).eq.'time') then
                    timedepend=.true.
                    if (tindx.gt.0) then
                      start(n)=tindx
                      count(n)=1
                    else
                      out_of_bounds=.true.
                    endif
                  endif
                endif
              else
                write(*,'(/1x,4A/)') 'GET_NC2/3DAT - error while ',
     &                'inquiring dimension ''', dimnam(n),
     &                ''' for variable ''', varnam(1:lenvar), '''.'
                goto 99                                 !--> ERROR
              endif
            enddo
!
! Check, if the requested field has time dimension and it runs out
! of bounds, terminate, if so.
!
            if (out_of_bounds) then
              if (ihist.lt.nhists) then   
                call close_to_reopen (ierr)
                ihist=ihist+1
           write(*,*) 'WARNING: changing ihist in get_nc3dat.F', ihist
!          pause
                call opencdf (history(ihist), reference(ihist), grid)
                goto 1
              else
                call crash ('DONE X',0)
              endif
            endif
!
! Sort out horizontal grid type
!
            if (XI_type.eq.unknown .or. ETA_type.eq.unknown) then
              write(*,'(/,1x,a,1x,a,/)') 'ERROR IN GET_NC3DDAT: ',
     &                      'Cannot identify horizontal grid type'
              ierr=99
              goto 99                                   !--> ERROR
            elseif (XI_type.eq.long .and. ETA_type.eq.long) then
              igrid=1
            elseif (XI_type.eq.short .and. ETA_type.eq.short) then
              igrid=2
            elseif (XI_type.eq.short .and. ETA_type.eq.long) then
              igrid=3
            elseif (XI_type.eq.long .and. ETA_type.eq.short) then
              igrid=4
            endif
            if (Z_type.eq.long) igrid=igrid+4
#ifdef VERBOSE
            write(*,'(6x,3A,2(I2,1x,A),10I4)')    'GET_NC2/3DAT: ''',
     &             fldnam(1:lenfld), ''' igrid =', igrid, 'nvdims =',
     &             nvdims, 'dims =', (dims(n),n=1,nvdims)
            write(*,'(20x,4(1x,A,I4))') 'tindx =', tindx, 'im =', im
     &                                                  , 'jm =', jm
# ifndef TWO_DIMENSIONAL
     &                                                  , 'km =', km
# endif
#endif
!
! Inquire "missing value" or "fill value" for the requested field.
!
            spval=0.
            do n=1,nvatts
              ierr=nf_inq_attname(ncid,ncvarid,n,attnam)
              if (ierr.eq.nf_noerr) then
                lenatt=lenstr(attnam)
                if (attnam(1:lenatt).eq.'_FillValue' .or.
     &              attnam(1:lenatt).eq.'missing_value') then
                  ierr=nf_get_att_real (ncid,ncvarid,
     &                            attnam(1:lenatt),spval)
                  if (ierr.ne.nf_noerr) then
                    write(*,'(/1x,6A/)')  'GET_NC2/3DAT - error ',
     &             'while reading attribute ''', attnam(1:lenatt),
     &               ''' for variable ''', varnam(1:lenvar), '''.'
                    goto 99                             !--> ERROR
                  endif
                endif
              endif
            enddo
!
! Check if the array size allocated is sufficient, then read in
! requested 3D field..
!
#ifdef TWO_DIMENSIONAL
            npoints=im*jm
#else
            npoints=im*jm*km
#endif
            if (npoints.le.np) then
              ierr=nf_get_vara_real(ncid,ncvarid, start,count, f)
              if (ierr .ne. nf_noerr) then
                write(*,'(/1x,3A/8x,2A/8x,A,I3)')
     &           'GET_NC2/3DAT - error while reading variable ''',
     &            fldnam(1:lenfld), '''.', 'Cause of Error; ',
     &            nf_strerror(ierr), 'nvdims =', nvdims
                do n=1,nvdims
                  write(*,'(16x,A,I4,1x,A,I4)') 'start =',start(n),
     &                                          'count =',count(n)  
                enddo
                goto 99                            !--> ERROR
              endif
#ifdef VERBOSE
              write(*,'(6x,4A,I3,3(1x,A,I3))') 'GET_NC2/3DAT: ',
     &               'retrieved ''', fldnam(1:lenfld),
     &               ''' tindx =', tindx, 'im =', im, 'jm =', jm
# ifndef TWO_DIMENSIONAL
     &                                              , 'km =', km
# endif
#endif
              return     !---> NORMAL RETURN
            else
              write(*,'(/1x,2A,I10/12x,A,I10/12x,2A,I10)') 'Error ',
     &           'in GET_NC3DAT: required array size = ',   npoints,
     &           'is larger than that allocated = ', np,  'Change ',
     &           'parameter NH or NV in ''param.h'' and recompile.'
            endif
          else
            write(*,'(/1x,4A/)')       'Error in GET_NC3DAT while ',
     &        'inquiring about variable ''', fldnam(1:lenfld), '''.'
          endif
        else
          write(*,'(/1x,4A/)')  'Error in GET_NC3DAT: Cannot find ',
     &          'netCDF ID for variable ''', fldnam(1:lenfld), '''.'
        endif
      else
        write(*,'(/1x,2A/)') 'GET_NC3DAT error: attempt to find ',
     &                             'variable with zero-size name.'
      endif

  99  continue
#ifdef TWO_DIMENSIONAL
      call crash ('GET_NC2DAT', ierr)
#else
      call crash ('GET_NC3DAT', ierr)
#endif
      end
