      subroutine get_nc2pos (xpos,ypos, np, im,jm, ncid,igrid)
!
! Reads in the 2D horizontal positions for the current field.
!
! input: np    allocated size for arrays "xpos" and "ypos" (integer).
!        im,jm inner/outer dimensions for points to read (integer).
!        ncid  netCDF ID for input file (integer).
!        igrid staggered C grid type (integer):
!              igrid=0  => None.
!                    1  => density points.
!                    2  => streamfunction points.
!                    3  => u-velocity points.
!                    4  => v-velocity points.
!                    5  => w-velocity points.
!                    6  => w-velocity points, range 0:N.
!                    7  => interior density points.
!
! output: xpos X-positions of current field (km or degrees).
!         ypos Y-positions of current field (km or degrees).
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer np, im,jm, ncid,igrid
      real xpos(np), ypos(np)

      logical average, derive, gotlat, gotlon, gotplat, gotplon,
     &        gotpx, gotpy, gotrlat, gotrlon, gotrx, gotry, gotulat,
     &        gotulon, gotux, gotuy, gotvlat, gotvlon, gotvx, gotvy
      integer ggrid, ixy, jxy, lvar, n, ndims, ngatts, nvars, nvatts,
     &        nvdims, recdim, ierr, varid, vartyp, xposid, yposid,
     &        vdims(10), lenstr
      real xyspv
      character*60  varnam, xposnam, yposnam

#include "param.h"
#include "pconst.h"
#include "fields.h"
#include "netcdf.inc"
#include "pltfld.h"
#include "pltio.h"

      derive=.false.      ! Inquire about position
      average=.false.     ! variables: first reset 
      gotlon=.false.      ! everything
      gotlat=.false.
      gotrlon=.false.
      gotrlat=.false.
      gotplon=.false.
      gotplat=.false.
      gotulon=.false.
      gotulat=.false.
      gotvlon=.false.
      gotvlat=.false.
      gotrx=.false.
      gotry=.false.
      gotpx=.false.
      gotpy=.false.
      gotux=.false.
      gotuy=.false.
      gotvx=.false.
      gotvy=.false.

      ierr=nf_inq(ncid,ndims,nvars,ngatts,recdim)
      if (ierr.eq.nf_noerr) then
        do varid=1,nvars
          ierr=nf_inq_var(ncid,varid,varnam,vartyp,nvdims,vdims,
     &                                                   nvatts)
          if (ierr.eq.nf_noerr) then
            lvar=lenstr(varnam)
            if (varnam(1:lvar).eq.'lon') then
              gotlon=.true.
            elseif (varnam(1:lvar).eq.'lat') then
              gotlat=.true.
            elseif (varnam(1:lvar).eq.'lon_rho') then
              gotrlon=.true.
            elseif (varnam(1:lvar).eq.'lat_rho') then
              gotrlat=.true.
            elseif (varnam(1:lvar).eq.'lon_psi') then
              gotplon=.true.
            elseif (varnam(1:lvar).eq.'lat_psi') then
              gotplat=.true.
            elseif (varnam(1:lvar).eq.'lon_u') then
              gotulon=.true.
            elseif (varnam(1:lvar).eq.'lat_u') then
              gotulat=.true.
            elseif (varnam(1:lvar).eq.'lon_v') then
              gotvlon=.true.
            elseif (varnam(1:lvar).eq.'lat_v') then
              gotvlat=.true.
            elseif (varnam(1:lvar).eq.'x_rho') then
              gotrx=.true.
            elseif (varnam(1:lvar).eq.'y_rho') then
              gotry=.true.
            elseif (varnam(1:lvar).eq.'x_psi') then
              gotpx=.true.
            elseif (varnam(1:lvar).eq.'y_psi') then
              gotpy=.true.
            elseif (varnam(1:lvar).eq.'x_u') then
              gotux=.true.
            elseif (varnam(1:lvar).eq.'y_u') then
              gotuy=.true.
            elseif (varnam(1:lvar).eq.'x_v') then
              gotvx=.true.
            elseif (varnam(1:lvar).eq.'y_v') then
              gotvy=.true.
            endif
          else
            write(stdout,'(/1x,2A/1x,A,I3,2x,A,I3/)') 'ERROR in ',
     &             'get_nc2pos -- cannot inquire information for',
     &       'variable ID =', varid, 'in input NetCDF ID =', ncid
            stop
          endif
        enddo
      else
        write(stdout,'(/1x,2A,I3/)') 'ERROR in get_nc2pos - cannot ',
     &           'inquire about contents of input netCDF ID =', ncid
        stop
      endif                                 !
                                            ! Read in spherical grid:
      if (spherical) then                   ! ==== == ========= =====
        if (gotlon) then                    !
          xposnam='lon'                                 ! Read in
        elseif (gotplon .and. igrid.eq.2) then          ! longitude
          xposnam='lon_psi'                             ! and
        elseif (gotulon .and. igrid.eq.3) then          ! latitude at
          xposnam='lon_u'                               ! RHO-points
        elseif (gotvlon .and. igrid.eq.4) then
          xposnam='lon_v'
        else
          xposnam='lon_rho'
          average=.true.
        endif
        if (gotlat) then
          yposnam='lat'
        elseif (gotplat .and. igrid.eq.2) then
          yposnam='lat_psi'
        elseif (gotulat .and. igrid.eq.3) then
          yposnam='lat_u'
        elseif (gotvlat .and. igrid.eq.4) then
          yposnam='lat_v'
        else
          yposnam='lat_rho'
          average=.true.
        endif
        call get_nc2dat (f5,NV,ixy,jxy,ncid,0,xposnam,0.,ggrid,
     &                                           xposid,xyspv)
        call get_nc2dat (f6,NV,ixy,jxy,ncid,0,yposnam,0.,ggrid,
     &                                           yposid,xyspv)
!
! If applicable, calculate spherical grid at the requested positions.
!
        if (average) then
          call get_nc2dat (f5,NV,ixy,jxy,ncid,0,xposnam,0.,ggrid,
     &                                              xposid,xyspv)
          call get_nc2dat (f6,NV,ixy,jxy,ncid,0,yposnam,0.,ggrid,
     &                                              yposid,xyspv)
          call cgrid (xpos,ypos,im,jm,f5,f6,ixy,jxy,igrid,derive)
        else
          call get_nc2dat (xpos,NV,ixy,jxy,ncid,0,xposnam,0.,ggrid,
     &                                               xposid,xyspv)
          call get_nc2dat (ypos,NV,ixy,jxy,ncid,0,yposnam,0.,ggrid,
     &                                               yposid,xyspv)
        endif                               !
      else                                  ! Read in Cartesian grid:
        if (gotpx .and. igrid.eq.2) then    ! ==== == ========= =====
          xposnam='x_psi'                   !
        elseif (gotux .and. igrid.eq.3) then     ! Read in 
          xposnam='x_u'                          ! curvilinear
        elseif (gotvx .and. igrid.eq.4) then     ! metrics
          xposnam='x_v'
        elseif (gotrx) then
          xposnam='x_rho'
          average=.true.
        else
          xposnam='pm'
          derive=.true.
          average=.true.
        endif
        if (gotpy .and. igrid.eq.2) then
          yposnam='y_psi'
        elseif (gotuy .and. igrid.eq.3) then
          yposnam='y_u'
        elseif (gotvy .and. igrid.eq.4) then
          yposnam='y_v'
        elseif (gotry) then
          yposnam='y_rho'
          average=.true.
        else
          yposnam='pn'
          derive=.true.
          average=.true.                  ! Compute positions at
        endif                             ! requested grid from
                                          ! curvilinear metrics
        if (average) then
          call get_nc2dat (f5,NV,ixy,jxy,ncid,0,xposnam,0.,ggrid,
     &                                             xposid, xyspv)
          call get_nc2dat (f6,NV,ixy,jxy,ncid,0,yposnam,0.,ggrid,
     &                                             yposid, xyspv)
          call cgrid (xpos,ypos,im,jm,f5,f6,ixy,jxy,igrid,derive)
        else
          call get_nc2dat (xpos,NV,ixy,jxy,ncid,0,xposnam,0.,ggrid,
     &                                               xposid,xyspv)
          call get_nc2dat (ypos,NV,ixy,jxy,ncid,0,yposnam,0.,ggrid,
     &                                               yposid,xyspv)
        endif

        do n=1,im*jm             ! convert Cartesian
          xpos(n)=xpos(n)*m2km   ! grid to kilometers
          ypos(n)=ypos(n)*m2km
        enddo
      endif
      return
      end
