      subroutine get_nc1dat (f,np,lm,ncid,tindx,fldnam,ncvarid,spv)
!
! Read requested 1D field from input NetCDF file.
!
! Input:  np       Allocated size for array "f".
!         ncid     NetCDF ID for input file (integer).
!         tindx    Time dimension index to read (integer).
!         fldnam   Name of field to read (character).
!
! Output: f        Requested 1D field (real array).
!         lm       Size of dimension (integer).
!         ncvarid  Variable ID in input NetCDF file (integer).
!         spv      Missing data/fill data value (real).
!
      implicit none
#include "netcdf.inc"
      integer np, lm,     n,      lenfld, nvatts, start(nf_max_dims),
     &        ncid,       ierr,   lendim, nvdims, count(nf_max_dims), 
     &        tindx,      lstr,   lenvar, vartype, dims(nf_max_dims),
     &        ncvarid,    lenstr, lenatt,         vdims(nf_max_dims)
      real f(np), spv
      character*(*) fldnam
      character*10                       varnam, dimnam(nf_max_dims)
      character*60  attnam

      lm=0
      lenfld=lenstr(fldnam)
      if (lenfld.gt.0) then
!
! RETRIEVE REQUESTED VARIABLE WRITTEN AS GLOBAL ATTRIBUTE: Inquire
! about existence of global attribute with this name, its type and
! length. If found, check for its size and then read it. Assign
! variable ID to zero, to indicate that it is not a variable.
!
        ierr=nf_inq_att(ncid, nf_global, fldnam(1:lenfld),vartype,lm)
        if (ierr.eq.nf_noerr) then
          if (lm.le.np) then
            ierr=nf_get_att_real (ncid,nf_global, fldnam(1:lenfld),f)
            if (ierr.eq.nf_noerr) then
              ncvarid=0
#ifdef VERBOSE
              write(*,'(6x,3A)') 'GET_NC1DAT -- retrieved ''',
     &             fldnam(1:lenfld), ''' as global attribute.'
#endif
              return
            else
              write(*,'(/1x,4A/)')        'GET_NC1DAT ERROR: while ',
     &         'reading global attribute ''', fldnam(1:lenfld), '''.'
            endif
          else
            write(*,'(/2x,2A,I8/15x,2A,I8/2x,2A/)')    'GET_NC1DAT ',
     &        'ERROR: required array size = ', lm, 'is larger than ',
     &        'allocated = ', np, 'Change parameter ''NH'' in file ',
     &                                  '''param.h'' and recompile.'
          endif
!
! READ REQUESTED VARIABLE (written as netCDF variable). To do so, 
! first, knowing its name, inquire ID of requested variable, then
! make general inquiry, sort out its dimensions, retrieve "missing
! value" or "fill value", if they are available (do not exit, if
! they are not.) Check, if supplied array size is sufficient, then,
! finally, read the requested variable. 
!
        else
          ierr=nf_inq_varid (ncid, fldnam(1:lenfld), ncvarid)
          if (ierr.eq.nf_noerr) then
            ierr=nf_inq_var (ncid, ncvarid, varnam, vartype,
     &                            nvdims,  vdims,  nvatts)
            if (ierr.eq.nf_noerr) then
              lenvar=lenstr(varnam)
              n=0
              do while (n.lt.nvdims .and. ierr.eq.nf_noerr)
                n=n+1
                ierr=nf_inq_dim (ncid, vdims(n), dimnam(n), dims(n))
                if (ierr.eq.nf_noerr) then
                  lendim=lenstr(dimnam(n))
                  if (dimnam(n)(1:lendim).eq.'time') then
                    start(n)=tindx
                    count(n)=1               ! sort out dimensions.
                  else
                    start(n)=1
                    count(n)=dims(n)
                    lm=dims(n)
                  endif                     ! inquire "missing value"
                endif                       ! or "fill value" for the
              enddo                         ! requested variable 
              if (ierr.eq.nf_noerr) then
                n=0
                do while (n.lt.nvatts .and. ierr.eq.nf_noerr)
                  n=n+1 
                  ierr=nf_inq_attname(ncid, ncvarid, n, attnam)
                  if (ierr.eq.nf_noerr) then
                    lenatt=lenstr(attnam)
                    if (attnam(1:lenatt).eq.'missing_value' .or.
     &                  attnam(1:lenatt).eq.'_FillValue')   then
                      ierr=nf_get_att_real (ncid, ncvarid,
     &                                    attnam(1:lenatt),spv)
                    endif
                  endif                      ! Check if the size of
                enddo                        ! allocated array is 
                if (ierr.eq.nf_noerr) then   ! sufficient, and read.
                  if (lm.le.np) then
                    ierr=nf_get_vara_real(ncid,ncvarid,start,count,f)
                    if (ierr.eq.nf_noerr) then
#ifdef VERBOSE
                      write(*,'(6x,3A)') 'GET_NC1DAT - retrieved ''',
     &                          fldnam(1:lenfld), ''' as a variable.'
#endif
                      return
                    else
                      write(*,'(/1x,4A/)') 'GET_NC1DAT ERROR: while',
     &                ' reading variable ''', fldnam(1:lenfld), '''.'
                    endif
                  else
                    write(*,'(/2x,A,I6/15x,A,I6/15x,A/)')
     &                'GET_NC1DAT ERROR: required array size = ', lm,
     &                        'is larger than that allocated = ', np,
     &                         'Change parameter NH and recompile.'
                  endif
                else
                  write(*,'(/2x,4A/16x,3A/)')   'GET_NC1DAT ERROR: ',
     &               'while reading attribute ''',  attnam(1:lenatt),
     &               '''', 'for variable ''', varnam(1:lenvar), '''.'
                endif
              else
                lstr=lenstr(dimnam(n))
                write(*,'(/2x,4A/16x,3A/)')     'GET_NC1DAT ERROR: ',
     &             'while inquiring dimension ''', dimnam(n)(1:lstr),
     &             '''',  'for variable ''',  varnam(1:lenvar), '''.'
              endif
            else
              write(*,'(/1x,4A/)')        'GET_NC1DAT ERROR: while ',
     &                       'inquiring information for variable ''',
     &                                       fldnam(1:lenfld) , '''.'
            endif
          else
            write(*,'(/1x,4A/)') 'GET_NC1DAT ERROR: Cannot find ID ',
     &                     'for variable ''', fldnam(1:lenfld), '''.'
          endif
        endif
        if (ierr.ne.nf_noerr) write(*,'(8x,2A/)') 'Cause of error: ',
     &                                             nf_strerror(ierr)
      else
        write(*,'(/1x,2A/)') 'GET_NC1DAT ERROR: Zero string is ',
     &                        'given instead of valid variable name.'
      endif
      stop
      end
