      subroutine get_jebar (ujbar,vjbar,xpos,ypos,zpos,im,jm,igrid,
     &                      ncgid,ncfid,idfld,tindex,gotzeta,gotsalt,
     &                      gotrho,gotangle,file)
c
c=======================================================================
c  Copyright (c) 1996 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This subroutine computes the Joint Effect of Baroclinicity and    ===
c  bottom Relief (JEBAR). It uses either model or raw bathymetry.    ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     ncfid    NetCDF ID for input fields (integer).                 ===
c     idfld    Identification of field to read (integer).            ===
c     tindex   Time dimension index to read (integer).               ===
c     gotzeta  Logical switch indicating availability of free-       ===
c              surface.                                              ===
c     gotsalt  Logical switch indicating availability of salinity.   ===
c     gotrho   Logical switch indicating availability of density.    ===
c     gotangle Logical switch indicating availability of grid        ===
c              rotation angle.                                       ===
c     file     NetCDF file to read (primary or secondary; integer).  ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     ujbar    JEBAR component in the XI-direction (real array).     ===
c     vjbar    JEBAR component in the ETA-direction (real array).    ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     igrid    grid type (integer).                                  ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c     ypos     Z-positions of the requested field (real array).      ===
c                                                                    ===
      implicit none
#include "param.h"
#include "domdat.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltlab.h"
#include "pltncar.h"
#include "secbath.h"
      logical gotangle, gotrho, gotsalt, gotzeta
      integer file, i, idfld, igrid, im, imr, ip, irgrid, iwgrid, j,
     &        jm, jmr, k, kmr, kpr, kr, ncfid, ncgid, nc_hid, nc_pid,
     &        nc_rid, nc_sid, nc_tid, tindex
      real g, gorho0, hspv, rspv, spv, sspv, tspv
      real idens
      real ujbar(NV), vjbar(NV), xpos(NV), ypos(NV), zpos(NV)
      character*20 fldnam
      parameter (g=9.808)

      levless=is2d(idfld)
      fldnam1=vname1(idfld)
      fldnam2=vname2(idfld)
c
c  Read in Coordinate transformation metrics.
c
      fldnam='pm'
      call get_nc2dat (x,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,spv)
      fldnam='pn'
      call get_nc2dat (y,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,spv)
c 
c  Get density anomaly (kg/m^3).
c
      if (gotrho) then
        call get_nc3dat (f2,NV,imr,jmr,kmr,ncfid,tindex,fldnam1,irgrid,
     &                   nc_rid,rspv)
      elseif (gotsalt) then
        fldnam='temp'
        call get_nc3dat (f3,NV,imr,jmr,kmr,ncfid,tindex,fldnam,irgrid,
     &                   nc_tid,tspv)
        fldnam='salt'
        call get_nc3dat (f4,NV,imr,jmr,kmr,ncfid,tindex,fldnam,irgrid,
     &                   nc_sid,sspv)
        irgrid=1
        call get_nc3pos (zpos,NV,imr,jmr,Nr,ncgid,ncfid,tindex,irgrid,
     &                   irgrid,gotzeta,file)
        ip=0
        do k=1,kmr
          do j=1,jmr
            do i=1,imr
              ip=ip+1
              f2(ip)=idens(f3(ip),f4(ip),zpos(ip))
            enddo
          enddo
        enddo
      else
        print 10
  10    format(/,' GET_JEBAR - unable to get/compute density anomaly.')
        return
      endif
c
c  Get depths (m) at RHO- and W-points.
c
      if (gotrho) then
        irgrid=1
        call get_nc3pos (zpos,NV,imr,jmr,Nr,ncgid,ncfid,tindex,irgrid,
     &                   irgrid,gotzeta,file)
      endif
      iwgrid=6
      call get_nc3pos (f3,NV,imr,jmr,Nw,ncgid,ncfid,tindex,irgrid,
     &                 iwgrid,gotzeta,file)
c
c  Read in bathymetry (m).
c
      call get_nc2dat (bath,NH,imr,jmr,ncgid,tindex,fldnam2,0,irgrid,
     &                 nc_hid,hspv)
c
c-----------------------------------------------------------------------
c  Compute dynamic pressure (m/s^2).  Integrate hydrostatic equation
c  vertically.  Surface density is assumed to be that of level "Nr".
c-----------------------------------------------------------------------
c
      gorho0=g/rho0
      do j=1,jmr
        do i=1,imr
          ip=i+(j-1)*imr
          kr=ip+(kmr-1)*imr*jmr
          kpr=ip+kmr*imr*jmr
          f4(kr)=gorho0*(f3(kpr)-zpos(kr))*f2(kr)
        enddo
      enddo
c          
      do k=kmr-1,1,-1
        do j=1,jmr
          do i=1,imr
            ip=i+(j-1)*imr
            kr=ip+(k-1)*imr*jmr
            kpr=ip+k*imr*jmr
            f4(kr)=f4(kpr)+g*((zpos(kpr)-f3(kr))*f2(kpr)+
     &                        (f3(kr)-zpos(kr))*f2(kr))
          enddo
        enddo
      enddo
c
c-----------------------------------------------------------------------
c  Compute JEBAR (m/s^2) at PSI-points.
c-----------------------------------------------------------------------
c
c  Notice that work array "f4" is re-shaped in the subroutine call to
c  a 2D array and only the bottom dynamic pressure is used.
c
      call jebar (f5,f6,imr-1,jmr-1,f4,bath,x,y)
c
c  Interpolate vectors to requested grid.
c
      if ((vcode(idfld).eq.'IDRHJV').or.
     &    (vcode(idfld).eq.'IDRHJM').or.
     &    (vcode(idfld).eq.'IDMHJV').or.
     &    (vcode(idfld).eq.'IDMHJM')) then
        if (lvecrho) then
          igrid=7
        else
          igrid=2
        endif
        call cvector (ujbar,vjbar,im,jm,1,f5,imr-1,jmr,f6,imr,jmr-1,
     &                igrid,ncgid,gotangle)
        if ((vcode(idfld).eq.'IDRHJM').or.
     &      (vcode(idfld).eq.'IDMHJM')) then
          do ip=1,im*jm
            ujbar(ip)=sqrt(ujbar(ip)*ujbar(ip)+vjbar(ip)*vjbar(ip))
          enddo
        endif
      elseif ((vcode(idfld).eq.'IDRHUJ').or.
     &        (vcode(idfld).eq.'IDMHUJ')) then
        im=imr-1
        jm=jmr
        igrid=3
        do j=1,jm
          do i=1,im
            ip=i+(j-1)*im
            ujbar(ip)=f5(ip)
          enddo
        enddo
      elseif ((vcode(idfld).eq.'IDRHVJ').or.
     &        (vcode(idfld).eq.'IDMHVJ')) then
        im=imr
        jm=jmr-1
        igrid=4
        do j=1,jm
          do i=1,im
            ip=i+(j-1)*im
            ujbar(ip)=f5(ip)
          enddo
        enddo
      endif
c
c  Get horizontal positions (Lp,Mp) at RHO-points
c
      call get_nc2pos (xpos,ypos,NV,im,jm,ncgid,igrid)
      return
      end
