      subroutine get_isosur (Diso,xpos,ypos,im,jm,igrid,ncgid,ncfid,
     &                       idfld,tindex,gotzeta,gotsalt,gotrho,file)
c
c=======================================================================
c  Copyright (c) 1998 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This subroutine computes depths of requested field isosurface.    ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     ncfid    NetCDF ID for input fields (integer).                 ===
c     idfld    Identification of field to read (integer).            ===
c     tindex   Time dimension index to read (integer).               ===
c     gotzeta  Logical switch indicating availability of free-       ===
c              surface.                                              ===
c     gotsalt  Logical switch indicating availability of salinity.   ===
c     gotrho   Logical switch indicating availability of density.    ===
c     file     NetCDF file to read (primary or secondary; integer).  ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     Diso     Isosurface depths (real array).                       ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     igrid    Staggered C-grid type for requested field (integer).  ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c                                                                    ===
      implicit none
#include "param.h"
#include "pconst.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltncar.h"
      logical gotrho, gotsalt, gotzeta
      integer file, idfld, igrid, im, ip, jm, km, ncfid, ncgid, nc_rid, 
     &        nc_sid, nc_tid, pref, tindex
      real rspv, sspv, tspv
      real Diso(NV), xpos(NV), ypos(NV)
      real idens, pdens

      isosurf=.true.
      levless=is2d(idfld)
      fldnam1=vname1(idfld)
      fldnam2=vname2(idfld)
c
c  Get depths at RHO-points.
c
      igrid=1
      call get_nc3pos (z,NV,Lr,Mr,Nr,ncgid,ncfid,tindex,igrid,igrid,
     &                 gotzeta,file)
c
c  Get field to process.
c
      if (vcode(idfld).eq.'IDISOT' .or.
     &    vcode(idfld).eq.'IDISOH') then
        call get_nc3dat (f2,NV,im,jm,km,ncfid,tindex,fldnam1,igrid,
     &                   nc_tid,rspv)
      elseif (vcode(idfld).eq.'IDISOR') then
        if (gotrho) then
          call get_nc3dat (f2,NV,im,jm,km,ncfid,tindex,fldnam1,igrid,
     &                     nc_rid,rspv)
        else
          fldnam1='temp'
          fldnam2='salt'
          call get_nc3dat (f3,NV,im,jm,km,ncfid,tindex,fldnam1,igrid,
     &                     nc_tid,tspv)
          call get_nc3dat (f4,NV,im,jm,km,ncfid,tindex,fldnam2,igrid,
     &                     nc_sid,sspv)
          do ip=1,im*jm*km
            f2(ip)=idens(f3(ip),f4(ip),z(ip))
          enddo
        endif
      elseif (vcode(idfld).eq.'IDISOD' .or.
     &        vcode(idfld).eq.'IDISOS') then
        if (vcode(idfld).eq.'IDISOD') then
          pref=0.
        elseif (vcode(idfld).eq.'IDISOS') then
          pref=-abs(zref)
        endif
        call get_nc3dat (f3,NV,im,jm,km,ncfid,tindex,fldnam1,igrid,
     &                   nc_tid,tspv)
        call get_nc3dat (f4,NV,im,jm,km,ncfid,tindex,fldnam2,igrid,
     &                   nc_sid,sspv)
        do ip=1,im*jm*km
          f2(ip)=pdens(f3(ip),f4(ip),pref)
        enddo
      endif
c
c  Compute the depths of requested field isosurface via interpolation.
c
      call depth_iso (Diso,isoval,f2,z,im,jm,km,spval1)
c
c  Get horizontal positions (Lp,Mp) at RHO-points
c
      igrid=1
      call get_nc2pos (xpos,ypos,NV,im,jm,ncgid,igrid)
      return
      end
