      subroutine get_hslope (h, xpos,ypos,im,jm, igrid,ncgid,
     &                          ncfid, idfld, tindex, gotzeta)
c
c  This subroutine computes either the bathymetry slope or the       ===
c  bathymetry r-factor.                                              ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     ncfid    NetCDF ID for input fields (integer).                 ===
c     idfld    Identification of field to read (integer)             ===
c     tindex   Time dimension index to read (integer).               ===
c     gotzeta  Logical switch indicating availability of free-       ===
c              surface.                                              ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     h        bathymetry slope or r-factor (real array).            ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     igrid    Staggered C-grid type for requested field (integer).  ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c                                                                    ===
!
! Copyright (c) 1997 Rutgers University
!
      implicit none
#include "param.h"
c-#include "pconst.h"
#include "fields.h"
#include "fldsid.h"

      logical gotzeta
      integer i, idfld, igrid, ij, im, imr, ip, irgrid, j, jm, jmr,
     &        ncfid, ncgid, nc_hid, nc_pid, tindex
      real Se, Sx, spv
      real h(NV), xpos(NV), ypos(NV)
      character*20 fldnam
c
c  Read bathymetry.
c
      fldnam=vname1(idfld)
      call get_nc2dat (f2,NV,imr,jmr,ncfid,tindex,fldnam,0,irgrid,
     &                 nc_hid,spv)
c
c  Compute r-factor at PSI-points.
c
      if (vcode(idfld).eq.'IDMHRF'  .or.
     &    vcode(idfld).eq.'IDRHRF') then
        do j=1,jmr
          do i=1,imr-1
            ij=i+(j-1)*imr
            f3(ij)=abs(f2(ij+1)-f2(ij))/(f2(ij)+f2(ij+1))
          enddo
        enddo
        do j=1,jmr-1
          do i=1,imr
            ij=i+(j-1)*imr
            f4(ij)=abs(f2(ij+imr)-f2(ij))/(f2(ij)+f2(ij+imr))
          enddo
        enddo
        ip=0
        do j=1,jmr-1
          do i=1,imr-1
            ip=ip+1
            ij=i+(j-1)*imr
            Sx=0.5*(f3(ij)+f3(ij+imr))
            Se=0.5*(f4(ij)+f4(ij+1))
            h(ip)=max(Sx,Se)
          enddo
        enddo
      endif
c
c  Compute bathymetry slope at PSI-points.
c
      if (vcode(idfld).eq.'IDMHSL' .or.
     &    vcode(idfld).eq.'IDRHSL') then
c
c  Read in Coordinate transformation metrics.
c
        fldnam='pm'
        call get_nc2dat (x,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,
     &                   spv)
        fldnam='pn'
        call get_nc2dat (y,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,
     &                   spv)
c
c  Compute gradients.
c
        do j=1,jmr
          do i=1,imr-1
            ij=i+(j-1)*imr
            f3(ij)=0.5*(x(ij)+x(ij+1))*(f2(ij+1)-f2(ij))
          enddo
        enddo
        do j=1,jmr-1
          do i=1,imr
            ij=i+(j-1)*imr
            f4(ij)=0.5*(y(ij)+y(ij+imr))*(f2(ij+imr)-f2(ij))
          enddo
        enddo
        ip=0
        do j=1,jmr-1
          do i=1,imr-1
            ip=ip+1
            ij=i+(j-1)*imr
            Sx=0.5*(f3(ij)+f3(ij+imr))
            Se=0.5*(f4(ij)+f4(ij+1))
            h(ip)=sqrt(Sx*Sx+Se*Se)
          enddo
        enddo
      endif
c
c  Compute horizontal positions at PSI-points.
c
      im=imr-1
      jm=jmr-1
      igrid=2
      call get_nc2pos (xpos,ypos,NV,im,jm,ncgid,igrid)
      return
      end
