      subroutine get_hdiv (hdiv,xpos,ypos,zpos,im,jm,km,igrid,ncgid,
     &                     ncfid,idfld,tindex,level,gotzeta,file)
c
c=======================================================================
c  Copyright (c) 1997 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This subroutine computes horizontal divergence from primary       ===
c  fields in input NetCDF file.                                      ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     ncfid    NetCDF ID for input fields (integer).                 ===
c     idfld    Identification of field to read (integer)             ===
c     tindex   Time dimension index to read (integer).               ===
c     level    Depth (>0), level (>0), or isopycnal (>1000) to       ===
c              process (real). If LEVEL=0, the full 3D is passed.    ===
c     gotzeta  Logical switch indicating availability of free-       ===
c              surface.                                              ===
c     file     NetCDF file to read (primary or secondary; integer).  ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     hdiv     Requested horizontal divergence (real array).         ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     km       Size of vertical dimension (integer).                 ===
c     igrid    Staggered C-grid type for requested field (integer).  ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c     zpos     Z-positions of the requested field (real array).      ===
c                                                                    ===
      implicit none
#include "param.h"
#include "pconst.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltlab.h"
#include "secbath.h"
      logical gotzeta
      integer file, i, idfld, igrid, ih, ihgrid, im, imr, imu, imv, ip,
     &        ir, irgrid, iugrid, iv, ivgrid, ivp, iwgrid, j, jm, jmr,
     &        jmu, jmv, k, km, kmr, ncfid, nchid, ncgid, nczid, nc_pid,
     &        nc_uid, nc_vid, np, tindex
      real level, hspv, ods, spv, uspv, vspv, zspv
      real hdiv(NV), xpos(NV), ypos(NV), zpos(NV)
      character*20 fldnam, hposnam, zposnam
c
c  Determine vector field to process.
c
      levless=is2d(idfld)
      fldnam1=vname1(idfld)
      fldnam2=vname2(idfld)
c
c  Read in U-component and store in f2.
c
      if (levless) then
        call get_nc2dat (f2,NV,imu,jmu,ncfid,tindex,fldnam1,0,iugrid,
     &                   nc_uid,uspv)
      else
        call get_nc3dat (f2,NV,imu,jmu,kmr,ncfid,tindex,fldnam1,iugrid,
     &                   nc_uid,uspv)
      endif
      if (vcode(idfld).eq.'IDCVHD') then
        fldnam='ubar'
        call get_nc2dat (f4,NV,imu,jmu,ncfid,tindex,fldnam,0,iugrid,
     &                   nc_uid,uspv)
        do k=1,kmr
          do j=1,jmu
            do i=1,imu
              ih=i+(j-1)*imu
              iv=ih+(k-1)*imu*jmu
              f2(iv)=f2(iv)-f4(ih)
            enddo
          enddo
        enddo
      endif
c
c  If appropriate, interpolate U-component to requested depth or depths
c  of isopycnal.
c
      if (.not.levless .and. level.le.0. .or. level.ge.1000.) then
        irgrid=1
        call get_nc3pos(zpos,NV,imu,jmu,kmr,ncgid,ncfid,tindex,iugrid,
     &                  irgrid,gotzeta,file)
        if (level.ge.1000.) then
          call cfield (depth,imu,jmu,1,ziso,Lr,Mr,1,iugrid)
        endif
        np=imu*jmu*kmr
        do iv=1,np
          f5(iv)=f2(iv)
        enddo
        call xhslice (f2,depth,zpos,f5,imu,jmu,kmr,vintrp,spval1)
        interpolate=.false.
      endif
c
c  Read in V-component and store in f3.
c
      if (levless) then
        call get_nc2dat (f3,NV,imv,jmv,ncfid,tindex,fldnam2,0,ivgrid,
     &                   nc_vid,vspv)
      else
        call get_nc3dat (f3,NV,imv,jmv,kmr,ncfid,tindex,fldnam2,ivgrid,
     &                   nc_vid,vspv)
      endif
      if (vcode(idfld).eq.'IDCVHD') then
        fldnam='vbar'
        call get_nc2dat (f4,NV,imv,jmv,ncfid,tindex,fldnam,0,ivgrid,
     &                   nc_vid,vspv)
        do k=1,kmr
          do j=1,jmv
            do i=1,imv
              ih=i+(j-1)*imv
              iv=ih+(k-1)*imv*jmv
              f3(iv)=f3(iv)-f4(ih)
            enddo
          enddo
        enddo
      endif
c
c  If appropriate, interpolate V-component to requested depth or depths
c  of isopycnal.
c
      if (.not.levless .and. level.le.0. .or. level.ge.1000.) then
        irgrid=1
        call get_nc3pos(zpos,NV,imv,jmv,kmr,ncgid,ncfid,tindex,ivgrid,
     &                  irgrid,gotzeta,file)
        if (level.ge.1000.) then
          call cfield (depth,imv,jmv,1,ziso,Lr,Mr,1,ivgrid)
        endif
        np=imv*jmv*kmr
        do iv=1,np
          f5(iv)=f3(iv)
        enddo
        call xhslice (f3,depth,zpos,f5,imv,jmv,kmr,vintrp,spval1)
        interpolate=.false.
      endif
c
c  Read in Coordinate transformation metrics.
c
      fldnam='pm'
      call get_nc2dat (x,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,spv)
      fldnam='pn'
      call get_nc2dat (y,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,spv)
c
c  If barotropic fields, compute total depth.
c
      if ((vcode(idfld).eq.'IDBVHD').or.
     &    (vcode(idfld).eq.'IDSWHD')) then
        if (gotzeta) then
          ihgrid=1
          zposnam='zeta'
          call get_nc2dat (f4,NV,imr,jmr,ncfid,tindx,zposnam,0,ihgrid,
     &                     nczid,zspv)
        else
          np=imr*jmr
          do ih=1,np
            f4(ih)=0.
          enddo
        endif   
        ihgrid=1
        hposnam='h'
        call get_nc2dat (bath,NH,imr,jmr,ncgid,tindx,hposnam,0,ihgrid,
     &                   nchid,hspv)
        np=imr*jmr
        do ih=1,np
          f4(ih)=f4(ih)+bath(ih)
        enddo
      else
c
c  If baroclinic fields, compute vertical thicknesses, Hz.
c
        if (level.ge.0. .and. level.lt.1000.) then
          ihgrid=1
          iwgrid=6
          call get_nc3pos (zpos,NV,imr,jmr,Nw,ncgid,ncfid,tindex,ihgrid,
     &                     iwgrid,gotzeta,file)
          ods=1./float(Nr)
          do k=1,Nr
            do j=1,jmr
              do i=1,imr
                ih=i+(j-1)*imr
                iv=ih+(k-1)*imr*jmr
                ivp=ih+(k)*imr*jmr
                f4(iv)=(zpos(ivp)-zpos(iv))*ods
              enddo
            enddo
          enddo
c
c  If interpolating to requested depths, set thickness to unity (1 m).
c
        else
          np=imr*jmr
          do ih=1,np
            f4(ih)=1.
          enddo
        endif
      endif
c
c-----------------------------------------------------------------------
c  Compute horizontal divergence (m/s) in flux form at RHO-points.
c-----------------------------------------------------------------------
c
      im=imr-2
      jm=jmr-2
      if (levless .or. level.le.0. .or. level.ge.1000.) then
        km=1
      else
        km=kmr
      endif
      call hordiv (hdiv,imr-1,jmr-1,km,f2,f3,f4,x,y,spval1)
c
c  Get horizontal positions at interior RHO-points.
c
      igrid=7
      call get_nc2pos (xpos,ypos,NV,im,jm,ncgid,igrid)
c
c  Get vertical positions at horizontal RHO-points and vertical
c  RHO-points.
c
      if (.not.levless .and. level.le.0. .or. level.ge.1000.) then
        irgrid=1
        call get_nc3pos (zpos,NV,im,jm,km,ncgid,ncfid,tindex,igrid,
     &                   irgrid,gotzeta,file)
      endif
c
c  If appropriate, extract horizontal divergence at the requested level.
c
      if (.not.levless) then
        if ((1.le.int(level)).and.(int(level).le.km)) then
          np=im*jm*km
          do iv=1,np
            f4(iv)=hdiv(iv)
          enddo
          ip=0
          do j=1,jm
            do i=1,im
              ip=ip+1            
              ir=i+(j-1)*im+(int(level)-1)*im*jm
              hdiv(ip)=f4(ir)
            enddo
          enddo
        endif
      endif
      return
      end
