      subroutine get_ertel (pv,xpos,ypos,zpos,im,jm,km,igrid,ncgid,
     &                      ncfid,idfld,tindex,level,gotzeta,file)
c
c=======================================================================
c  Copyright (c) 1996 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This subroutine computes Ertel potential vorticity from primary   ===
c  fields in input NetCDF file.                                      ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     ncfid    NetCDF ID for input fields (integer).                 ===
c     idfld    Identification of field to read (integer).            ===
c     tindex   Time dimension index to read (integer).               ===
c     level    Depth (>0), level (>0), or isopycnal (>1000) to       ===
c              process (real). If LEVEL=0, the full 3D is passed.    ===
c     gotzeta  Logical switch indicating availability of free-       ===
c              surface.                                              ===
c     file     NetCDF file to read (primary or secondary; integer).  ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     pv        Requested 3D Ertel potential vorticity (real array). ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     km       Size of vertical dimension (integer).                 ===
c     igrid    Staggered C-grid type for requested field (integer).  ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c     zpos     Z-positions of the requested field (real array).      ===
c                                                                    ===
      implicit none
#include "param.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "secbath.h"

      logical gotzeta
      integer file, i, idfld, igrid, im, imr, imu, imv, ip, ir, irgrid,
     &        iugrid, ivgrid, iw, iwgrid, j, jm, jmr, jmu, jmv, k, km,
     &        kmr, ncfid, ncgid, nc_fid, nc_pid, nc_rid, nc_uid, nc_vid,
     &        tindex
      real level, rspv, spv, uspv, vspv
      real f(NH), pv(NV), xpos(NV), ypos(NV), zpos(NV)
      character*20 fldnam

      fldnam1=vname1(idfld)
      fldnam2=vname2(idfld)
c
c  Read in Coordinate transformation metrics.
c
      fldnam='pm'
      call get_nc2dat (x,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,spv)
      fldnam='pn'
      call get_nc2dat (y,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,spv)
c
c  Get depths at RHO-points.
c
      irgrid=1
      call get_nc3pos (z,NV,imr,jmr,Nr,ncgid,ncfid,tindex,irgrid,irgrid,
     &                 gotzeta,file)
c
c  Read in total U-velocity component and store in f2.
c
      call get_nc3dat (f2,NV,imu,jmu,kmr,ncfid,tindex,fldnam1,iugrid,
     &                 nc_uid,uspv)
c
c  Read in total V-velocity component and store in f3.
c
      call get_nc3dat (f3,NV,imv,jmv,kmr,ncfid,tindex,fldnam2,ivgrid,
     &                 nc_vid,vspv)
c
c  Read in potential density anomaly and store in f4.
c
      fldnam='rho'
      call get_nc3dat (f4,NV,imr,jmr,kmr,ncfid,tindex,fldnam1,irgrid,
     &                 nc_rid,rspv)
c
c  Read in Coriolis parameter.
c
      fldnam='f'
      call get_nc2dat (f,NH,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_fid,spv)
c
c-----------------------------------------------------------------------
c  Compute Ertel potential vorticity (1/s/m) at W-points.
c-----------------------------------------------------------------------
c
      call ertel (pv,imr-1,jmr-1,kmr,f2,f3,f4,f,x,y,z,f5,f6)
c
c  Get horizontal positions at RHO-points
c
      call get_nc2pos (x,y,NV,imr,jmr,ncgid,irgrid)
c
c  Get vertical positions at W-points.
c
      if (level.le.0. .or. level.ge.1000.) then
        iwgrid=6
        call get_nc3pos (z,NV,imr,jmr,Nw,ncgid,ncfid,tindex,irgrid,
     &                   iwgrid,gotzeta,file)
      endif
c
c  Extract positions of size (Lm,Mm,Nm) for Ertel potential vorticity.
c  Also extract bath of size (Lm,Mm).
c
      im=imr-2
      jm=jmr-2
      km=Nw-2
      igrid=7
      do ip=1,imr*jmr
        f4(ip)=bath(ip)
      enddo
      ip=0
      do j=2,jmr-1
        do i=2,imr-1
          ip=ip+1
          ir=i+(j-1)*imr
          xpos(ip)=x(ir)
          ypos(ip)=y(ir)
          bath(ip)=f4(ir)
        enddo
      enddo
      if (level.le.0. .or. level.ge.1000.) then
        ip=0
        do k=2,Nw-1
          do j=2,jmr-1
            do i=2,imr-1
              ip=ip+1
              iw=i+(j-1)*imr+(k-1)*imr*jmr
              zpos(ip)=z(iw)
            enddo
          enddo
        enddo
      endif
c
c  If appropriate, extract Ertel potential vorticity at the requested
c  level.
c
      if (1.le.int(level) .and. int(level).le.km) then
        do ip=1,im*jm*km
          f4(ip)=pv(ip)
        enddo
        ip=0
        do j=1,jm
          do i=1,im
            ip=ip+1            
            iw=i+(j-1)*im+(int(level)-1)*im*jm
            pv(ip)=f4(iw)
          enddo
        enddo
      endif
      return
      end
