      subroutine get_entropy (psi, u,v, xpos,ypos, im,jm, igrid,
     &                                   ncgid, idfld, gotangle)
c
c=======================================================================
c  Copyright (c) 1998 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This subroutine computes the maximum entropy equilibrium fields   ===
c  reported by Eby and Holloway (1994).                              ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     idfld    Identification of field to read (integer).            ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     psi      Maximum entropy equilibrium transport (real array).   ===
c     u        Maximum entropy equilibrium U-component (real array). ===
c     v        Maximum entropy equilibrium V-component (real array). ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     igrid    Grid type (integer).                                  ===
c     gotangle Logical switch indicating availability of grid        ===
c              rotation angle.                                       ===
c                                                                    ===
c  Reference:                                                        ===
c                                                                    ===
c    Eby, M. and G. Holloway, 1994: sensitivity of a large-scale     ===
c            ocean model parameterization of topographic stress.     ===
c            J. Phys. Oceanog., 24, 2577-2588.                       ===
c                                                                    ===
      implicit none
#include "param.h"
#include "pconst.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltncar.h"
#include "secbath.h"
      logical gotangle
      integer i, idfld, igrid, im, imr, ip, irgrid, j, jm, jmr, ncgid,
     &        nc_fid, nc_hid, nc_lid, nc_pid
      real Lscle, spv
      real psi(NV), u(NV), v(NV), xpos(NV), ypos(NV)
      character*20 fldnam

      levless=is2d(idfld)
      fldnam1=vname1(idfld)
      fldnam2=vname2(idfld)
c
c  Read in Coriolis parameter.
c
      call get_nc2dat (f2,NH,imr,jmr,ncgid,0,fldnam1,0,irgrid,nc_fid,
     &                 spv)
c
c  Read in bathymetry.
c
      call get_nc2dat (bath,NH,imr,jmr,ncgid,0,fldnam2,0,irgrid,nc_hid,
     &                 spv)
c
c  Read in latitude.
c
      fldnam='lat_rho'
      call get_nc2dat (f3,NH,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_lid,
     &                 spv)
c
c-----------------------------------------------------------------------
c  Compute maximum entropy equilibrium transport (m3/s) at PSI-points.
c-----------------------------------------------------------------------
c
      do j=1,jmr
        do i=1,imr
          ip=i+(j-1)*imr
          Lscle=7500.0+4500.0*cos(2.*deg2rad*f3(ip))
          f4(ip)=-f2(ip)*bath(ip)*Lscle*Lscle
        enddo
      enddo
      igrid=2
      im=imr-1
      jm=jmr-1
      call cfield (psi,im,jm,1,f4,imr,jmr,1,igrid)
c
c-----------------------------------------------------------------------
c  Compute maximum entropy equilibrium velocities (m/s).
c-----------------------------------------------------------------------
c
      if (vcode(idfld).eq.'IDUNPY'.or.vcode(idfld).eq.'IDVNPY' .or.
     &    vcode(idfld).eq.'IDNPYV'.or.vcode(idfld).eq.'IDNPYM') then
c
c  Read in Coordinate transformation metrics.
c
        fldnam='pm'
        call get_nc2dat (x,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,
     &                   spv)
        fldnam='pn'
        call get_nc2dat (y,NV,imr,jmr,ncgid,0,fldnam,0,irgrid,nc_pid,
     &                   spv)
c
c  Compute vector components from streamfunction.
c
        call velocity (f3,f4,imr-1,jmr-1,psi,bath,x,y)
c
c  Interpolate to requested grid.
c
        if ((vcode(idfld).eq.'IDNPYV').or.
     &      (vcode(idfld).eq.'IDNPYM')) then
          if (lvecrho) then
            igrid=7
          else
            igrid=2
          endif
          call cvector (u,v,im,jm,1,f3,imr-1,jmr,f4,imr,jmr-1,igrid,
     &                  ncgid,gotangle)
          if (vcode(idfld).eq.'IDNPYM') then
            do ip=1,im*jm
              u(ip)=sqrt(u(ip)*u(ip)+v(ip)*v(ip))
            enddo
          endif
        elseif (vcode(idfld).eq.'IDUNPY') then
          im=imr-1
          jm=jmr
          igrid=3
          do j=1,jm
            do i=1,im
              ip=i+(j-1)*im
              u(ip)=f3(ip)
            enddo
          enddo
        elseif (vcode(idfld).eq.'IDVNPY') then
          im=imr
          jm=jmr-1
          igrid=4
          do j=1,jm
            do i=1,im
              ip=i+(j-1)*im
              u(ip)=f4(ip)
            enddo
          enddo
        endif
      endif
c
c  Get horizontal positions (Lp,Mp) at RHO-points
c
      call get_nc2pos (xpos,ypos,NV,im,jm,ncgid,igrid)
      return
      end
