      subroutine get_dpres (dpres,xpos,ypos,zpos,im,jm,km,igrid,ncgid,
     &                      ncfid,idfld,tindex,level,gotzeta,gotsalt,
     &                      gotrho,file)
!
! Computes hydrostatic dynamic pressure.
!
! input: ncgid    NetCDF ID for input grid (integer)
!        ncfid    NetCDF ID for input fields (integer)
!        idfld    Identification of field to read (integer)
!        tindex   Time dimension index to read (integer)
!        level    Depth (>0), level (>0), or isopycnal (>1000) to
!                 process (real). If LEVEL=0, the full 3D is passed
!        gotzeta  Logical switch indicating availability of free
!                                                      surface.                                              ===
!        gotsalt  Logical switch indicating availability of salinity
!        gotrho   Logical switch indicating availability of density
!        file     NetCDF file to read (primary or secondary; integer)
!
! output: dpres   Requested 3D dynamic pressure  (real array)
!         im      Size of inner dimension (integer)
!         jm      Size of outer dimension (integer)
!         km      Size of vertical dimension (integer)
!         igrid   Staggered C-grid type for requested field (integer)
!         xpos    X-positions of the requested field (real array)
!         ypos    Y-positions of the requested field (real array)
!         ypos    Z-positions of the requested field (real array)
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "param.h"
#include "pconst.h"
#include "domdat.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltlab.h"

      logical gotrho, gotsalt, gotzeta
      integer file, idfld, igrid, i,im,imr,ip, irgrid, iwgrid,
     &        j,jm, jmr, k,km,kmr,kpr,kr, ncfid, ncgid, nc_rid,
     &        nc_sid, nc_tid, tindex
      real g, level, rspv, sspv, tspv, idens
      real dpres(NV), xpos(NV), ypos(NV), zpos(NV)
      character*20 fldnam
      parameter (g=9.808)

      levless=is2d(idfld)
      fldnam1=vname1(idfld)
!
! Get density anomaly (kg/m^3).
!
      if (gotrho) then
        call get_nc3dat (f2,NV,imr,jmr,kmr,ncfid,tindex,fldnam1,irgrid,
     &                   nc_rid,rspv)
      elseif (gotsalt) then
        fldnam='temp'
        call get_nc3dat (f3,NV,imr,jmr,kmr,ncfid,tindex,fldnam,irgrid,
     &                   nc_tid,tspv)
        fldnam='salt'
        call get_nc3dat (f4,NV,imr,jmr,kmr,ncfid,tindex,fldnam,irgrid,
     &                   nc_sid,sspv)
        irgrid=1
        call get_nc3pos (zpos,NV,imr,jmr,Nr,ncgid,ncfid,tindex,irgrid,
     &                   irgrid,gotzeta,file)
        ip=0
        do k=1,kmr
          do j=1,jmr
            do i=1,imr
              ip=ip+1
              f2(ip)=idens(f3(ip),f4(ip),zpos(ip))
            enddo
          enddo
        enddo
      else
        print 10
  10    format(/,' GET_DPRES - unable to get/compute density anomaly.')
        return
      endif
!
! Get depths (m) at RHO- and W-points.
!
      if (gotrho) then
        irgrid=1
        call get_nc3pos (zpos,NV,imr,jmr,Nr,ncgid,ncfid,tindex,
     &                              irgrid, irgrid,gotzeta,file)
      endif
      iwgrid=6
      call get_nc3pos (f3,NV,imr,jmr,Nw,ncgid,ncfid,tindex,irgrid,
     &                 iwgrid,gotzeta,file)
!
! Compute dynamic pressure (N).  Integrate hydrostatic equation
! vertically.  Surface density is assumed to be that of level "Nr".
!
      do j=1,jmr
        do i=1,imr
          ip=i+(j-1)*imr
          kr=ip+(kmr-1)*imr*jmr
          kpr=ip+kmr*imr*jmr
          dpres(kr)=g*(f3(kpr)-zpos(kr))*f2(kr)
        enddo
      enddo

      do k=kmr-1,1,-1
        do j=1,jmr
          do i=1,imr
            ip=i+(j-1)*imr
            kr=ip+(k-1)*imr*jmr
            kpr=ip+k*imr*jmr
            dpres(kr)=dpres(kpr)+g*((zpos(kpr)-f3(kr))*f2(kpr)
     &                               +(f3(kr)-zpos(kr))*f2(kr))
          enddo
        enddo
      enddo
!
! Get horizontal positions (Lp,Mp) at RHO-points
!
      im=imr
      jm=jmr
      km=kmr
      igrid=1
      call get_nc2pos (xpos,ypos,NV,imr,jmr,ncgid,igrid)
!
! If appropriate, extract dynamic pressure at the requested level.
!
      if (1.le.int(level) .and. int(level).le.km) then
        do ip=1,im*jm*km
          f4(ip)=dpres(ip)
        enddo
        ip=0
        do j=1,jm
          do i=1,im
            ip=ip+1            
            kr=i+(j-1)*im+(int(level)-1)*im*jm
            dpres(ip)=f4(kr)
          enddo
        enddo
      endif
      return
      end
