      subroutine get_bvf (bvf,xpos,ypos,zpos, im,jm,km, igrid,
     &                    ncgid,ncfid, idfld, tindex,level,
     &                    gotzeta,gotsalt,gotrho, file)
!
! Computes Brunt-Visla frequency [1/s^2] at horizontal RHO-points
! and vertical W-points, from primary fields in input netCDF file.
!
! input: ncgid    netCDF ID for input grid (integer).
!        ncfid    netCDF ID for input fields (integer).
!        idfld    identification of field to read (integer).
!        tindex   time dimension index to read (integer).
!        level    Depth (>0), level (>0), or isopycnal (>1000) to
!                 process (real). If LEVEL=0, the full 3D is passed.
!        gotzeta  Logical switch indicating availability of free-
!        gotsalt          surface, salinity, and density.
!        gotrho   Logical switch indicating availability of density.
!        file     NetCDF file to read (primary or secondary; integer)
!
! output: bvf     Brunt-Vaisala frequency (real array).
!         im      Size of inner dimension (integer).
!         jm      Size of outer dimension (integer).
!         km      Size of vertical dimension (integer).
!         igrid   Staggered C-grid type for requested field (integer)
!         xpos    X-positions of the requested field (real array)
!         ypos     Y-positions of the requested field (real array)
!         zpos     Z-positions of the requested field (real array)
!
      implicit none
#include "param.h"
#include "domdat.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"

      logical gotrho, gotsalt, gotzeta
      integer file, i, idfld, igrid, im, imr, ip, irgrid, iw, iwgrid,
     &        j, jm, jmr, k, km, kmr, kpr, kr, ncfid, ncgid, nc_rid,
     &        nc_sid, nc_tid, tindex
      real g, gorho0, level, rspv, sspv, tspv
      real bvf(NV), xpos(NV), ypos(NV), zpos(NV)
      character*20 fldnam
      parameter (g=9.808)

      levless=is2d(idfld)
      fldnam1=vname1(idfld)
      fldnam2=vname2(idfld)
!
! Compute Brunt-Vaisala frequency from temperature and salinity.
!

      write(*,*) gotrho, gotsalt, gotzeta
c     if (gotsalt) then
        call get_nc3dat (f2, NV, imr,jmr,kmr, ncfid,tindex,
     &                       fldnam1, irgrid, nc_tid, tspv)
        call get_nc3dat (f3, NV, imr,jmr,kmr, ncfid,tindex,
     &                       fldnam2, irgrid, nc_sid, sspv)
        iwgrid=6
        write(*,*) NV,imr,jmr,kmr
        call get_nc3pos (z, NV, imr,jmr,Nw, ncgid,ncfid,
     &                 tindex,irgrid, iwgrid,gotzeta,file)
        call bv_freq (bvf,f2,f3,z,imr-1,jmr-1,kmr)
/*
      elseif (gotrho) then
        fldnam='rho'
        call get_nc3dat (f2, NV, imr,jmr,kmr, ncfid,tindex,
     &                      fldnam,irgrid, nc_rid,rspv)
        call get_nc3pos (z,  NV, imr,jmr,Nr,  ncgid,ncfid,
     &                  tindex,irgrid, irgrid,gotzeta,file)
        gorho0=g/rho0
        do k=1,kmr-1
          do j=1,jmr
            do i=1,imr
              kr=i+(j-1)*imr+(k-1)*imr*jmr
              kpr=i+(j-1)*imr+k*imr*jmr
              bvf(kr)=-gorho0*(f2(kpr)-f2(kr))/(z(kpr)-z(kr))
            enddo
          enddo
        enddo
      else
        write(*,'(/1x,A,1x,A/) 'GET_BVF - unable to compute',
     &          'Brunt-Vaisala frequency.'
        return
      endif
*/
!
! Get horizontal positions (Lp,Mp) at RHO-points
!
      im=imr
      jm=jmr
      km=Nw-2
      igrid=1
      call get_nc2pos (xpos,ypos,NV,imr,jmr,ncgid,igrid)
c
c  Get vertical positions (Lp,Mp,Nm) at W-points.
c
      if (level.le.0. .or. level.ge.1000.) then
        iwgrid=6
        call get_nc3pos (f4,NV,imr,jmr,Nw,ncgid,ncfid,tindex,igrid,
     &                   iwgrid,gotzeta,file)
        ip=0
        do k=2,Nw-1
          do j=1,jmr
            do i=1,imr
              ip=ip+1
              iw=i+(j-1)*imr+(k-1)*imr*jmr
              zpos(ip)=z(iw)
            enddo
          enddo
        enddo
      endif
c
c  If appropriate, extract Brunt-Vaisala frequency at the requested
c  level.
c
      if (1.le.int(level) .and. int(level).le.km) then
        do ip=1,im*jm*km
          f4(ip)=bvf(ip)
        enddo
        ip=0
        do j=1,jm
          do i=1,im
            ip=ip+1            
            iw=i+(j-1)*im+(int(level)-1)*im*jm
            bvf(ip)=f4(iw)
          enddo
        enddo
      endif
      return
      end
