      subroutine get_bernoulli (B,xpos,ypos,zpos,im,jm,km,igrid,ncgid,
     &                          ncfid,idfld,tindex,level,gotzeta,
     &                          gotsalt,gotrho,file)
c
c  This subroutine computes hydrostatic dynamic pressure.            ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     ncfid    NetCDF ID for input fields (integer).                 ===
c     idfld    Identification of field to read (integer).            ===
c     tindex   Time dimension index to read (integer).               ===
c     level    Depth (>0), level (>0), or isopycnal (>1000) to       ===
c              process (real). If LEVEL=0, the full 3D is passed.    ===
c     gotzeta  Logical switch indicating availability of free-       ===
c              surface.                                              ===
c     gotsalt  Logical switch indicating availability of salinity.   ===
c     gotrho   Logical switch indicating availability of density.    ===
c     file     NetCDF file to read (primary or secondary; integer)   ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     B        Requested Bernoulli function (real array; Pa).        ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     km       Size of vertical dimension (integer).                 ===
c     igrid    Staggered C-grid type for requested field (integer).  ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c     ypos     Z-positions of the requested field (real array).      ===
c                                                                    ===
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "param.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"

      logical gotrho, gotsalt, gotzeta
      integer file, i, idfld, igrid, im, imr, ip, irgrid, iwgrid, j, jm,
     &        jmr, k, km, kmr, ncfid, ncgid, nc_rid, nc_sid, nc_tid,
     &        nc_zid, tindex
      real level, rspv, sspv, tspv, zspv
      real idens
      real B(NV), xpos(NV), ypos(NV), zpos(NV)
      character*20 fldnam

      levless=is2d(idfld)
      fldnam1=vname1(idfld)
c
c  Get density anomaly (kg/m^3).
c
      if (gotrho) then
        call get_nc3dat (f2,NV,imr,jmr,kmr,ncfid,tindex,fldnam1,irgrid,
     &                   nc_rid,rspv)
      elseif (gotsalt) then
        fldnam='temp'
        call get_nc3dat (f3,NV,imr,jmr,kmr,ncfid,tindex,fldnam,irgrid,
     &                   nc_tid,tspv)
        fldnam='salt'
        call get_nc3dat (f4,NV,imr,jmr,kmr,ncfid,tindex,fldnam,irgrid,
     &                   nc_sid,sspv)
        irgrid=1
        call get_nc3pos (zpos,NV,imr,jmr,Nr,ncgid,ncfid,tindex,irgrid,
     &                   irgrid,gotzeta,file)
        ip=0
        do k=1,kmr
          do j=1,jmr
            do i=1,imr
              ip=ip+1
              f2(ip)=idens(f3(ip),f4(ip),zpos(ip))
            enddo
          enddo
        enddo
      else
        print 10
  10    format(/,' GET_BERNOULLI - unable to get/compute density ',
     &         'anomaly.')
        return
      endif
c
c  Get depths (m) at RHO- and W-points.
c
      if (gotrho) then
        irgrid=1
        call get_nc3pos (zpos,NV,imr,jmr,Nr,ncgid,ncfid,tindex,irgrid,
     &                   irgrid,gotzeta,file)
      endif
      iwgrid=6
      call get_nc3pos (f4,NV,imr,jmr,Nw,ncgid,ncfid,tindex,irgrid,
     &                 iwgrid,gotzeta,file)
c
c  Get free-surface.
c
      fldnam='zeta'
      call get_nc2dat (f3,NV,imr,jmr,ncfid,tindex,fldnam,0,irgrid,
     &                 nc_zid,zspv)
c
c-----------------------------------------------------------------------
c  Compute Bernoulli function (Pa).
c-----------------------------------------------------------------------
c
      im=imr
      jm=jmr
      if (level.le.0. .or. level.ge.1000.) then
        km=1
        interpolate=.false.
        levless=.true.
      endif
      call bernoulli (B,f2,f3,f4,zpos,ziso,imr-1,jmr-1,kmr,level)
c
c  Get horizontal positions (Lp,Mp) at RHO-points
c
      igrid=1
      call get_nc2pos (xpos,ypos,NV,imr,jmr,ncgid,igrid)
      return
      end
