      subroutine get_ape (ape,xpos,ypos,zpos,im,jm,km,igrid,ncgid,ncfid,
     &                    idfld,tindex,level,gotzeta,gotsalt,gotrho,
     &                    file)
c
c=======================================================================
c  Copyright (c) 1996 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This subroutine computes available potential energy.              ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     ncgid    NetCDF ID for input grid (integer).                   ===
c     ncfid    NetCDF ID for input fields (integer).                 ===
c     idfld    Identification of field to read (integer).            ===
c     tindex   Time dimension index to read (integer).               ===
c     level    Depth (>0), level (>0), or isopycnal (>1000) to       ===
c              process (real). If LEVEL=0, the full 3D is passed.    ===
c     gotzeta  Logical switch indicating availability of free-       ===
c              surface.                                              ===
c     gotsalt  Logical switch indicating availability of salinity.   ===
c     gotrho   Logical switch indicating availability of density.    ===
c     file     NetCDF file to read (primary or secondary; integer).  ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     ape      Requested 3D available potential energy (real array). ===
c     im       Size of inner dimension (integer).                    ===
c     jm       Size of outer dimension (integer).                    ===
c     km       Size of vertical dimension (integer).                 ===
c     igrid    Staggered C-grid type for requested field (integer).  ===
c     xpos     X-positions of the requested field (real array).      ===
c     ypos     Y-positions of the requested field (real array).      ===
c     ypos     Z-positions of the requested field (real array).      ===
c                                                                    ===
      implicit none
#include "param.h"
#include "domdat.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"

      logical gotrho, gotsalt, gotzeta
      integer file, i, idfld, igrid, im, imr, ip, irgrid, iw, iwgrid,
     &        j, jm, jmr, k, km, kmr, kmz, kpr, kr, kz, ncfid, ncgid,
     &        nc_rid, nc_sid, nc_tid, tindex
      real g, gorho0, level, rspv, sspv, tspv
      real idens
      real ape(NV), xpos(NV), ypos(NV), zpos(NV)
      character*20 fldnam
      parameter (g=9.81)

      levless=is2d(idfld)
      fldnam1=vname1(idfld)
c
c  Get density anomaly (kg/m^3).
c
      if (gotrho) then
        call get_nc3dat (f2,NV,imr,jmr,kmr,ncfid,tindex,fldnam1,irgrid,
     &                   nc_rid,rspv)
      elseif (gotsalt) then
        fldnam='temp'
        call get_nc3dat (f3,NV,imr,jmr,kmr,ncfid,tindex,fldnam,irgrid,
     &                   nc_tid,tspv)
        fldnam='salt'
        call get_nc3dat (f4,NV,imr,jmr,kmr,ncfid,tindex,fldnam,irgrid,
     &                   nc_sid,sspv)
        irgrid=1
        call get_nc3pos (z,NV,imr,jmr,Nr,ncgid,ncfid,tindex,irgrid,
     &                   irgrid,gotzeta,file)
        ip=0
        do k=1,kmr
          do j=1,jmr
            do i=1,imr
              ip=ip+1
              f2(ip)=idens(f3(ip),f4(ip),z(ip))
            enddo
          enddo
        enddo
      else
        print 10
  10    format(/,' GET_APE - unable to get/compute potential density.')
        return
      endif
c
c  Get depths (m) at RHO- and W-points.
c
      if (gotrho) then
        irgrid=1
        call get_nc3pos (z,NV,imr,jmr,Nr,ncgid,ncfid,tindex,irgrid,
     &                   irgrid,gotzeta,file)
      endif
      iwgrid=6
      call get_nc3pos (f3,NV,imr,jmr,Nw,ncgid,ncfid,tindex,irgrid,
     &                 iwgrid,gotzeta,file)
c
c  Compute potential energy (Lp,Mp,Nm).
c
      ip=0
      gorho0=g/rho0
      do k=1,kmr
        do j=1,jmr
          do i=1,imr
            ip=ip+1
            f4(ip)=-gorho0*f2(ip)*f3(ip)
            f5(ip)=f4(ip)
          enddo
        enddo
      enddo
c
c  Integrate vertically.
c
      do k=kmr-1,1
        do j=1,jmr
          do i=1,imr
            ip=i+(j-1)*imr
            kr=ip+(k-1)*imr*jmr
            kpr=ip+k*imr*jmr
            kz=ip+k*imr*jmr
            kmz=ip+(k-1)*imr*jmr
            f5(kr)=f5(kpr)+f4(kr)/(f3(kz)-f3(kmz))
          enddo
        enddo
      enddo
      ip=0
      do k=1,kmr-1
        do j=1,jmr
          do i=1,imr
            ip=ip+1
            kr=i+(j-1)*imr+(k-1)*imr*jmr
            ape(ip)=f5(kr)
          enddo
        enddo
      enddo
c
c Get horizontal positions (Lp,Mp) at RHO-points
c
      im=imr
      jm=jmr
      km=Nw-2
      igrid=1
      call get_nc2pos (xpos,ypos,NV,imr,jmr,ncgid,igrid)
c
c Get vertical positions (Lp,Mp,Nm) at W-points.
c
      if (level.le.0. .or. level.ge.1000.) then
        ip=0
        do k=2,Nw-1
          do j=1,jmr
            do i=1,imr
              ip=ip+1
              iw=i+(j-1)*imr+(k-1)*imr*jmr
              zpos(ip)=f3(iw)
            enddo
          enddo
        enddo
      endif
c
c If appropriate, extract available potential energy at the requested
c level.
c
      if (1.le.int(level) .and. int(level).le.km) then
        do ip=1,im*jm*km
          f4(ip)=ape(ip)
        enddo
        ip=0
        do j=1,jm
          do i=1,im
            ip=ip+1            
            iw=i+(j-1)*im+(int(level)-1)*im*jm
            ape(ip)=f4(iw)
          enddo
        enddo
      endif
      return
      end
