! This is include file "fldsid.h"
!
! nvarids  Current number of variables in ID file.
! is2d     Switch indicating spatial 2D or 3D variable (logical).
! vcode    Variable text code identification (six character string).
!      Variable to plot identification (integer).
! vlabel   Variable plot label (character string).
! vname1   NetCDF name for variable 1 (character string)
! vname2   NetCDF name for variable 2 (character string).
! vtype    Variable type switch (integer):
!               vtype = 1, scalar variable.
!               vtype = 2, vector variable.
!               vtype = 3, derived from two scalar variables.
!               vtype = 4, special scalar variable.
!               vtype = 5, special vector variable.
!               vtype = 6, streamlines from vector variables.
!
! Copyright (c) 1996 Rutgers University
!
      integer maxids
      parameter (maxids=300)
      logical is2d(0:maxids)
      integer nvarids,  vtype(0:maxids)
      common /ifldsid/ nvarids, is2d,  vtype
      character*6  vcode(0:maxids)
      character*16 vname1(0:maxids), vname2(0:maxids)
      character*80 vlabel(0:maxids)
      common /cfldsid/ vcode, vname1, vname2, vlabel
