      subroutine fdiag (f, im,jm, idfld, day, level, 
     &                   fmin,fmax, favg, frms,fsdv)
!
! Computes field diagnostics.
!
! Input:  f   --   field (real array).
!         im,jm -- sizees of inner and outer dimensions (integer).
!         idfld -- field identification.
!         day   -- day (real)      
!         level -- depth (>0), level (>0), or isopycnal (>1000)
!                  to process (real).
!                                       ! Also internally reported:
! Output: fmin -- minimum value         !---------------------------
!         fmax -- maximum value         !   fadv -- average deviation
!         favg -- mean                  !   fvar -- variance
!         frms -- root mean square      !   fskw -- skewness
!         fsdv -- standard deviation    !   fvar -- variance

!
      implicit none
      integer im,jm, idfld
      real*8 day
      real f(im,jm), level, fmin,fmax,  favg, frms,fsdv,
     &               p,s, small,term,  fadv,fkur,fskw,fvar
      integer i,j, imin,imax, jmin,jmax, npts, lenfld, lenstr
      parameter (small=1.0e-20)
      character string*15, fldlab*80
#include "pconst.h"
#include "fldsid.h"
#include "pltncar.h"
#include "pltio.h"

      npts=0                  ! Compute the mean and 
      favg=0.                 ! minimum and maximum values.
      fmin=spval1
      fmax=-spval1            ! Note that since averaged value
      imin=0                  ! later participates in computation
      jmin=0                  ! of r.m.s. deviation, skewness, etc.
      imax=0                  ! this code segment cannot be combined 
      jmax=0                  ! with the later one.
      do j=1,jm
        do i=1,im
          if (f(i,j).ne.spval1) then
            npts=npts+1
            favg=favg+f(i,j)
            if (f(i,j).lt.fmin) then
              fmin=f(i,j)
              imin=i
              jmin=j
            endif
            if (f(i,j).gt.fmax) then
              fmax=f(i,j)
              imax=i
              jmax=j
            endif
          endif
        enddo
      enddo

      if (npts.gt.0) then
        favg=favg/float(npts)
        frms=0.               ! Compute the root mean square "frms",
        fadv=0.               ! average deviation "fadev",
        fvar=0.               ! standard deviation "fsdv",
        fskw=0.               ! variance "fvar", skewness "fskew",
        fkur=0.               ! and kurtosis "fkur".
        do j=1,jm
          do i=1,im
            if (f(i,j).ne.spval1) then
              frms=frms+f(i,j)*f(i,j)
              s=f(i,j)-favg
              fadv=fadv+abs(s)
              p=s*s
              fvar=fvar+p
              p=p*s
              fskw=fskw+p
              p=p*s
              fkur=fkur+p
            endif
          enddo
        enddo
        frms=sqrt(frms/float(npts))
        fadv=fadv/float(npts)
        fvar=fvar/float(npts)
        fsdv=sqrt(fvar)
        term=float(npts)*fsdv**3
        if (term.gt.small) then
          fskw=fskw/term
        else
          fskw=spval1
        endif
        term=float(npts)*fvar**2
        if (term.gt.small) then
          fkur=fkur/term
        else
          fkur=spval1
        endif
      else
        favg=spval1
        frms=spval1
        fadv=spval1
        fvar=spval1
        fsdv=spval1
        fskw=spval1
        fkur=spval1
      endif                           !
                                      ! Report diagnostics.
      fldlab=vlabel(idfld)            !
      lenfld=lenstr(fldlab)
      write(stdout,'(/1x,A$)') fldlab(1:lenfld)
      if (plttyp.eq.1 .and. .not.is2d(idfld)) then
        if (level.le.0.) then
          write(stdout,'(1x,A,F8.2,$)') 'at depth =', abs(level)
        elseif (level.lt.1000.) then
          write(stdout,'(1x,A,I3,$)') 'at model level =', int(level)
        elseif (level.lt.20000.) then
          write(stdout,'(1x,A,F8.2,$)') 'at isopycnal =', level
        endif
      endif
      write(stdout,'(2x,A,I7)') 'live points:', npts
      write(string,'(A5,F10.3)') 'Day =',day
      write(stdout,1) 'Max =', fmax,  '(', imax,  ',', jmax, ')',
     &     string,    'Min =', fmin,  '(', imin,  ',', jmin, ')',
     &               'Mean =', favg,
     & '               RMS =', frms,          'Variance =', fvar,
     & 'Average  Deviation =', fadv,          'Skewness =', fskw,
     & 'Standard Deviation =', fsdv,          'Kurtosis =', fkur
  1   format( 22x, A, 1pe15.8, 3x, 2(A,I3),A/  1x, A,
     &         6x, A, 1pe15.8, 3x, 2(A,I3),A/ 21x, A, 1pe15.8/
     &       3(7x, A, 1pe15.8, 3x,                 A, 1pe15.8/))
      return
      end
