      subroutine ertel (pv,L,M,N,u,v,rho,f,pm,pn,z_r,wk1,wk2)
c
c=======================================================================
c  Copyright (c) 1996 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This routine computes Ertel potential vorticity.                  ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     L        Number of grid points in the XI-direction.            ===
c     M        Number of grid points in the ETA-direction.           ===
c     N        Number of vertical levels.                            ===
c     u        Total velocity component (m/s) in the XI-direction.   ===
c     v        Total velocity component (m/s) in the ETA-direction.  ===
c     rho      Density anomaly perturbation (kg/m^3).                ===
c     f        Coriolis parameter (1/s).                             ===
c     pm       Coordinate transformation metric "m" (1/meters)       ===
c              associated with the differential distances in XI.     ===
c     pn       Coordinate transformation metric "n" (1/meters)       ===
c              associated with the differential distances in ETA.    ===
c     z_r      Actual depths (m) at RHO-points.                      ===
c     wk1      Utility work array.                                   ===
c     wk2      Utility work array.                                   ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     pv       Ertel potential vorticity (1/s/m).                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global variables.
c-----------------------------------------------------------------------
c
      implicit none
#include "domdat.h"
c
c-----------------------------------------------------------------------
c  Define local variables.
c-----------------------------------------------------------------------
c
      integer L, Lm, M, Mm, N, Nm, i, j, k
      real c1, p5, p25, p125
      real f(0:L,0:M), pm(0:L,0:M), pn(0:L,0:M), pv(L-1,M-1,N-1),
     &     rho(0:L,0:M,N), u(L,0:M,N), v(0:L,M,N), wk1(0:L,0:M,N),
     &     wk2(0:L,0:M,N), z_r(0:L,0:M,N)
      parameter (c1=1.0, p5=0.5, p25=0.25, p125=0.125)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      Lm=L-1
      Mm=M-1
      Nm=N-1
c
c-----------------------------------------------------------------------
c  Ertel potential vorticity, term 1: [f + (dv/dx - du/dy)]*drho/dz
c-----------------------------------------------------------------------
c
c  Compute d(v)/d(xi) at PSI-points and store in "wk1".
c
      do k=1,N
        do j=1,M
          do i=1,L
            wk1(i,j,k)=(v(i,j,k)-v(i-1,j,k))*
     &                 p25*(pm(i,j)+pm(i-1,j)+pm(i,j-1)+pm(i-1,j-1))
          enddo
        enddo
      enddo
c
c  Compute d(u)/d(eta) at PSI-points and store in "wk2".
c
      do k=1,N
        do j=1,M
          do i=1,L
            wk2(i,j,k)=(u(i,j,k)-u(i,j-1,k))*
     &                 p25*(pn(i,j)+pn(i-1,j)+pn(i,j-1)+pn(i-1,j-1))
            enddo
         enddo
      enddo
c
c  Compute Ertel potential vorticity at horizontal RHO-points and
c  vertical W-points.
c
      do k=1,Nm
        do j=1,Mm
          do i=1,Lm
            pv(i,j,k)=(f(i,j)+
     &                 p125*(wk1(i  ,j  ,k  )-wk2(i  ,j  ,k  )+
     &                       wk1(i  ,j  ,k+1)-wk2(i  ,j  ,k+1)+
     &                       wk1(i+1,j  ,k  )-wk2(i+1,j  ,k  )+
     &                       wk1(i+1,j  ,k+1)-wk2(i+1,j  ,k+1)+
     &                       wk1(i  ,j+1,k  )-wk2(i  ,j+1,k  )+
     &                       wk1(i  ,j+1,k+1)-wk2(i  ,j+1,k+1)+
     &                       wk1(i+1,j+1,k  )-wk2(i+1,j+1,k  )+
     &                       wk1(i+1,j+1,k+1)-wk2(i+1,j+1,k+1)))*
     &                (rho(i,j,k+1)-rho(i,j,k))/
     &                (z_r(i,j,k+1)-z_r(i,j,k))
          enddo
        enddo
      enddo
c
c-----------------------------------------------------------------------
c  Ertel potential vorticity, term 2: (dv/dz)*(drho/dx)
c-----------------------------------------------------------------------
c
c  Compute d(v)/d(z) at horizontal V-points and vertical W-points
c  and store in "wk1".
c
      do k=1,Nm
        do j=1,M
          do i=0,L
            wk1(i,j,k)=(v(i,j,k+1)-v(i,j,k))/
     &                 (p5*((z_r(i,j,k+1)+z_r(i,j-1,k+1))-
     &                      (z_r(i,j,k  )+z_r(i,j-1,k  ))))
          enddo
        enddo
      enddo
c
c  Compute d(rho)/d(xi) at horizontal U-points and vertical RHO-points
c  and store in "wk2".
c
      do k=1,N
        do j=0,M
          do i=1,L
            wk2(i,j,k)=(rho(i,j,k)-rho(i-1,j,k))*
     &                 p5*(pm(i,j)+pm(i-1,j))
          enddo
        enddo
      enddo
c
c  Add in term 2 contribution to Ertel potential vorticity.
c
      do k=1,Nm
        do j=1,Mm
          do i=1,Lm
            pv(i,j,k)=pv(i,j,k)-
     &                p5*(wk1(i,j,k)+wk1(i,j+1,k))*
     &                p25*(wk2(i,j,k  )+wk2(i+1,j,k  )+
     &                     wk2(i,j,k+1)+wk2(i+1,j,k+1))
          enddo
        enddo
      enddo
c
c-----------------------------------------------------------------------
c  Ertel potential vorticity, term 3: (du/dz)*(drho/dy)
c-----------------------------------------------------------------------
c
c  Compute d(u)/d(z) at horizontal U-points and vertical W-points
c  and store in "wk1".
c
      do k=1,Nm
        do j=0,M
          do i=1,L
            wk1(i,j,k)=(u(i,j,k+1)-u(i,j,k))/
     &                 (p5*((z_r(i,j,k+1)+z_r(i-1,j,k+1))-
     &                      (z_r(i,j,k  )+z_r(i-1,j,k  ))))
          enddo
        enddo
      enddo
c
c  Compute d(rho)/d(eta) at horizontal V-points and vertical RHO-points
c  and store in "wk2".
c
      do k=1,N
        do j=1,M
          do i=0,L
            wk2(i,j,k)=(rho(i,j,k)-rho(i,j-1,k))*
     &                 p5*(pn(i,j)+pn(i,j-1))
          enddo
        enddo
      enddo
c
c  Add in term 3 contribution to Ertel potential vorticity.
c
      do k=1,Nm
        do j=1,Mm
          do i=1,Lm
            pv(i,j,k)=pv(i,j,k)+
     &                p5*(wk1(i,j,k)+wk1(i+1,j,k))*
     &                p25*(wk2(i,j,k  )+wk2(i,j+1,k  )+
     &                     wk2(i,j,k+1)+wk2(i,j+1,k+1))
          enddo
        enddo
      enddo
c
c  Divide by RHO0. Set depths positions.
c
      do k=1,Nm
        do j=1,Mm
          do i=1,Lm
            pv(i,j,k)=pv(i,j,k)/rho0
          enddo
        enddo
      enddo
      return
      end
