      subroutine velocity (u,v,L,M,psi,D,pm,pn)
c
c=======================================================================
c  Copyright (c) 1998 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This subroutine computes velocity components from transport       ===
c  streamfunction.                                                   ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     L        Number of grid points in the XI-direction.            ===
c     M        Number of grid points in the ETA-direction.           ===
c     psi      transport streamfunction (meters^3/s).                ===
c     D        total depth of water column (meters; positive).       ===
c     pm       Coordinate transformation metric "m" (1/meters)       ===
c              associated with the differential distances in XI.     ===
c     pn       Coordinate transformation metric "n" (1/meters)       ===
c              associated with the differential distances in ETA.    ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     u        velocity component in the XI-direction (m/s).         ===
c     v        velocity component in the ETA-direction (m/s).        ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local variables.
c-----------------------------------------------------------------------
c
      integer L, Lm, M, Mm, i, j
      real D(0:L,0:M), psi(L-1,M-1), pm(0:L,0:M), pn(0:L,0:M),
     &      u(L,0:M), v(0:L,M)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      Lm=L-1
      Mm=M-1
c
c  Compute velocity components from transport streamfunction.
c
      do j=1,Mm
        do i=1,L
          u(i,j)=-(psi(i,j+1)-psi(i,j))*
     &            (pn(i-1,j)+pn(i,j))/(D(i-1,j)+D(i,j))
        enddo
      enddo
      do j=1,M
        do i=1,Lm
          v(i,j)=(psi(i+1,j)-psi(i,j))*
     &           (pm(i,j-1)+pm(i,j))/(D(i,j-1)+D(i,j))
        enddo
      enddo
c
c  Pad out vaules at the edges.
c
      do i=1,L
        u(i,0)=u(i,1 )
        u(i,M)=u(i,Mm)
      enddo
      do j=1,M
        v(0,j)=v(1 ,j)
        v(L,j)=v(Lm,j)
      enddo
      return
      end
