      subroutine draw_line (iunit, kind)
!
! Read and draw map attribute data as follows:
! kind = 1 - Lagrangian trajectories (lat,lon,z,time)
!        2 -  hydrographic stations
!
! Copyright (c) 1996 Rutgers University.
!
      implicit none
      integer iunit,kind, ierr, julday,itime,npts,ista
      real lon,lat, x,y, z,time, day
      logical pen_down
#include "pconst.h"
#include "pltncar.h"
#if VERBOSE > 1
      write(*,'(1x,A,I3,A,$)') 'Enter draw_line, kind =', kind, '...'
#endif
      ierr=0                            ! Read and draw Lagrangian
      pen_down=.false.                  ! trajectories and floats.
      if (kind.eq.1) then
        do while (ierr.eq.0)
          read(iunit,*,iostat=ierr) lat, lon, z, time
          if (lon.ne.spvgeo .and. lat.ne.spvgeo) then
            call maptrn (lat,lon,x,y)
            if (x.ge.ul .and. x.le.ur .and.
     &          y.ge.ub .and. y.le.ut) then
              if (pen_down) then
                call vector (x,y)
              else
                call frstpt (x,y)
                call plchhq (x,y,':1256:',5.,0.,0.)
                day=float(int(time))+1.
                pen_down=.true.
              endif
              if (time.gt.day) then
                day=day+1.
                call plchhq (x,y, ':1245:', 5.,0.,0.)
              endif
            else
              pen_down=.false.
            endif
          else
            pen_down=.false.
          endif
        enddo                               ! Draw cruise
      elseif (kind.eq.2) then               ! track stations.
        do while (ierr.eq.0)
          read(iunit,*,iostat=ierr) lat,lon, z,julday,itime,npts,ista
          if (lon.ne.spvgeo .and. lat.ne.spvgeo) then
            call maptrn (lat,lon, x,y)
            if (x.ge.ul .and. x.le.ur .and.
     &          y.ge.ub .and. y.le.ut) then
              call plchhq (x,y, ':1245:', 5.,0.,0.)
            endif
          endif
        enddo
      endif
      rewind(iunit)
#if VERBOSE > 1
      write(*,'(1x,A)') '...return from draw_line.'
#endif
      return
      end
