      subroutine draw_cities
!
! Read data from file, for example names and coordinates of cities,
! and draw them. Each record in the file is expected to be in the 
! form
!        lat lon size angle ctr 'Character String'
! where
!        lat,lon  -- are geographical coordinates of the object,
!                          (longitude and latitude in degrees);
!        size,angle,ctr -- size,angle and centering parameter
!                          of the desired label (the same as
!                          the last three arguments of plchhq) 
!        'Character String' -- name of the object.
!
! NOTE: 1. It is not necessary to encase 'Character String' into
!          single or double quites, just leaving blank characters
!          is enough. The numbers may be separated with commas, or
!          just blank spaces; 
!
!       2. The size is the size of letters as it is desired on 
!          plot which occupies the whole page. If is automatically
!          rescaled (multiplied by basesize, if the current viewport
!          is smaller that the whole page).     
!
      implicit none
      character string*80, quote*1, double_quote*1
      logical not_end_of_file, blank
      real lat,lon,  size,angle,ctr, x,y
      integer iocheck, i,j, is(16),ie(16), nwords, lstr,lenstr
#include "pltio.h"
#include "pltncar.h"
      quote=char(39)
      double_quote=char(34)

      lstr=lenstr(cities)
      open (unit=inpcty, file=cities(1:lstr), form='formatted',
     &                                  status='old',  err=99)
#if VERBOSE > 2
      write(*,'(1x,3A,$)') 'Enter draw_cities, file =''',
     &                            cities(1:lstr), '''...'
#endif
c--#define TEST_DRAW_CITIES
      not_end_of_file=.true.
      do while (not_end_of_file)
        do i=1,80
          string(i:i)=' '
        enddo
        read(inpcty,'(A80)',iostat=iocheck,end=1) string
        goto 2     
   1    not_end_of_file=.false.
   2    lstr=0 
        if (iocheck.eq.0) then
          blank=.true. 
          nwords=0
          lstr=0
          do i=1,80
            if (string(i:i).eq.',' .or. string(i:i).eq.quote
     &       .or. string(i:i).eq.double_quote) string(i:i)=' '
            if (string(i:i).ne.' ') lstr=i
            if (blank .and. string(i:i).ne.' ') then
              blank=.false. 
              nwords=nwords+1
              is(nwords)=i
            elseif (.not.blank .and. string(i:i).eq.' ') then
              blank=.true.
              ie(nwords)=i-1
            elseif (.not.blank .and. i.eq.80) then
              ie(nwords)=i
            endif
          enddo

        write(*,*) string
        write(*,'(20I4)') (is(i),ie(i), i=1,nwords)
        do i=1,nwords
          write(*,'(3A)') '''', string(is(i):ie(i)), ''''
        enddo

          read (string(is(1):ie(1)),*,iostat=iocheck) lat
          if (iocheck.eq.0) then 
            read (string(is(2):ie(2)),*,iostat=iocheck) lon
            if (iocheck.eq.0) then
              read (string(is(3):ie(3)),*,iostat=iocheck) size 
              if (iocheck.eq.0) then
                read (string(is(4):ie(4)),*,iostat=iocheck) angle
                if (iocheck.eq.0) then
                  read (string(is(5):ie(5)),*,iostat=iocheck) ctr
                  if (iocheck.eq.0) then
                    lstr=ie(nwords)-is(6)+1
                    string(1:lstr)=string(is(6):ie(nwords))
#ifndef TEST_DRAW_CITIES
                    call maptrn (lat,lon, x,y)
                    write(*,*) ul,x,ur
                    write(*,*) ub,y,ut
                    if (x.gt.ul .and. x.lt.ur .and.
     &                  y.gt.ub .and. y.lt.ut) then
                      call plchhq (x,y, string(1:lstr),
     &                       size*basesize, angle, ctr)
#endif
#if VERBOSE > 2 || defined TEST_DRAW_CITIES
                   write(*,'(/5F10.4,1x,3A)') lat,lon, size*basesize,
     &                         angle, ctr, '''', string(1:lstr), ''''
#endif
#ifndef TEST_DRAW_CITIES
                    endif 
#endif
                  endif
                endif
              endif
            endif
          endif
        endif
      enddo
#if VERBOSE > 2
      write(*,'(1x,A)') '...return from draw_cities.'
#endif
      close (unit=inpcty)
  99  return
      end

#ifdef TEST_DRAW_CITIES
      implicit none              ! Driver program for self-testing.
# include "pltio.h"
      cities='test.dat'
      call draw_cities
      stop
      end
#endif

