      subroutine dombox (im,jm)
!
! Draws model domain box. Domain coordinates are
! stored at the beginning of storage array FIELDS.
!
! Copyright (c) 1996 Rutgers University.
!
      implicit none
#include "param.h"
      integer im,jm, i,j, ip
      real x_map,y_map, xmap(NX),ymap(NX)
      logical pen_down, masked 
#include "fields.h"
#include "fmask.h"
#include "pltfld.h"
#include "pltncar.h"
      masked=.false.                !
      call gslwsc (thin_line)       ! Draw domain grid.
      if (iref.eq.-1) then          !
        if (spherical) then
          do j=1,jm
            pen_down=.false.
            do i=1,im
              ip=i+(j-1)*im
              if (masked) then
                if (mask(ip).gt.0.) then
                  call maptrn (y(ip),x(ip),x_map,y_map)
                  if (pen_down) then
                    call vector (x_map,y_map)
                  else
                    call frstpt (x_map,y_map)
                    pen_down=.true.
                  endif
                else
                  pen_down=.false.
                endif
              else
                call maptrn (y(ip),x(ip),xmap(i),ymap(i))
              endif
            enddo
            if (.not.masked) call curve (xmap,ymap,im)
          enddo
          do i=1,im
            pen_down=.false.
            do j=1,jm
              ip=i+(j-1)*im
              if (masked) then
                if (mask(ip).gt.0.) then
                  call maptrn (y(ip),x(ip),x_map,y_map)
                  if (pen_down) then
                    call vector (x_map,y_map)
                  else
                    call frstpt (x_map,y_map)
                    pen_down=.true.
                  endif
                else
                  pen_down=.false.
                endif
              else
                call maptrn (y(ip),x(ip), xmap(j),ymap(j))
              endif
            enddo
            if (.not.masked) call curve (xmap,ymap,jm)
          enddo
        else
          do j=1,jm
            do i=1,im
              ip=i+(j-1)*im
              xmap(i)=x(ip)
              ymap(i)=y(ip)
            enddo
            call curve (xmap,ymap,im)
          enddo
          do i=1,im
            do j=1,jm
              ip=i+(j-1)*im
              xmap(j)=x(ip)
              ymap(j)=y(ip)
            enddo
            call curve (xmap,ymap,jm)
          enddo
        endif
      endif
!
! Draw curvilinear grid boundary.
!----- ----------- ---- ---------
!
      call domain_contour (spherical, im,jm, x,y, xmap,ymap) 
      call gslwsc (thick_line)
      call curve (xmap(        1),  ymap(      1  ),   im)
      call curve (xmap(  im     ),  ymap(  im     ),   jm)
      call curve (xmap(  im+jm-1),  ymap(  im+jm-1),   im)
      call curve (xmap(2*im+jm-2),  ymap(2*im+jm-2),   jm)
      call gslwsc (medium_line)
      return
      end
