      subroutine domain_contour (spherical, im,jm, x,y, xra,yra)
!
! Generate one-dimensional pair of arrays (xra,yra) which contain
! perimeter of two-dimensional curvilinear grid (x,y) which may be
! either in geographic spherical coordinates (x=lon, y=lat) or on
! a flat plane. In both cases (xra,yra) are in "user" coordinate
! system, so if (x,y) are in spherical coordinates, perimeter
! points are transformed according to map projection rules.
!
      implicit none
      logical spherical
      integer im,jm, i,j,shft
      real x(im,jm), y(im,jm), xra(2*(im+jm-2)+1),yra(2*(im+jm-2)+1)
#if VERBOSE > 2
        write(*,'(2x,2A,1x,L1,1x,A$)') 'Enter domain_contour, ',
     &                           'spherical =', spherical, '...'
#endif
      if (spherical) then
        do i=1,im-1
          call maptrn (y(i,1),x(i,1),    xra(i),yra(i))
        enddo
        shft=im-1
        do j=1,jm-1
          call maptrn (y(im,j),x(im,j),  xra(shft+j),yra(shft+j))
        enddo
        shft=2*im+jm-1
        do i=im,2,-1
          call maptrn (y(i,jm),x(i,jm),  xra(shft-i),yra(shft-i))
        enddo
        shft=2*(im+jm-1)
        do j=jm,2,-1
          call maptrn (y(1,j),x(1,j),    xra(shft-j),yra(shft-j))
        enddo
      else
        do i=1,im-1
          xra(i)=x(i,1)
          yra(i)=y(i,1)
        enddo
        shft=im-1
        do j=1,jm-1
          xra(shft+j)=x(im,j)
          yra(shft+j)=y(im,j)
        enddo
        shft=2*im+jm-1
        do i=im,2,-1
          xra(shft-i)=x(i,jm)
          yra(shft-i)=y(i,jm)
        enddo
        shft=2*(im+jm-1)
        do j=jm,2,-1
          xra(shft-j)=x(1,j)
          yra(shft-j)=y(1,j)
        enddo
      endif
      xra(shft-1)=xra(1)
      yra(shft-1)=yra(1)
#if VERBOSE > 2
      write(*,'(1x,A)') '...return from domain_contour.'
#endif
      return
      end
      subroutine perim_bounds (im,jm, x,y, xmin,xmax,ymin,ymax)
      implicit none
      integer im,jm, i,j
      real x(im,jm),y(im,jm), xmin,xmax,ymin,ymax

      xmin=x(1,1)                    ! Scan along the perimeter of
      xmax=x(1,1)                    ! curvilinear grid  in order to
      ymin=y(1,1)                    ! find extreme points in western
      ymax=y(1,1)                    ! eastern, southern and northern
      do i=2,im-1                    ! direction. This is needed to
        xmin=min(xmin,x(i,1))        ! allow automatic adjustment of
        xmax=max(xmax,x(i,1))        ! viewport in order to achieve
        ymin=min(ymin,y(i,1))        ! maximum plot size, while
        ymax=max(ymax,y(i,1))        ! respecting horizontal
      enddo                          ! aspect ratio.
      do j=1,jm-1
        xmin=min(xmin,x(im,j))
        xmax=max(xmax,x(im,j))
        ymin=min(ymin,y(im,j))
        ymax=max(ymax,y(im,j))
      enddo
      do i=im,2,-1
        xmin=min(xmin,x(i,jm))
        xmax=max(xmax,x(i,jm))
        ymin=min(ymin,y(i,jm))
        ymax=max(ymax,y(i,jm))
      enddo
      do j=jm,2,-1
        xmin=min(xmin,x(1,j))
        xmax=max(xmax,x(1,j))
        ymin=min(ymin,y(1,j))
        ymax=max(ymax,y(1,j))
      enddo
#if VERBOSE > 2
      write(*,*) 'perim_bounds:', xmin,xmax,ymin,ymax
#endif
      return
      end



