      subroutine depth_lab (idfld, level, botlab)
!
! Creates bottom label of the current field. The bottom label
! consists of the field name and the depth (or level) of the field.
!
! Input:  idfld    Identification of current field (integer).
!         level    Depth (>0), level (>0), or isopycnal (>1000)
!                       to process (real).
!
! Output: botlab   Bottom label (character).
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "fldsid.h"
#include "pltfld.h"

      real level
      integer idfld, lenfld, lstr, lenstr
      character botlab*(*), dpthlab*20
!
! PE classification field.
!
      levless=is2d(idfld)
      if (levless) then
         dpthlab='                    '
      elseif (level.le.-1000.) then
         write (dpthlab,'(A,F7.1,1x,A)') 'at', abs(level), 'm'
      elseif (level.le.-100.) then
         write (dpthlab,'(A,F6.1,1x,A)') 'at', abs(level), 'm'
      elseif (level.le.0.) then
         write (dpthlab,'(A,F5.1,1x,A)') 'at', abs(level), 'm'
      elseif (level.lt.10.) then
         write(dpthlab,'(A,I2)') 'at Level', int(level)
      elseif (level.lt.100.) then
         write(dpthlab,'(A,I3)') 'at Level', int(level)
      elseif (level.gt.1000.) then
         write (dpthlab,'(A,F6.2)') 'at Isopycnal', level-1000. 
      else
         dpthlab='                    ' 
      endif
!
! Get field label and generate bottom label.
!
      lstr=lenstr(dpthlab)
      lenfld=lenstr(vlabel(idfld))
      if (lstr.ne.0) then
        botlab=vlabel(idfld)(1:lenfld)/ /' '/ /dpthlab(1:lstr)
      else
        botlab=vlabel(idfld)(1:lenfld)
      endif
      return
      end
